<?php /**
* 
*/
class Received extends CI_Controller
{
	function index()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
		{
			//$fields = array('product_id', 'product_name', 'unit_large', 'unit_small', 'Conversion');
			if($data->Reports->viewtype == 'total')
				$this->viewTotal($data->Reports);
			else if($data->Reports->viewtype == 'monthly')
				$this->viewMonthly($data->Reports);
			else
				$this->viewDaily($data->Reports);
		}
	}

	function runQuery($_sql, $data)
	{
		$sql = "SELECT B.product_id, C.product_code, C.product_name, C.unit_large, C.unit_small, C.Conversion, fc_format_number(SUM(B.qty)) AS `total` ".$_sql."
				FROM `outlet_purchase_receives` A INNER JOIN `outlet_purchase_receive_details` B ON A.id = B.pr_id 
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE A.closing_date BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".((isset($data->outlet_id)) && ($data->outlet_id * 1) > 0 ? " AND A.outlet_id = ".$data->outlet_id : '')." 
				GROUP BY B.product_id, C.product_code, C.product_name, C.unit_large, C.unit_small, C.Conversion
				ORDER BY C.product_name";
		return $this->db->query($sql)->result();
	}
	
	function viewTotal($data)
	{
		$result = $this->runQuery('', $data);
		echo json_encode(array('fields'=>array(), 'field_values'=>$result));
	}
	
	function viewMonthly($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ym');
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m') = '".$_newDate->format('Ym')."' THEN B.qty ELSE 0 END)) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewDaily($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ymd');
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN B.qty ELSE 0 END)) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
} ?>