app.controller('SoController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $http.get(url_base+"wh_so/soView").success(function (records) {
    $scope.wh_so = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_so.length;
    $scope.totalItems = $scope.wh_so.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('SoDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    $http.get(url_base+'wh_so/soViewDetailHeader/'+id).success(function (records){
      $scope.soDetailHeader = records;
      $scope.codeSoSelected = $scope.soDetailHeader[0]['so_code'];
      $scope.dateSoSelected = $scope.soDetailHeader[0]['so_date'];
      $scope.orderSelected = $scope.soDetailHeader[0]['code'];
      $scope.atSelected = $scope.soDetailHeader[0]['createdat'];  
      $scope.bySelected = $scope.soDetailHeader[0]['full_name'];  
      $scope.distinctItem =  $scope.soDetailHeader[0]['item_count'];  
      $scope.countTotal =  $scope.soDetailHeader[0]['total_item_qty'];  
    });

    $http.get(url_base+'wh_so/soViewDetail/'+id).success(function (records){
      $scope.soDetail = records;
    });
  }
]);

app.controller('SoNewController', function($scope,$http, $timeout) {
  $scope.productList = [];
  $scope.outletCode = '';
  $scope.searchCode = '';
  $scope.searchName = '';
  $scope.notes = '';
  $scope.distinctItem = 0;
  $scope.countTotal = 0;
  $("#masking").hide();
  $("#divList").hide();
  $("#divNotif").hide();

  /*$http.get(url_base+"po/storageView").success(function (records){
    $scope.storageList = records;
  });*/

  $("#datepickerSo").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerSo").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $(window).resize(function(){
    if ($(window).width() < 752){
      $("#divExtend").height(80);
    }
    else{
      $("#divExtend").height(0);
    }
  });

  $http.get(url_base+"wh_so/outletView").success(function (records){
    $scope.outletList = records; 
  });

  $http.get(url_base+"wh_do/categoryView").success(function (records){
    $scope.categoryList = records; 
  });

  $http.get(url_base+"wh_do/groupView").success(function (records){
    $scope.groupList = records; 
  });

  function isExist(id){
    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      count = parseFloat($scope.productList[i]['quantity']) + parseFloat(count);
    };

    return count;
  };

  /*function parsingDate(date) {
    var identify1 = date.substring(2,3);
    var identify2 = date.substring(5,6);
    if (identify1 == '/' && identify2 == '/'){
      if (date == '') {
        return '';
      }
      else {
        var dd = date.substring(3,5);
        var mm = date.substring(0,2);
        var yyyy = date.substring(6,10);
        var parsing = yyyy+"-"+mm+"-"+dd;

        return parsing;
      }
    }
    else{
      return date;
    }
  }*/

  $scope.searchProductList = function(code,name) {
    var category = $("#categorySelected").val();
    var group = $("#groupSelected").val();

    $http.get(url_base+"wh_so/searchProductView?code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
      $scope.products = records;
    });
  };

  $scope.addProduct = function(id,name,unitL) {
    var pId = "p"+id;
    $scope.productName = name;
    $scope.unitL = unitL;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addCount = function(quantity) {
      if ($scope.countSo > 0) {
        if (isExist(id) == false) {
          $scope.productList.push({"id":id,"name":name,"unitL":unitL,"quantity":quantity});
        }
        else {
          for (var i = $scope.productList.length - 1; i >= 0; i--) {
            if ($scope.productList[i].id == id) {
              var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

              $scope.productList[i].quantity = qty;
              $("#"+pId).val(qty);
            };
          };
        };

        $scope.distinctItem = $scope.productList.length;
        $scope.countTotal = count();
        $scope.countSo = '';
        $("#masking").hide();
      }
      else{
        $.growl.notice({ message: "Jumlah harus diatas 0" });
      };
    };
  };

  $scope.updateCount = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].quantity = newVal;
        $("#"+pId).val(newVal);
        $scope.countTotal = count();
      };
    };
  };

  $scope.deleteProduct = function(index) {
    $scope.productList.splice(index,1);
    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
  };

  $scope.saveSalesOrder = function(isgen,status) {
    var dateSo = $("#datepickerSo").val();
    var outletId = $("#outletSelected").val()
    var notes = $scope.notes;
    var shipPartial = $('input[name=shipPartial]:checked').val();
    
    if (dateSo === ''){
      $.growl.warning({ message: 'Tanggal SO belum diisi' });
    }
    else if (outletId === ''){
      $.growl.warning({ message: 'Kode Outlet harus diisi' });
    }
    else if (shipPartial != 0 && shipPartial != 1){
      $.growl.warning({ message: 'Kirim parsial harus diisi' });
    }
    else if ($scope.productList.length == 0){
      $.growl.warning({ message: 'Data produk belum diisi' });
    }
    else {
      if(!isgen){
        if (status == 'save') {
          $scope.loading = true; 
        }
        else {
          $scope.loading2 = true; 
        }
      };

      $scope.productHeader = {"shipPartial":shipPartial,"outletId":outletId,"dateSo":dateSo,"notes":notes,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal,"status":status};

      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);

      $.ajax({
        type: 'post',
        url:url_base+'wh_so/saveSalesOrder',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"wh_so/getNotif").success(function (records) {
                  $scope.dateSoNotif = records[0]['so_date'];
                  $scope.codeNotif = records[0]['so_code'];
                  $scope.orderNotif = records[0]['code'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };
  
  $scope.showDivList = function() {
    $http.get(url_base+"wh_so/productView").success(function (records){
      $scope.products = records; 
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.products.length;
      $scope.totalItems = $scope.products.length;

      window.scrollTo(0,0);
      $("#divMain").hide();
      $("#divList").css({top:-80,left:0,position:"absolute"});
      $("#divList").css("z-index","9998");
      $("#divList").show(function(){
        $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
      
        if ($(window).width() < 752){
          $("#divExtend").height(80);
        }
        else{
          $("#divExtend").height(0);
        }
      });
    });
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.searchCode = '';
    $scope.searchName = '';
    $("#categorySelected").val("");
    $("#groupSelected").val("");
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.countDo = '';
  };
});

app.controller('SoEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;
    $("#masking").hide();
    $("#divList").hide();

    function isExist(id){
      for (var i = $scope.soDetail.length - 1; i >= 0; i--) {
        if ($scope.soDetail[i].product_id == id) {
          return true;
        };
      };
      return false;
    };

    function count(){
      var count = 0;

      for (var i = $scope.soDetail.length - 1; i >= 0; i--) {
        count = parseFloat($scope.soDetail[i]['qty']) + parseFloat(count);
      };

      return count;
    };

    $http.get(url_base+'wh_so/soViewDetailHeader/'+id).success(function (records){
      $scope.soDetailHeader = records;
      $scope.codeSoSelected = $scope.soDetailHeader[0]['so_code'];
      $scope.dateSoSelected = $scope.soDetailHeader[0]['so_date'];
      $scope.orderSelected = $scope.soDetailHeader[0]['code'];
      $scope.atSelected = $scope.soDetailHeader[0]['createdat'];  
      $scope.bySelected = $scope.soDetailHeader[0]['full_name'];  
      $scope.distinctItem =  $scope.soDetailHeader[0]['item_count'];  
      $scope.countTotal =  $scope.soDetailHeader[0]['total_item_qty'];  
    });

    $http.get(url_base+'wh_so/soViewDetailEdit/'+id).success(function (records){
      $scope.soDetail = records;
    });

    $scope.showDivList = function() {
      $http.get(url_base+"wh_so/productView").success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList").css({top:-80,left:0,position:"absolute"});
        $("#divList").css("z-index","9998");
        $("#divList").show(function(){
          $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend").height(80);
          }
          else{
            $("#divExtend").height(0);
          }
        });
      });
    };

    $scope.showDivMain = function() {
      $("#divMain").show();
      $("#divList").hide();
      $scope.searchCode = '';
      $scope.searchName = '';
      $("#categorySelected").val("");
      $("#groupSelected").val("");
    };

    $scope.hideDivCount = function() {
      $("#masking").hide();
      $scope.countDo = '';
    };

    $scope.addProduct = function(id,name,unitL,code) {
      var pId = "p"+id;
      $scope.productName = name;
      $scope.unitL = unitL;

      $("#masking").css({top:0,left:0,position:"absolute"});
      $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
      $("#masking").css("z-index","9999");
      $("#masking").show();

      var x = $(window).scrollTop();
      var y = $("#masking").width();
      var z = $("#divCount").width();
      $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

      $("#autofocus").focus();

      $scope.addCount = function(quantity) {
        if ($scope.countSo > 0) {
          if (isExist(id) == false) {
            $scope.soDetail.push({"product_id":id,"product_name":name,"unit_large":unitL,"qty":quantity,"product_code":code});
          }
          else {
            for (var i = $scope.soDetail.length - 1; i >= 0; i--) {
              if ($scope.soDetail[i].product_id == id) {
                var qty = parseFloat($scope.soDetail[i].qty) + parseFloat(quantity);

                $scope.soDetail[i].qty = qty;
                $("#"+pId).val(qty);
              };
            };
          };

          $scope.distinctItem = $scope.soDetail.length;
          $scope.countTotal = count();
          $scope.countSo = '';
          $("#masking").hide();
        }
        else{
          $.growl.notice({ message: "Jumlah harus diatas 0" });
        };
      };
    };

    $scope.updateCount = function(id){
      var pId = "p"+id;
      var newVal = $("#"+pId).val();

      if (newVal == ''){
        newVal = 0;
      }

      for (var i = $scope.soDetail.length - 1; i >= 0; i--) {
        if ($scope.soDetail[i].product_id == id) {
          $scope.soDetail[i].qty = newVal;
          $("#"+pId).val(newVal);
          $scope.countTotal = count();
        };
      };
    };

    $scope.deleteProduct = function(index) {
      $scope.soDetail.splice(index,1);
      $scope.distinctItem = $scope.soDetail.length;
      $scope.countTotal = count();
    };

    $scope.saveEditSalesOrder = function(isgen,status) {
      if ($scope.soDetail.length == 0){
        $.growl.warning({ message: 'Data produk belum diisi' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        $scope.productHeader = {"soId":$routeParams.id,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal};

        var json = JSON.stringify($scope.soDetail);
        var json2 = JSON.stringify($scope.productHeader);

        $.ajax({
          type: 'post',
          url:url_base+'wh_so/saveEditSalesOrder',
          data: "json="+json+"&json2="+json2,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data BERHASIL diEdit" });
                } else {
                  $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Data GAGAL diEdit. <br/>Cek koneksi internet dan ulangi Lagi !" });
            },1000);
          } 
        });
      }
    };
  }
]);