app.controller('SoSalesHistoryController', function($scope,$http, $timeout) {
  $scope.tempStock = [];
  $scope.tempStock2 = [];

  $('#file-upload2').change(function() {
    var i = $(this).prev('label').clone();
    var file = $('#file-upload2')[0].files[0].name;
    $(this).prev('label').text(file);

    $scope.file2 = file;
  });

  function convertToRp(input){
    if (input == null) {
      return input;
    }
    else {
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }
  }

  $http.get(url_base+"so_sales/salesList").success(function (records) {
    $scope.salesHeader = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.salesHeader.length;
    $scope.totalItems = $scope.salesHeader.length;

    for (var i = records.length - 1; i >= 0; i--) {
      $scope.salesHeader[i]['p_status2'] = 'process status = '+records[i]['status2'];
      $scope.salesHeader[i]['p_status3'] = 'price status = '+records[i]['status3'];
      $scope.salesHeader[i]['referenceRp'] = convertToRp($scope.salesHeader[i]['reference']);
    }
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };

  $scope.StockImport = function (event) {
    var input = event.target;
    var reader = new FileReader();

    reader.onload = function(){
      var fileData = reader.result;
      var wb = XLSX.read(fileData, {'type':'binary'});
      wb.SheetNames.forEach(function(sheetName){
        var rowObj = XLSX.utils.sheet_to_json(wb.Sheets[sheetName],{header:"A",defval:""});
        var jsonObj = JSON.stringify(rowObj);
        console.log(jsonObj);

        $scope.tempStock = rowObj;
        alert($scope.tempStock.length);
      })
    };
    reader.readAsBinaryString(input.files[0]);

    $http.get(url_base+"so_sales/detailStock").success(function (records) {
      $scope.detailStock = records;
      alert('ok');
    });
  };

  $scope.validateOrder = function(isgen,status) {
    if ($scope.tempStock.length == 0){
      $.growl.warning({ message: 'Empty data' });
    }
    else if ($scope.detailStock.length == 0){
      $.growl.warning({ message: 'All order validated' });
    }
    else if ($scope.file2.substring(0,4) != 'ST01'){
      $.growl.warning({ message: 'File is not valid' });
    }
    else { 
      if(!isgen){
        $scope.loading = true; 
      };

      for (var i = $scope.tempStock.length - 1; i > 0; i--) {
        for (var j = $scope.detailStock.length - 1; j >= 0; j--) {
          if ($scope.tempStock[i].C == $scope.detailStock[j].kd_lokasi && $scope.tempStock[i].D == $scope.detailStock[j].kodeprod) {
            if (parseFloat($scope.tempStock[i].H) + parseFloat($scope.tempStock[i].I) + parseFloat($scope.tempStock[i].J) - parseFloat($scope.tempStock[i].K) - parseFloat($scope.tempStock[i].L) < parseFloat($scope.detailStock[j].qty)) {
              $scope.tempStock2.push({"isValid":"1","no_so":$scope.detailStock[j].no_so,"kd_lokasi":$scope.tempStock[i].C,"kodeprod":$scope.tempStock[i].D,"satuan":$scope.detailStock[j].satuan,"p_disc":$scope.detailStock[j].p_disc});
            }
            else {
              $scope.tempStock2.push({"isValid":"0","no_so":$scope.detailStock[j].no_so,"kd_lokasi":$scope.tempStock[i].C,"kodeprod":$scope.tempStock[i].D,"satuan":$scope.detailStock[j].satuan,"p_disc":$scope.detailStock[j].p_disc});  
            }
          }
        }
      };

      var json = JSON.stringify($scope.tempStock2);

      alert($scope.tempStock2.length);
      
      $.ajax({
        type: 'post',
        url:url_base+'so_sales/validateOrder/',
        data: "json="+json,
        success: function(msg){
          //alert(msg);
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                
                $http.get(url_base+"so_sales/salesList").success(function (records) {
                  $scope.salesHeader = records;
                  $scope.currentPage = 1;
                  $scope.entryLimit = 25;
                  $scope.filteredItems = $scope.salesHeader.length;
                  $scope.totalItems = $scope.salesHeader.length;
                });           

                $.growl.notice({ message: "Stock validated" });
                $scope.tempStock = [];
                $scope.tempStock2 = [];
                $scope.detailStock = [];
                $('#file-upload2').prev('label').text('Select file');
              } 
              else {
                $.growl.error({ message: "Import failed. Try again !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Import failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }
  };

  $scope.clearOrder = function(isgen,status) {
    var d = new Date();
    d.setHours(16,0,0,0);

    var n = new Date();

    if (Math.floor(d) < n.getTime()){
      $http.get(url_base+"so_sales/todayTrans").success(function (records) {
        $scope.todayTrans = records;

        if ($scope.todayTrans['today_so'] == 0){
          $.growl.warning({ message: 'All order cleared' });
        }
        else { 
          if(!isgen){
            $scope.loading2 = true; 
          };
          
          $.ajax({
            type: 'post',
            url:url_base+'so_sales/clearOrder/',
            success: function(msg){
              //alert(msg);
              var obj = JSON.parse(msg);
              $timeout(function(){
                if(!isgen){
                  $scope.loading2 = false;
                  if (obj.status == 'sukses') {
                    
                    $http.get(url_base+"so_sales/salesList").success(function (records) {
                      $scope.salesHeader = records;
                      $scope.currentPage = 1;
                      $scope.entryLimit = 25;
                      $scope.filteredItems = $scope.salesHeader.length;
                      $scope.totalItems = $scope.salesHeader.length;

                      for (var i = records.length - 1; i >= 0; i--) {
                        $scope.salesHeader[i]['p_status2'] = 'process status = '+records[i]['status2'];
                        $scope.salesHeader[i]['p_status3'] = 'price status = '+records[i]['status3'];
                        $scope.salesHeader[i]['referenceRp'] = convertToRp($scope.salesHeader[i]['reference']);
                      }
                    });           

                    $.growl.notice({ message: "Today's order up to 4 P.M Cleared" });
                    $scope.tempStock = [];
                    $scope.tempStock2 = [];
                    $scope.detailStock = [];
                    //$('#file-upload2').prev('label').text('Select file');
                  } 
                  else {
                    $.growl.error({ message: "Import failed. Try again !" });
                  };
                }
              },1000);
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
              $timeout(function(){
                if(!isgen){
                  $scope.loading2 = false;
                }
                $.growl.error({ message: "Import failed. <br/>Check connection and try again !" });
              },1000);
            } 
          });
        }
      });
    }
    else {
      $.growl.warning({ message: "Can only be pressed after 4 P.M" });
    }
    
  };

});

app.controller('SoSalesViewController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    function count(){
      var count = 0;

      for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {
        count = parseFloat($scope.salesDetail[i]['total']) + parseFloat(count);
      };

      return count;
    };

    function convertToRp(input){
      if (input == null) {
        return input;
      }
      else {
        var rp = '';    
        input = parseFloat(input).toFixed(2);
        var angkarev = input.toString().split('').reverse().join('');
        var dec = angkarev.substr(0,2).split('').reverse().join('');
        var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

        angkarev = num.toString().split('').reverse().join('');

        for(var i = 0; i < angkarev.length; i++){
          if(i%3 == 0){
            rp += angkarev.substr(i,3)+'.';
          } 
        } 

        var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

        if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
          output = '-'+output.substr(2,output.length-2);
        }

        return output;
      }
    }

    $http.get(url_base+'so_sales/salesHeaderSelected/'+id).success(function (records){
      $scope.soIdSelected = records[0]['no_so'];
      $scope.soDateSelected = records[0]['tg_so'];
      $scope.soCustomerSelected = records[0]['namalang'];
      $scope.soDurationSelected = records[0]['lama_byr'];
      /*$scope.soValueSelected = records[0]['nldokacu'];*/
      $scope.soDueDateSelected = records[0]['jt_tempo'];
      $scope.soStatusSelected = records[0]['status2'];
      $scope.soStatus2Selected = records[0]['status3'];

      $scope.soCustomer2Selected = records[0]['kodelang'];
      $scope.soNildokSelected = records[0]['nildok'];
      $scope.soNildokRpSelected = convertToRp($scope.soNildokSelected);
    });

    $http.get(url_base+'so_sales/customerListEdit').success(function (records){
      $scope.customerList = records;
    });

    $http.get(url_base+'so_sales/salesDetailSelected/'+id).success(function (records){
      $scope.salesDetail = records;

      for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {
        $scope.salesDetail[i]['hargaRp'] = convertToRp($scope.salesDetail[i]['harga']);
        $scope.salesDetail[i]['nettoRp'] = convertToRp($scope.salesDetail[i]['netto']);
      };

      $scope.distinctItem = $scope.salesDetail.length;
      $scope.countTotal = count();
    });

    $scope.editSales = function(isgen,status,view) {
      if ($scope.soStatusSelected == ''){
        $.growl.warning({ message: 'Empty field' });
      }
      else if ($scope.soStatus2Selected != '0' && $scope.soStatus2Selected != '1' && $scope.soStatus2Selected != 'X'){
        $.growl.warning({ message: 'Status price is not valid' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };
  
        $scope.salesHeaderSelected = {"no_so":$scope.soIdSelected,"status2":$scope.soStatusSelected,"status3":$scope.soStatus2Selected,"customerid":$scope.soCustomer2Selected};
        var json = JSON.stringify($scope.salesHeaderSelected);

        $.ajax({
          type: 'post',
          url:url_base+'so_sales/editSales',
          data: "json="+json,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data saved" });
                  if (view == 0){
                    location.href = "#/salesHistoryX";
                  }
                  else {
                    location.href = "#/salesHistory";
                  }
                } 
                else {
                  $.growl.error({ message: "Update failed. Try again !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
            },1000);
          } 
        });
      }
    };
  }


]);

app.controller('SoSalesNewController', function($scope,$http, $timeout,$window) {
  $scope.product = [];
  $scope.product2 = [];
  $scope.salesDetail = [];
  $scope.salesDetailtempStock = [];
  $scope.distinctItem = 0;
  $scope.countTotal = 0;
  $scope.totalPrice = 0;
  $scope.soPaymentDuration = '';
  //$scope.soPaymentValue = '';
  $scope.qrcode = '';
  $("#divCount").hide();
  $("#divList").hide();

  function curDate(){
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1;
    var yyyy = today.getFullYear();

    if (dd < 10){
      dd = '0'+dd;
    };

    if (mm < 10){
      mm = '0'+mm;
    };  

    today = yyyy+'-'+mm+'-'+dd; 

    return today;
  }

  function convertToRp(input){
    if (input == null) {
      return input;
    }
    else {
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }
  }

  $scope.soSalesDate = curDate();

  function isExist(id,type){
    for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {
      if ($scope.salesDetail[i].kodeprod == id && $scope.salesDetail[i].al_kemas == type) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {
      count = parseFloat($scope.salesDetail[i]['total']) + parseFloat(count);
    };

    return count;
  };

  function total(){
    var total = 0;

    for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {
      total = parseFloat($scope.salesDetail[i]['subtotal']) + parseFloat(total);
    };

    return total;
  };

  $http.get(url_base+'so_sales/customerList').success(function (records){
    $scope.customerList = records;
  });

  $scope.openQRCamera = function(node) {
    var reader = new FileReader();
    reader.onload = function() {
      node.value = "";
      qrcode.callback = function(res) {
        if(res instanceof Error) {
          $.growl.warning({ message: "No QR code found. Please make sure the QR code is within the camera's frame and try again." });
        } else {
          node.parentNode.previousElementSibling.value = res;
          $scope.qrcode = res;

          var isActive = 0;

          for (var i = $scope.customerList.length - 1; i >= 0; i--) {
            if ($scope.customerList[i]['kodelang'] == res){
              $scope.soCustomer = res+'|'+$scope.customerList[i]['status'];
              $scope.soCustomerName = $scope.customerList[i]['namalang'];
              $scope.$apply();

              isActive = 1;
              break;
            }
          };

          if (isActive == 0){
            $.growl.warning({ message: "Customer not found" });
            $scope.soCustomer = null;
            $scope.soCustomerName = '-';
            $scope.$apply();
          }
          else {
            $.growl.notice({ message: "QR scanned" });
          }
        }
      };
      qrcode.decode(reader.result);
    };
    reader.readAsDataURL(node.files[0]);
  }

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;
    }, 50);
  };

  $scope.showDivList = function() {
    if ($scope.soCustomer === undefined || $scope.soCustomer == ''){
      $.growl.notice({ message: "Choose customer" });
    }
    else {
      //alert($scope.qrcode);
      $('#divList').modal({
        backdrop:false,
      });

      $('#productFilter').focus();

      $http.get(url_base+'so_product/productList2').success(function (records){
        $scope.product = records;

        for (var i = $scope.product.length - 1; i >= 0; i--) {
          $scope.product[i]['hg_khs_rp'] = convertToRp($scope.product[i]['hg_khs']);
          $scope.product[i]['hg_std_rp'] = convertToRp($scope.product[i]['hg_std']);
          $scope.product[i]['hg_std2_rp'] = convertToRp($scope.product[i]['hg_std2']);
          $scope.product[i]['hg_std3_rp'] = convertToRp($scope.product[i]['hg_std3']);
        };

        /*var tempStock = '';
        var j = 0;
        var k = 0;

        for (var i = 0; i < $scope.product.length; i++){
          if (tempStock != $scope.product[i]['kodeprod']){
            $scope.product2[j] = {kodeprod:$scope.product[i]['kodeprod'],namaprod:$scope.product[i]['namaprod'],line:$scope.product[i]['line'],span:0,detail:[]};
            tempStock = $scope.product[i]['kodeprod'];
            j++;
            k = 0;
          }

          $scope.product2[j-1]['detail'][k] = {al_kemas:$scope.product[i]['al_kemas'],kemasan:$scope.product[i]['kemasan'],satuan:$scope.product[i]['satuan']};
          k++;

          $scope.product2[j-1]['span'] = k+1;
        }*/

        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.product.length;
        $scope.totalItems = $scope.product.length;
      });
    }
  };

  $scope.addProduct = function(id,name,line,h1,h2,h3,h4,u1,u2) {
    $scope.productId = id;
    $scope.productName = name;
    $scope.productPackage = '';
    $scope.productUnit = 0;

    $http.get(url_base+'so_product/stockSelected/'+id).success(function (records){
      $scope.productStock = records[0]['stock'];

      $http.get(url_base+'so_product/packageSelected/'+id).success(function (records){
        $scope.productPackageList = records;

        $('#divCount').modal({show:true,backdrop:false,});
        $("#autofocus").focus();

        $scope.addCount = function(quantity) {
          if ($scope.count > 0 && $scope.productUnit > 0) {
            if ($scope.soCustomer != null){
              var splitTemp = $scope.soCustomer.split("|");
              var customerStatusTemp = splitTemp[1];

              if (splitTemp[1] === undefined){
                var customerStatusTemp = 'X';
              }
            }

            if (customerStatusTemp == 'X'){
              var hrg = h4;
            }
            else if (customerStatusTemp == '0') {
              if (quantity*$scope.productUnit < u1) {
                var hrg = h4;
              }
              else if (quantity*$scope.productUnit >= u1 && quantity*$scope.productUnit < u2) {
                var hrg = h3;
              }
              else {
                var hrg = h2;
              }
            }
            else {
              var hrg = h1;
            }

            if (isExist(id,$scope.productPackageId) == false) {
              $scope.salesDetail.push({"kodeprod":id,"namaprod":name,"al_kemas":$scope.productPackageId,"kemasan":$scope.productPackage,"satuan":$scope.productUnit,"jumlah":quantity,"total":quantity*$scope.productUnit,"harga":hrg,"hargaRp":convertToRp(hrg),"subtotal":quantity*$scope.productUnit*hrg,"subtotalRp":convertToRp(quantity*$scope.productUnit*hrg),"line":line});
            }
            else {
              for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {
                if ($scope.salesDetail[i].kodeprod == id && $scope.salesDetail[i].al_kemas == $scope.productPackageId) {
                  var qty = parseFloat($scope.salesDetail[i].jumlah) + parseFloat(quantity);

                  $scope.salesDetail[i].jumlah = qty;
                  $scope.salesDetail[i].total = parseFloat(qty) * parseFloat($scope.salesDetail[i].satuan);
                  $scope.salesDetail[i].subtotal = parseFloat(qty) * parseFloat($scope.salesDetail[i].satuan) * parseFloat($scope.salesDetail[i].harga);
                  $scope.salesDetail[i].subtotalRp = convertToRp($scope.salesDetail[i].subtotal);
                  $("#p"+i).val(qty);
                };
              };
            };

            $scope.distinctItem = $scope.salesDetail.length;
            $scope.countTotal = count();
            $scope.totalPrice = total();
            $scope.totalPriceRp = convertToRp($scope.totalPrice);
            $scope.count = '';
            $scope.productStock = '';
            $scope.soPackage = '';
            $scope.search = '';
            $("#divCount").modal('hide');
            $('#productFilter').focus();
            $scope.productPackageList = [];
          }
          else{
            $.growl.notice({ message: "Qty & Unit must be higher than 0" });
          };
        };
      });
    });

  };

  $scope.changePackage = function() {
    var package = $("#packageSelected").val();

    if (package != null){
      var split = $("#packageSelected").val().split("|");
      $scope.productPackageId = split[0];
      $scope.productPackage = split[1];
      $scope.productUnit = split[2];
    }
  };

  $scope.updateCount = function(index,id,type){
    var pId = "p"+index;
    var newVal = $("#"+pId).val();

    for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {
      if ($scope.salesDetail[i].kodeprod == id && $scope.salesDetail[i].al_kemas == type) {
        $scope.salesDetail[i].jumlah = newVal;
        $scope.salesDetail[i].total = parseFloat($scope.salesDetail[i].jumlah) * parseFloat($scope.salesDetail[i].satuan);
        $scope.salesDetail[i].subtotal = parseFloat($scope.salesDetail[i].jumlah) * parseFloat($scope.salesDetail[i].satuan) * parseFloat($scope.salesDetail[i].harga);
        $scope.salesDetail[i].subtotalRp = convertToRp($scope.salesDetail[i].subtotal);
        $("#"+pId).val(newVal);
        $scope.countTotal = count();
        $scope.totalPrice = total();
        $scope.totalPriceRp = convertToRp($scope.totalPrice);
      };
    };
  };

  $scope.deleteProduct = function(index) {
    $scope.salesDetail.splice(index,1);
    $scope.distinctItem = $scope.salesDetail.length;
    $scope.countTotal = count();
    $scope.totalPrice = total();
    $scope.totalPriceRp = convertToRp($scope.totalPrice);
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $('#divList').modal('hide');
    $scope.search = '';
  };

  $scope.hideDivCount = function() {
    $("#divCount").modal('hide');
    $scope.count = '';
    $scope.productStock = '';
    $scope.soPackage = '';
    $("#packageSelected").val('');
    $('#productFilter').focus();
  };

  $scope.saveSales = function(isgen,status,view) {
    var valid = 0;
    var total = 0;
    var customer = $scope.soCustomer;

    if (customer != null){
      var split = $scope.soCustomer.split("|");
      var customerId = split[0];
      var customerStatus = split[1];

      if (split[1] === undefined){
        var customerId = 'OFFICE';
        var customerStatus = 'X';
        $scope.qrcode = 'OFFICE';
      }
    }

    for (var i = $scope.salesDetail.length - 1; i >= 0; i--) {  
      if ($scope.salesDetail[i].jumlah > 0) {
        valid = 0;
      }
      else {
        valid = 1;
        break;
      }
    };

    if (valid == 1){
      $.growl.warning({ message: 'Empty or Zero value' });
    }
    else if (customer === null){
      $.growl.warning({ message: 'Choose customer' });
    }
    else if ($scope.soPaymentDuration == ''){
      $.growl.warning({ message: 'Fill payment duration field' });
    }
    /*else if ($scope.soPaymentValue == ''){
      $.growl.warning({ message: 'Fill payment value field' });
    }*/
    else if ($scope.salesDetail.length == 0){
      $.growl.warning({ message: 'Empty product list' });
    }
    /*else if ($scope.qrcode == ''){
      $.growl.warning({ message: 'Scan QR Code!!' });
    }
    else if ($scope.qrcode != customerId){
      $.growl.warning({ message: 'QR does not match with customer' });
    }*/
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      for (var k = 1; k >= 0; k--) {  
        $scope.salesDetailtempStock = [];
        total = 0;

        if (k == 1) {
          for (var l = $scope.salesDetail.length - 1; l >= 0; l--) { 
            if ($scope.salesDetail[l].line == 1) {
              //$scope.salesDetailtempStock.push($scope.salesDetail[l]);
              $scope.salesDetailtempStock.push({"kodeprod":$scope.salesDetail[l].kodeprod,"namaprod":$scope.salesDetail[l].namaprod,"al_kemas":$scope.salesDetail[l].al_kemas,"kemasan":$scope.salesDetail[l].kemasan,"satuan":$scope.salesDetail[l].satuan,"jumlah":$scope.salesDetail[l].jumlah,"total":$scope.salesDetail[l].total,"harga":$scope.salesDetail[l].harga,"line":$scope.salesDetail[l].line});
            }
          }
        }
        else {
          for (var l = $scope.salesDetail.length - 1; l >= 0; l--) { 
            if ($scope.salesDetail[l].line != 1) {
              //$scope.salesDetailtempStock.push($scope.salesDetail[l]);
              $scope.salesDetailtempStock.push({"kodeprod":$scope.salesDetail[l].kodeprod,"namaprod":$scope.salesDetail[l].namaprod,"al_kemas":$scope.salesDetail[l].al_kemas,"kemasan":$scope.salesDetail[l].kemasan,"satuan":$scope.salesDetail[l].satuan,"jumlah":$scope.salesDetail[l].jumlah,"total":$scope.salesDetail[l].total,"harga":$scope.salesDetail[l].harga,"line":$scope.salesDetail[l].line});
            }
          }
        }

        if ($scope.salesDetailtempStock.length != 0) {
          for (var i = $scope.salesDetailtempStock.length - 1; i >= 0; i--) {  
            for (var j = $scope.product.length - 1; j >= 0; j--) {  
              if ($scope.salesDetailtempStock[i].kodeprod == $scope.product[j].kodeprod) {
                if (customerStatus == '0'){
                  if ($scope.salesDetailtempStock[i].total < $scope.product[j].unit_std2) {
                    $scope.salesDetailtempStock[i].harga = $scope.product[j].hg_std;
                  }
                  else if ($scope.salesDetailtempStock[i].total >= $scope.product[j].unit_std2 && $scope.salesDetailtempStock[i].total < $scope.product[j].unit_std3) {
                    $scope.salesDetailtempStock[i].harga = $scope.product[j].hg_std2;
                  }
                  else {
                    $scope.salesDetailtempStock[i].harga = $scope.product[j].hg_std3;
                  }
                }
                else if (customerStatus == '1'){
                  $scope.salesDetailtempStock[i].harga = $scope.product[j].hg_khs;
                }
                else {
                  $scope.salesDetailtempStock[i].harga = $scope.product[j].hg_std;
                }
              }
            };

            $scope.salesDetailtempStock[i].namaprod = encodeURIComponent($scope.salesDetailtempStock[i].namaprod);

            total = parseFloat(total) + (parseFloat($scope.salesDetailtempStock[i].harga) * parseFloat($scope.salesDetailtempStock[i].total));
          };

          $scope.salesHeader = {"customer":customerId,"duration":$scope.soPaymentDuration,"total":total,"custStatus":customerStatus};

          var json = JSON.stringify($scope.salesDetailtempStock);
          var json2 = JSON.stringify($scope.salesHeader);
          
          //alert(json);
          //alert(json2);

          $.ajax({
            type: 'post',
            url:url_base+'so_sales/saveSales/'+k,
            data: "json="+json+"&json2="+json2,
            success: function(msg){
              var obj = JSON.parse(msg);
              //alert(obj);
              $timeout(function(){
                if(!isgen){
                  $scope.loading = false;
                  if (obj.status == 'sukses') {
                    $.growl.notice({ message: "Data saved" });
                    if (view == 0){
                      location.href = "#/salesHistoryX";
                    }
                    else {
                      location.href = "#/salesHistory";
                    }
                  } 
                  else {
                    $.growl.error({ message: "Insert failed. Try again !" });
                  };
                }
              },1000);
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
              alert(errorThrown);
              $timeout(function(){
                if(!isgen){
                  $scope.loading = false;
                }
                $.growl.error({ message: "Insert failed. <br/>Check connection and try again !" });
              },1000);
            } 
          });
        }
      }


    }

  };

});