app.controller('ReportsController',function($scope, $http, $timeout, UtilList, $filter){
	UtilList.outletList(function(data) {
		$scope.outlets = data;
	});
	
	Date.prototype.yyyymmdd = function() {
		var yyyy = this.getFullYear().toString();
		var mm = (this.getMonth()+1).toString(); // getMonth() is zero-based
		var dd  = this.getDate().toString();
		return yyyy + '-' + (mm[1]?mm:"0"+mm[0]) + '-' + (dd[1]?dd:"0"+dd[0]); // padding
	};

	var d = new Date();
	var dateNow = d.yyyymmdd();
	
	$scope.reports = angular.extend({viewtype:'total',periode_start:dateNow, periode_end:dateNow}, $scope.$parent.reports);
	$scope.fields = [];
	$scope.list = [];
	$scope.currentPage = 1;
	$scope.entryLimit = 50;
	$scope.filteredItems = $scope.list.length;
	$scope.totalItems = $scope.list.length;
	
	$scope.viewReports = function(reports)
	{
		var url = $scope.url;
		var responseData = $http.post(url,{'Reports':reports});
		
		responseData.success(function(data, status, headers, config)
		{
			$scope.fields = data.fields;
			$scope.list = data.field_values;
			$scope.currentPage = 1;
			$scope.entryLimit = 50;
			$scope.filteredItems = $scope.list.length;
			$scope.totalItems = $scope.list.length;
		});
		
		responseData.error(function(data, status, headers, config) {
			//alert("AJAX failed!");
		});
	}
	
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 50);
    };
	
	$scope.outletName = 'All Outlets';
	$scope.setOutletName = function() {
		var found = $filter('filter')($scope.outlets, {outlets_id: $scope.reports.outlet_id}, true);
		if (found.length) {
			$scope.outletName = found[0].outlets_name;
		} else {
			$scope.outletName = 'All Outlets';
		}
	}
	
	$scope.printDiv = function (divName) {

		var printContents = document.getElementById(divName).innerHTML;
		var originalContents = document.body.innerHTML;

		if (navigator.userAgent.toLowerCase().indexOf('chrome') > -1) {
			var popupWin = window.open('', '_blank', 'width=800,height=600,scrollbars=yes,menubar=yes,toolbar=yes,location=no,status=no,titlebar=no');
			popupWin.window.focus();
			popupWin.document.write('<!DOCTYPE html><html><head>' +
				'<link rel="stylesheet" type="text/css" href="/src/aset/bs3/css/bootstrap.min.css" /><link rel="stylesheet" type="text/css" href="/src/aset/css/print.css" />' +
				'</head><body onload="window.print()"><div class="reward-body">' + printContents + '</div></html>');
			popupWin.onbeforeunload = function (event) {
				popupWin.close();
				return '.\n';
			};
			popupWin.onabort = function (event) {
				popupWin.document.close();
				popupWin.close();
			}
		} else {
			var popupWin = window.open('', '_blank', 'width=800,height=600,scrollbars=yes,menubar=yes,toolbar=no');
			popupWin.document.open();
			popupWin.document.write('<html><head><link rel="stylesheet" type="text/css" href="/src/aset/bs3/css/bootstrap.min.css" /><link rel="stylesheet" type="text/css" href="/src/aset/css/print.css" /></head><body onload="window.print()">' + printContents + '</html>');
			popupWin.document.close();
		}
		popupWin.document.close();

		return true;
	}
	
	$scope.exportExcel = function(reports)
	{
		$scope.reportTitle = $scope.$parent.reportTitle;
		$scope.reportLabel = $scope.$parent.reportLabel;
		$http({
			url: $scope.$parent.url + '/export',
			method: 'POST',
			dataType: 'json',
			data: {'title':$scope.reportTitle,'label':$scope.reportLabel,'Reports':reports},
		})
		.success(function (data, status, headers, config)
		{
			window.open(data);
		})
		.error(function(data, status, headers, config) {
			alert("AJAX failed!");
		})
	}
});

app.controller('ReceivedController',function($scope, $http, $timeout){
	$scope.reports = {};
	$scope.url = url_base + 'report/received';
	$scope.reportTitle = 'Penerimaan Outlet';
	$scope.reportLabel = 'Penerimaan';
});

app.controller('PurchasedController',function($scope, $http, $timeout){
    $scope.reports = {};
	$scope.url = url_base + 'report/purchased';
	$scope.reportTitle = 'Pembelian Outlet';
	$scope.reportLabel = 'Pembelian';
});

app.controller('SalesController',function($scope, $http, $timeout){
    $scope.reports = {};
	$scope.url = url_base + 'report/sales';
	$scope.reportTitle = 'Sales Outlet';
	$scope.reportLabel = 'Sales';
});

app.controller('SaleMenuController',function($scope, $http, $timeout){
    $scope.reports = {};
	$scope.url = url_base + 'report/sale_menu';
	$scope.reportTitle = 'Menu Terjual Outlet';
	$scope.reportLabel = 'Menu Terjual';
});

app.controller('WasteController',function($scope, $http, $timeout){
    $scope.reports = {group:'products'};
	$scope.url = url_base + 'report/waste';
	$scope.reportTitle = 'Waste Outlet';
	$scope.reportLabel = 'Waste';
});