app.controller('receiving_new',function($scope,$http,$timeout,$location){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master_products/find_all').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 10; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
        $('#form_qty').removeClass('has-error');
        $('.help-block').html('')
     });

    $http.get(url_base+'tools/closing/header_data').success(function(data){
        $scope.identity_purchase = data;
    });

    $http.get(url_base+'master/drivers').success(function(data){
        $scope.list_driver = data; 
    });


    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };
    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };
    $scope.add_item = function(data){
        $('#modal_list_product').modal({
            backdrop:false,
        });
		$('#product_items_filter').focus();
    }
    $scope.modal_product_hide = function(){
        $('#modal_list_product').modal('hide');
    }
    $scope.current_open;
    $scope.data_penerimaan = [];
    $scope.open_detail = function(data){
        $('#modal_confirmation').modal({show:true,backdrop:false,});
		$('#field_name').html(data.product_name);
		$('#field_unit').html('1 '+data.unit_large+' = '+data.conversion+' '+data.unit_small);
		$('#subfield_qty').html(data.unit_large);
		$('#quantity_item').val('');
		$('#quantity_item').focus();
        $scope.current_open = data;
    }

    $scope.modal_confirmation_close = function(){
        $('#quantity_item').val("");
        $('#modal_confirmation').modal('hide');
        $('#form_qty').removeClass('has-error');
        $('.help-block').html('')
    }

    $scope.modal_confirmation_add = function(){
        if ($('#quantity_item').val() == '' || $('#quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('.help-block').html('data jumlah tidak boleh kosong atau 0')
        } else{
           
            $scope.insert_temporary();
            $('#quantity_item').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
            $('.help-block').html('')
        };
    }

    $scope.insert_temporary = function(){
        if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }

    $scope.replaces_data = function(){
        var data_temp = [];
        for (var i = $scope.data_penerimaan.length - 1; i >= 0; i--) {
            var temp = $scope.data_penerimaan[i];
            if (temp.product_code == $scope.current_open.product_code) {
                $scope.current_open.qty = parseFloat($('#quantity_item').val())+parseFloat($('#fixed_qty_'+temp.product_code).val());
                data_temp.push($scope.current_open);
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_penerimaan = data_temp;
    }

    $scope.add_data = function(){
        $scope.current_open.qty = $('#quantity_item').val();
        $scope.data_penerimaan.push($scope.current_open);
    }

    $scope.cek_avaliable = function(){
        var check_avaliable  = false;
        for (var i = $scope.data_penerimaan.length - 1; i >= 0; i--) {
            var temp = $scope.data_penerimaan[i];
            if (temp.product_code == $scope.current_open.product_code) {
                cek_avaliable = true;
                return true;
            };
        };

        return check_avaliable;
    }

    $scope.temp_delete;

    $scope.remove_data = function(data){
        $scope.temp_delete = data;
		$('#del_field_name').html($scope.temp_delete.product_name);
		$('#del_field_qty').html($('#fixed_qty_'+$scope.temp_delete.product_code).val()+' '+$scope.temp_delete.unit_large);
        $('#modal_confirmation_delete').modal({
            backdrop:false,
            show:true
        });
    }

    $scope.modal_confirmation_yes = function(){
        var data_temp = [];
        for (var i = $scope.data_penerimaan.length - 1; i >= 0; i--) {
            var temp = $scope.data_penerimaan[i];
            if (temp.product_code == $scope.temp_delete.product_code) {
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_penerimaan = data_temp;
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.modal_confirmation_no = function(){
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.post_data = function(){
            if($('#id_driver').val() == '-'){
                $('#id_driver').addClass('has-error');
                $.growl.warning({message:" Belum Memilih Data Supir"});
               return false; 
            }
            if ($scope.data_penerimaan.length > 0) {
                $scope.loading = true;
                var data = JSON.stringify($scope.get_data_post());
                $.ajax({
                    url:url_base+'receiving/create_receiving_manualy',
                    type:'post',
                    data:'json='+data+'&id_driver='+$('#id_driver').val(),
					dataType:'json',
					success:function(msg){
						$timeout(function(){
							$scope.loading = false;
							if (msg.status == 'success') {
								$.growl.notice({ message: "Data BERHASIL di Simpan" });
								$location.path('/view_receiving/'+msg.id, false);
							} else {
								$.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
							};
						},1000);
					},
					error: function(XMLHttpRequest, textStatus, errorThrown) {
						$timeout(function(){
							$scope.loading = false;
							$.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
						},5000);
					}
                });
            }else{
                $.growl.warning({ message: "Belum ada data untuk di simpan" });
            };
    }

    $scope.get_data_post = function(){
            var data_post = [];
            for (var i = $scope.data_penerimaan.length - 1; i >= 0; i--) {
                       var data =  $scope.data_penerimaan[i];
                       data.qty = $('#fixed_qty_'+data.product_code).val();
                       data_post.push(data);
            };        
            return data_post;
    }
});
