app.controller('purchase_id',function($scope,$routeParams,$http){
	$scope.pageClass = 'page-home';
	
	var pk = $routeParams.id;
	$scope.pid = $routeParams.id;
	$scope.detail = [];
	$http.get(url_base+'purchase/findby_pk/'+pk).success(function(data){
		$scope.header = data.header;
		$scope.detail = data.body;
	 });
	
	$scope.getTotal = function(){
		var total = 0;
		for(var i = 0; i < $scope.detail.length; i++){
			var product = $scope.detail[i];
			if(product.is_cons_bon == 0)
				total += (product.qty * product.price);
		}
		return total;
	}
});


app.controller('purchase',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'purchase/find_all').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 10; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };
    $scope.remove_data = function(data){
        var pk = data.id;
        $http.get(url_base+'purchase/Delete_status/'+pk).success(function(data){
            $scope.list = data;
        });        
    }

}); 
app.controller('purchase_add',function($scope,$http,$timeout,$location){
    $scope.pageClass = 'page-home';
    $scope.data_purchase = [];
    $scope.current_open;
    var temp_purchase;

    $http.get(url_base+'master_products/find_all').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 10; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    
    $http.get(url_base+'master/suppliers/outletsuppliers').success(function(data){
        $scope.list_supplier = data; 
    });

    $http.get(url_base+'tools/closing/header_data').success(function(data){
        $scope.identity_purchase = data;
    });

    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };

    $scope.modal_product = function(){
		$('#modal_list_prodict').modal({
            backdrop:false,
        });
		$('#product_items_filter').focus();
    }

    $scope.modal_product_hide = function(){
        $('#modal_list_prodict').modal('hide');   
    }

    $scope.add_product = function(data){
        $('#modal_confirmation').modal({show:true,backdrop:false,});
        $('#field_name').html(data.product_name);
		$('#field_unit').html('1 '+data.unit_large+' = '+data.conversion+' '+data.unit_small);
		$('#subfield_qty').html(data.unit_large);
		$('#quantity_item').val('');
		$('#price_item').val('');
		$('#is_cons_bon').prop('checked', false);
		$('#comments_item').val('');
        $('#quantity_item').focus();
        $scope.current_open = data;
    }

    $scope.modal_confirmation_add = function(){
        if ($('#quantity_item').val() == '' || $('#quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('#hb_quantity_item').html('Data JUMLAH tidak boleh kosong atau 0')
        } /*if ($('#price_item').val() == '' || $('#price_item').val() == '0') {
            $('#form_harga').addClass('has-error');
            $('#hb_price_item').html('Data HARGA tidak boleh kosong atau 0')
        } */else{
            $scope.insert_temporary();
            $('#quantity_item').val("");
			$('#price_item').val("");
			$('#is_cons_bon').prop('checked', false);
			$('#comments_item').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
			$('#form_harga').removeClass('has-error');
            $('#hb_quantity_item').html('');
			$('#hb_price_item').html('');
        };
    }

    $scope.insert_temporary = function(){
        if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }

    $scope.replaces_data = function(){
        var data_temp = [];
        for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
            var temp = $scope.data_purchase[i];
            if (temp.product_code == $scope.current_open.product_code) {
                $scope.current_open.qty = parseFloat($('#fixed_qty_'+temp.product_code).val())+ parseFloat($('#quantity_item').val());
				$scope.current_open.pricebuy = parseFloat($('#price_item').val());
				$scope.current_open.is_cons_bon = $('#is_cons_bon').prop('checked');
				$scope.current_open.comments = $('#comments_item').val();
                data_temp.push($scope.current_open);
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_purchase = data_temp;
    }

    $scope.add_data = function(){
        $scope.current_open.qty = $('#quantity_item').val();
		$scope.current_open.pricebuy = $('#price_item').val();
		$scope.current_open.is_cons_bon = $('#is_cons_bon').prop('checked');
		$scope.current_open.comments = $('#comments_item').val();
        $scope.data_purchase.push($scope.current_open);
    }

    $scope.cek_avaliable = function(){
        var check_avaliable  = false;
        for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
            var temp = $scope.data_purchase[i];
            if (temp.product_code == $scope.current_open.product_code) {
                cek_avaliable = true;
                return true;
            };
        };

        return check_avaliable;
    }

    $scope.temp_delete;

    $scope.remove_data = function(data){
        $scope.temp_delete = data;
        $('#del_field_name').html($scope.temp_delete.product_name);
		$('#del_field_qty').html($scope.temp_delete.qty+' '+$scope.temp_delete.unit_large);
        $('#modal_confirmation_delete').modal({
            backdrop:false,
            show:true
        });
    }

    $scope.modal_confirmation_yes = function(){
        var data_temp = [];
        for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
            var temp = $scope.data_purchase[i];
            if (temp.product_code == $scope.temp_delete.product_code) {
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_purchase = data_temp;
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.modal_confirmation_no = function(){
        $('#modal_confirmation_delete').modal('hide');
    }
	
	$scope.edit_data = function(data){
        $scope.current_open = data;
        $('#field_name_edit').html(data.product_name);
		$('#field_unit_edit').html('1 '+data.unit_large+' = '+data.conversion+' '+data.unit_small);
		$('#subfield_qty_edit').html(data.unit_large);
		$('#edit_quantity_item').val(data.qty);
		$('#edit_price_item').val(data.pricebuy);
		$('#is_cons_bon').prop('checked', data.is_cons_bon);
		$('#edit_comments_item').val(data.comments);
        $('#modal_confirmation_edit').modal({show:true,backdrop:false,});
    }
	
	$scope.modal_confirmation_edit = function(){
		if ($('#edit_quantity_item').val() == '' || $('#edit_quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('#hb_quantity_item_item').html('Data JUMLAH tidak boleh kosong atau 0')
        } /*if ($('#price_item_item').val() == '' || $('#price_item_item').val() == '0') {
            $('#form_harga').addClass('has-error');
            $('#hb_price_item_item').html('Data HARGA tidak boleh kosong atau 0')
        } */else{
            $scope.current_open.qty = $('#edit_quantity_item').val();
            $scope.current_open.pricebuy = $('#edit_price_item').val();
			$scope.current_open.is_cons_bon = $('#edit_is_cons_bon').val();
			$scope.current_open.comments = $('#edit_comments_item').val();
            $('#edit_quantity_item').val("");
			$('#edit_price_item').val("");
			$('#edit_is_cons_bon').val("");
			$('#edit_comments_item').val("");
            $('#modal_confirmation_edit').modal('hide');
            $('#form_qty_edit').removeClass('has-error');
			$('#form_harga_edit').removeClass('has-error');
            $('#hb_quantity_item_edit').html('');
			$('#hb_price_item_edit').html('');
        };
    }

	$scope.getTotal = function(){
		var total = 0;
		for(var i = 0; i < $scope.data_purchase.length; i++){
			var product = $scope.data_purchase[i];
			if(!product.is_cons_bon)
				total += (product.qty * product.pricebuy);
		}
		return total;
	}
	
    $scope.convert_string = function(){
         for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
             $scope.data_purchase[i].qty = $('#fixed_qty_'+$scope.data_purchase[i].product_code).val();
			 $scope.data_purchase[i].pricebuy = $('#fixed_price_'+$scope.data_purchase[i].product_code).val();
         };
    }

    $scope.save_purchase = function(){
        if ($('#id_supplier').val()=='-') {
            $.growl.warning({message:"anda belum memilih suppliers"});
            return false;
        };

        if ($scope.data_purchase.length >0) {
            $scope.convert_string();
            var json = JSON.stringify($scope.data_purchase);
            $scope.loading = true;
            $.ajax({
                url:url_base+'purchase/create_purchase',
                type:'post',
                data:'json='+json+'&id_supplier='+$('#id_supplier').val(),
				dataType:'json',
				success:function(msg){
					$timeout(function(){
						$scope.loading = false;
						if (msg.status == 'success') {
							data_purchase = [];
							$.growl.notice({ message: "Data BERHASIL di Simpan" });
							$location.path('/purchase/'+msg.pk, false);
                            //alert(msg.pk);

                            /*$http.get(url_base+'purchase/findby_pk/'+msg.pk).success(function(data){
                                $scope.data = data;

                                $http({
                                    url:'http://localhost/syno/index.php?c=Purchase&a=printBon',
                                    method: 'POST',
                                    data:JSON.stringify($scope.data),
                                    dataType:'json',
                                })
                                .success(function (data, status, headers, config){
                                    $.growl.notice({ message: "print BERHASIL." });
                                })
                                .error(function(data, status, headers, config){
                                    $.growl.error({ message: "print GAGAL." });
                                })
                            });*/
						} else {
							$.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
						};
					},1000);
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
                    $timeout(function(){
						$scope.loading = false;
						$.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
					},5000);
                }
            });
        } else{
            
            $.growl.warning({message:"tidak ada data yang dapat dikirim "});
        };

    }

}); 
