app.controller('PRetNewController', function($scope,$http, $timeout) {
  $scope.productList = [];
  $scope.hidden = true;
  $scope.typeRet = '';
  $scope.invoiceNo = '';
  $scope.searchCode = '';
  $scope.searchName = '';
  $("#masking").hide();
  $("#divList").hide();
  $("#divNotif").hide();

  $http.get(url_base+"pRet/prView").success(function (records){
    $scope.prList = records; 
  });

  $http.get(url_base+"pRet/categoryView").success(function (records){
    $scope.categoryList = records; 
  });

  $http.get(url_base+"pRet/groupView").success(function (records){
    $scope.groupList = records; 
  });

  $("#datepickerRet").datepicker();

  function parsingDate(date) {
    var identify1 = date.substring(2,3);
    var identify2 = date.substring(5,6);
    if (identify1 == '/' && identify2 == '/'){
      if (date == '') {
        return '';
      }
      else {
        var dd = date.substring(3,5);
        var mm = date.substring(0,2);
        var yyyy = date.substring(6,10);
        var parsing = yyyy+"-"+mm+"-"+dd;

        return parsing;
      }
    }
    else{
      return date;
    }
  }

  function convertRp(input){
    var round = Math.floor(input);
    var money = round.toString();
    var pointer = money.length % 3;
    var dot = Math.floor(money.length / 3);
    var rp = money.substring(0,pointer);

    if (pointer != 0){
      rp = rp + String.fromCharCode(46);
    }

    for (var i = 0; i < dot; i++){
      rp = rp + money.substring(pointer,pointer + 3) + String.fromCharCode(46);
      pointer = pointer + 3;
    }

    rp = rp.substring(0,rp.length - 1);
    rp = 'Rp ' + rp;

    return rp;
  };

  function isExist(id){
    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      count = parseFloat($scope.productList[i]['quantity']) + parseFloat(count);
    };

    return count;
  };

  function totalPrice(){
    var total = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      total = parseInt(total) + parseInt($scope.productList[i]['subtotal']);
    };

    return total;
  };

  $scope.updatePr = function() {
    $scope.productList = [];

    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
    $scope.totalPrice = totalPrice();
    $scope.totalPriceRp = convertRp($scope.totalPrice);
  };

  $scope.searchProductList = function(code,name) {
    var prId = $("#prSelected").val();
    var category = $("#categorySelected").val();
    var group = $("#groupSelected").val();

    $http.get(url_base+"pRet/searchProductList?prId="+prId+"&code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
      $scope.products = records;
    });
  };

  $scope.addProduct = function(id,name,unitL,qty,price) {
    $scope.productName = name;
    $scope.unitL = unitL;
    $scope.count = qty;
    $scope.count2 = qty;
    $scope.price = price;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addCount = function(quantity,price) {
      if ($scope.count > 0 && parseFloat($scope.count) <= parseFloat($scope.count2)) {
        if (isExist(id) == false) {
          $scope.productList.push({"id":id,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":$scope.count2,"price":price,"subtotal":price*quantity,"priceRp":convertRp(price),"subtotalRp":convertRp(price*quantity)});
        }
        else {
          for (var i = $scope.productList.length - 1; i >= 0; i--) {
            if ($scope.productList[i].id == id) {
              var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

              if (qty > $scope.count2){
                qty = $scope.count2;
              }

              $scope.productList[i].quantity = qty;

              var pId = "p"+id;
              $("#"+pId).val(qty);
              
              $scope.productList[i].subtotal = parseFloat($scope.productList[i].quantity) * parseFloat($scope.productList[i].price);
              $scope.productList[i].subtotalRp = convertRp($scope.productList[i].subtotal);
            };
          };
        };

        $scope.distinctItem = $scope.productList.length;
        $scope.countTotal = count();
        $scope.totalPrice = totalPrice();
        $scope.totalPriceRp = convertRp($scope.totalPrice);
       
        $scope.count = '';
        $("#masking").hide();
      }
      else{
        $.growl.notice({ message: "Jumlah harus diatas 0 dan jumlah retur harus lebih kecil dari jumlah beli" });
      };
    };
  };

  $scope.updateCount = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        if (parseFloat($scope.productList[i].quantity2) < parseFloat(newVal)){
          newVal = $scope.productList[i].quantity2;
          $("#"+pId).val(newVal);
        }

        $scope.productList[i].quantity = newVal;
       
        var subtotal = newVal * $scope.productList[i].price;
        $scope.productList[i].subtotal = subtotal;
        $scope.productList[i].subtotalRp = convertRp(subtotal);
        $scope.countTotal = count();
        $scope.totalPrice = totalPrice();
        $scope.totalPriceRp = convertRp($scope.totalPrice);
      };
    };
  };

  $scope.deleteProduct = function(index) {
    $scope.productList.splice(index,1);
    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
    $scope.totalPrice = totalPrice();
    $scope.totalPriceRp = convertRp($scope.totalPrice);
  };

  $scope.savePurchaseReturn = function(isgen,status) {
    var prId = $scope.invoiceNo;
    var dateRet = parsingDate($("#datepickerRet").val());
    var typeRet = $scope.typeRet;

    if (prId === ''){
      $.growl.warning({ message: 'No Invoice belum diisi' });
    }
    else if (dateRet === ''){
      $.growl.warning({ message: 'Tanggal Retur belum diisi' });
    }
    else if (typeRet === ''){
      $.growl.warning({ message: 'Tipe Retur belum diisi' });
    }
    else if ($scope.productList.length == 0){
      $.growl.warning({ message: 'Data produk belum diisi' });
    }
    else {
      if(!isgen){
        if (status == 'save') {
          $scope.loading = true; 
        }
        else {
          $scope.loading2 = true; 
        }
      };

      $scope.productHeader = {"prId":prId,"dateRet":dateRet,"typeRet":typeRet,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal,"subtotal":$scope.totalPrice,"status":status};

      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);

      $.ajax({
        type: 'post',
        url:url_base+'pRet/savePurchaseReturn',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"pRet/getNotif").success(function (records) {
                  $scope.codeNotif = records[0]['code'];
                  $scope.prNotif = records[0]['invoice_no'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  $scope.dateRetNotif = dateRet;
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

  $scope.showDivList = function() {
    if($scope.invoiceNo == ''){
      $.growl.warning({ message: 'Pilih No Invoice terlebih dahulu' });
    }
    else {
      var prId = $("#prSelected").val();

      $http.get(url_base+"pRet/pRetDetailView?prId="+prId).success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;
      });

      window.scrollTo(0,0);
      $("#divMain").hide();
      $("#divList").css({top:-80,left:0,position:"absolute"});
      $("#divList").css("z-index","9998");
      $("#divList").show(function(){
        $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
      });
    };
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.searchCode = '';
    $scope.searchName = '';

    $(function() {
      $("#categorySelected").val("");
      $("#groupSelected").val("");
    });
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.count = '';
    $scope.price = '';
  };
});