app.controller('JournalController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.journal = [];
  $scope.journal2 = [];
  
  $("#datepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#datepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;

      var debit = 0;
      var credit = 0;
      var saldo = 0;

      for (var i = 0; i < $scope.filtered.length; i++){
        for (var j = 0; j < $scope.filtered[i]['detail'].length; j++){      
          if ($scope.filtered[i]['detail'][j]['iscredit'] == 1){
            saldo = parseFloat(saldo) - parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
            credit = parseFloat(credit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
          }
          else{
            saldo = parseFloat(saldo) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
            debit = parseFloat(debit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
          }

          $scope.filtered[i]['detail'][j]['saldo'] = convertToRp(saldo);
        }
      }

      $scope.journalDebit = convertToRp(debit);
      $scope.journalCredit = convertToRp(credit);
      $scope.journalDelta = convertToRp(Math.abs(debit-credit));
      $scope.$apply();
    }, 50);
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  function total(type){
    var total = 0;

    for (var i = $scope.journal2.length - 1; i >= 0; i--) {
      for (var j = $scope.journal2[i]['detail'].length - 1; j >= 0; j--) {
        if ($scope.journal2[i]['detail'][j]['iscredit'] == type){
          total = parseFloat($scope.journal2[i]['detail'][j]['jumlah']) + parseFloat(total);
        }
      }
    };

    return total;
  };

  $http.get(url_base+'journal/lastMonthJournal').success(function (records){
    $scope.journal = records;
    var temp = '';
    var j = 0;
    var k = 0;

    for (var i = 0; i < $scope.journal.length; i++){
      if (temp != $scope.journal[i]['journalid']){
        $scope.journal2[j] = {journalid:$scope.journal[i]['journalid'],tanggal:$scope.journal[i]['tanggal'],keterangan:$scope.journal[i]['keterangan'],notrans:$scope.journal[i]['notrans'],span:$scope.journal[i]['span'],detail:[]};
        temp = $scope.journal[i]['journalid'];
        j++;
        k = 0;
      }

      $scope.journal2[j-1]['detail'][k] = {glno:$scope.journal[i]['glno'],accountname:$scope.journal[i]['accountname'],iscredit:$scope.journal[i]['iscredit'],jumlah:$scope.journal[i]['jumlah'],jumlah2:convertToRp($scope.journal[i]['jumlah'])};
      k++;
    }

    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.journal2.length;
    $scope.totalItems = $scope.journal2.length;

    $scope.journalDebit = convertToRp(total(0));
    $scope.journalCredit = convertToRp(total(1));
    $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
  });

  $scope.newTab = function(id){
    $window.open('#/finance2/'+id);
  };

  $scope.generateJournal = function(){
    if ($("#datepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#datepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#datepickerStart").val()) > Date.parse($("#datepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      $scope.inputDate = {"start":$("#datepickerStart").val(),"end":$("#datepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'journal/generateJournal',
        data: "json="+json,
        success: function(msg){
          $scope.journal = JSON.parse(msg);
          $scope.journal2 = [];
          var temp = '';
          var j = 0;
          var k = 0;

          for (var i = 0; i < $scope.journal.length; i++){
            if (temp != $scope.journal[i]['journalid']){
              $scope.journal2[j] = {journalid:$scope.journal[i]['journalid'],tanggal:$scope.journal[i]['tanggal'],keterangan:$scope.journal[i]['keterangan'],notrans:$scope.journal[i]['notrans'],span:$scope.journal[i]['span'],detail:[]};
              temp = $scope.journal[i]['journalid'];
              j++;
              k = 0;
            }

            $scope.journal2[j-1]['detail'][k] = {glno:$scope.journal[i]['glno'],accountname:$scope.journal[i]['accountname'],iscredit:$scope.journal[i]['iscredit'],jumlah:$scope.journal[i]['jumlah'],jumlah2:convertToRp($scope.journal[i]['jumlah'])};
            k++;
          }

          $scope.currentPage = 1;
          $scope.entryLimit = 25;
          $scope.filteredItems = $scope.journal2.length;
          $scope.totalItems = $scope.journal2.length;

          $scope.journalDebit = convertToRp(total(0));
          $scope.journalCredit = convertToRp(total(1));
          $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));

          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    }
  }

  $scope.checkUnbalance = function(){
    if ($("#datepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#datepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#datepickerStart").val()) > Date.parse($("#datepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      $scope.inputDate = {"start":$("#datepickerStart").val(),"end":$("#datepickerEnd").val()};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'journal/checkUnbalance',
        data: "json="+json,
        success: function(msg){
          $scope.journal = JSON.parse(msg);
          $scope.journal2 = [];
          var temp = '';
          var j = 0;
          var k = 0;

          for (var i = 0; i < $scope.journal.length; i++){
            if (temp != $scope.journal[i]['journalid']){
              $scope.journal2[j] = {journalid:$scope.journal[i]['journalid'],tanggal:$scope.journal[i]['tanggal'],keterangan:$scope.journal[i]['keterangan'],notrans:$scope.journal[i]['notrans'],span:$scope.journal[i]['span'],detail:[]};
              temp = $scope.journal[i]['journalid'];
              j++;
              k = 0;
            }

            $scope.journal2[j-1]['detail'][k] = {glno:$scope.journal[i]['glno'],accountname:$scope.journal[i]['accountname'],iscredit:$scope.journal[i]['iscredit'],jumlah:$scope.journal[i]['jumlah'],jumlah2:convertToRp($scope.journal[i]['jumlah'])};
            k++;
          }

          $scope.currentPage = 1;
          $scope.entryLimit = 25;
          $scope.filteredItems = $scope.journal2.length;
          $scope.totalItems = $scope.journal2.length;

          $scope.journalDebit = convertToRp(total(0));
          $scope.journalCredit = convertToRp(total(1));
          $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));

          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    }
  }

  $scope.deleteJournal = function(id) {
    if (confirm("Delete journal with ID : "+id+"?")){
      $scope.dataDelete = {"id":id};
      var debit = 0;
      var credit = 0;
      var saldo = 0;

      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'journal/deleteJournal',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              for (var i = $scope.journal2.length - 1; i >= 0; i--) {
                if ($scope.journal2[i]['journalid'] == id){
                  $scope.journal2.splice(i,1);
                  $scope.$apply();
                }
              };

              for (var i = 0; i < $scope.filtered.length; i++){
                for (var j = 0; j < $scope.filtered[i]['detail'].length; j++){      
                  if ($scope.filtered[i]['detail'][j]['iscredit'] == 1){
                    saldo = parseFloat(saldo) - parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
                    credit = parseFloat(credit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
                  }
                  else{
                    saldo = parseFloat(saldo) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
                    debit = parseFloat(debit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
                  }

                  $scope.filtered[i]['detail'][j]['saldo'] = convertToRp(saldo);
                }
              }

              $scope.journalDebit = convertToRp(debit);
              $scope.journalCredit = convertToRp(credit);
              $scope.journalDelta = convertToRp(Math.abs(debit-credit));
              $scope.$apply();

              $.growl.notice({ message: "Data deleted" });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Delete failed. Try again !" });
            }
            else{
              $.growl.notice({ message: "Data can't be deleted" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            $.growl.error({ message: "Delete Failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }
    return false;
  };
});


app.controller('JournalEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;
    $("#datepickerJournal").datepicker({
      format:"yyyy-mm-dd"
    });

    $("#datepickerJournal").on('changeDate',function(){
      $(this).datepicker("hide");
    });

    $(document).on('change', function() {
      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        $scope.journalDetail[i].glno = $("#g"+i).val();
        $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();
        $scope.$apply();
      };
    })

    function convertToRp(input){
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }

    function total(type){
      var total = 0;

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (type == 0){
          total = parseFloat($scope.journalDetail[i]['debit']) + parseFloat(total);
        }
        else {
          total = parseFloat($scope.journalDetail[i]['credit']) + parseFloat(total);
        }
      };

      return total;
    };

    $http.get(url_base+'journal/getJournalHeader/'+id).success(function (records){
      $scope.journalId = records[0]['journalid'];
      $("#datepickerJournal").val(records[0]['tanggal']);
      $scope.journalDesc = records[0]['keterangan'];
      $scope.noTrans = records[0]['notrans'];
      $scope.createdBy = records[0]['dibuat'];
    });

    $http.get(url_base+'journal/getJournalDetail/'+id).success(function (records){
      $scope.journalDetail = records;
      $scope.journalDebit = convertToRp(total(0));
      $scope.journalCredit = convertToRp(total(1));
      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
    });

    $http.get(url_base+'journal/glAccountList').success(function (records){
      $scope.glAccountList = records;
    });

    $scope.addRow = function() {
      $scope.journalDetail.push({"journalid":id,"glno":"","accountname":"","debit":"0","credit":"0"});
      $scope.$apply();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        $scope.journalDetail[i].glno = $("#g"+i).val();
        $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();
        $scope.$apply();
      };
    };

    /*$scope.updateTotal = function(glno,iscredit){
      if (iscredit == 0){
        var pId = "p"+glno;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if ($scope.journalDetail[i].glno == glno) {
            $scope.journalDetail[i].debit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalDebit = convertToRp(total(0));
      }
      else{
        var pId = "s"+glno;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if ($scope.journalDetail[i].glno == glno) {
            $scope.journalDetail[i].credit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalCredit = convertToRp(total(1));
      }

      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
    };*/

    $scope.updateTotal = function(index,iscredit){
      if (iscredit == 0){
        var pId = "p"+index;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if (i == index) {
            $scope.journalDetail[i].debit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalDebit = convertToRp(total(0));
      }
      else{
        var pId = "s"+index;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if (i == index) {
            $scope.journalDetail[i].credit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalCredit = convertToRp(total(1));
      }

      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
    };

    $scope.deleteJournal = function(index) {
      var no = index+1;
      if (confirm("Delete journal with NO : "+no+"?")){
        $scope.journalDetail.splice(index,1);
        $scope.journalDebit = convertToRp(total(0));
        $scope.journalCredit = convertToRp(total(1));
        $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
        $scope.$apply();
      }
    };

    $scope.saveJournal = function(isgen,status) {
      var temp = '';
      var idem = 0;
      var valid = 0;

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if ($scope.journalDetail[i].debit > 0 && $scope.journalDetail[i].credit > 0){
          valid = 1;
          break;
        }
       
        for (var j = $scope.journalDetail.length - 1 - ($scope.journalDetail.length - i); j >= 0; j--) {
          if ($scope.journalDetail[i].glno == $scope.journalDetail[j].glno){
            idem = 1; 
            break;
          }
        }

        if ($scope.journalDetail[i].debit > $scope.journalDetail[i].credit){
          $scope.journalDetail[i].iscredit = 0;
        }
        else{
          $scope.journalDetail[i].iscredit = 1;
        }

        $scope.journalDetail[i].jumlah = parseFloat($scope.journalDetail[i].debit) + parseFloat($scope.journalDetail[i].credit);
      };

      if ($scope.journalDelta != '0,00'){
        $.growl.warning({ message: 'Unbalance' });
      }
      else if (idem == 1){
        $.growl.warning({ message: 'Duplicate GL Account' });
      }
      else if (valid == 1){
        $.growl.warning({ message: 'Fill Only Debit / Credit' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        $scope.journalHeader = {"date":$("#datepickerJournal").val()};

        var json = JSON.stringify($scope.journalDetail);
        var json2 = JSON.stringify($scope.journalHeader);

        $.ajax({
          type: 'post',
          url:url_base+'journal/editJournal',
          data: "json="+json+"&json2="+json2,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data updated" });
                } 
                else {
                  $.growl.error({ message: "Update failed. Try again !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
            },1000);
          } 
        });
      }

    };

  }
]);

app.controller('JournalNewController', function($scope,$http, $timeout) {
  $scope.journalDetail = [];
  $scope.journalDebit = 0;
  $scope.journalCredit = 0;
  $scope.journalDelta = 0;
  $scope.invisible = true;

  $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0"});

  $("#datepickerNew").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerNew").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $(document).on('change', function() {
    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      $scope.journalDetail[i].glno = $("#g"+i).val();
      $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();
      $scope.$apply();
    };
  })

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  function total(type){
    var total = 0;

    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      if (type == 0){
        total = parseFloat($scope.journalDetail[i]['debit']) + parseFloat(total);
      }
      else {
        total = parseFloat($scope.journalDetail[i]['credit']) + parseFloat(total);
      }
    };

    return total;
  };

  $scope.checkRequirement = function(){
    var temp = 0;

    for(i=0;i<$scope.newDesc.length;i++) {
      if($scope.newDesc[i] == '&' || $scope.newDesc[i] == '|' || $scope.newDesc[i] == '$' || $scope.newDesc[i] == '^' || $scope.newDesc[i] == '<' || $scope.newDesc[i] == '>'){
        temp++
      }
    }

    if (temp > 0) {
      $scope.invisible = false;
    }else{
      $scope.invisible = true;
    }
  }

  $scope.addRow = function() {
    $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0"});
  };

  $http.get(url_base+'journal/glAccountList').success(function (records){
    $scope.glAccountList = records;
  });

  $scope.updateTotal = function(index,iscredit){
    if (iscredit == 0){
      var pId = "p"+index;
      var newVal = $("#"+pId).val();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (i == index) {
          $scope.journalDetail[i].debit = newVal;

          $("#"+pId).val(newVal);
        };
      };

      $scope.journalDebit = convertToRp(total(0));
    }
    else{
      var pId = "s"+index;
      var newVal = $("#"+pId).val();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (i == index) {
          $scope.journalDetail[i].credit = newVal;

          $("#"+pId).val(newVal);
        };
      };

      $scope.journalCredit = convertToRp(total(1));
    }

    $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
  };

  $scope.deleteJournal = function(index) {
    var no = index+1;
    if (confirm("Delete journal with NO : "+no+"?")){
      $scope.journalDetail.splice(index,1);
      $scope.journalDebit = convertToRp(total(0));
      $scope.journalCredit = convertToRp(total(1));
      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
      $scope.$apply();
    }
  };

  $scope.saveJournal = function(isgen,status) {
    var temp = '';
    var idem = 0;
    var valid = 0;
    var empty = 0;

    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      if ($scope.journalDetail[i].debit > 0 && $scope.journalDetail[i].credit > 0){
        valid = 1;
        break;
      }

      if ($scope.journalDetail[i].glno == "" || $scope.journalDetail[i].glno === null){
        empty = 1;
        break;
      }
     
      for (var j = $scope.journalDetail.length - 1 - ($scope.journalDetail.length - i); j >= 0; j--) {
        if ($scope.journalDetail[i].glno == $scope.journalDetail[j].glno){
          idem = 1; 
          break;
        }
      }

      if ($scope.journalDetail[i].debit > $scope.journalDetail[i].credit){
        $scope.journalDetail[i].iscredit = 0;
      }
      else{
        $scope.journalDetail[i].iscredit = 1;
      }

      $scope.journalDetail[i].jumlah = parseFloat($scope.journalDetail[i].debit) + parseFloat($scope.journalDetail[i].credit);
    };

    if ($("#datepickerNew").val() === ''){
      $.growl.warning({ message: 'Choose Journal Date' });
    }
    else if ($scope.invisible == false){
      $.growl.warning({ message: 'Description Field Is Not Valid' });
    }
    else if ($scope.journalDelta != '0,00'){
      $.growl.warning({ message: 'Unbalance' });
    }
    else if (idem == 1){
      $.growl.warning({ message: 'Duplicate GL Account' });
    }
    else if (valid == 1){
      $.growl.warning({ message: 'Fill Only Debit / Credit' });
    }
    else if (empty == 1){
      $.growl.warning({ message: 'Empty Account' });
    }
    else {
      if ($scope.newDesc === undefined || $scope.newDesc === "") {
        $scope.newDesc = '-'
      }

      if ($scope.newTrans === undefined || $scope.newTrans === "") {
        $scope.newTrans = '-'
      }

      if(!isgen){
        $scope.loading = true; 
      };

      $scope.journalHeader = {"noTrans":$scope.newTrans,"keterangan":"Koreksi | "+$scope.newTrans+" | "+$scope.newDesc,"date":$("#datepickerNew").val()};

      var json = JSON.stringify($scope.journalDetail);
      var json2 = JSON.stringify($scope.journalHeader);

      $.ajax({
        type: 'post',
        url:url_base+'journal/insertJournal',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data inserted" });

                $scope.journalDetail = [];
                $scope.journalDebit = 0;
                $scope.journalCredit = 0;
                $scope.journalDelta = 0;
                $scope.newTrans = "";
                $scope.newDesc = "";
                $("#datepickerNew").val("");


                $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0"});
                $scope.$apply();
              } 
              else {
                $.growl.error({ message: "Insert failed. Try again !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Insert failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }

  };

});


