app.controller('CashBankController', function($scope,$http, $timeout,$window) {
  $(window).off("keypress");
  $scope.journal = [];
  $scope.journal2 = [];

  $("#cbDatepickerStart").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#cbDatepickerStart").on('changeDate',function(){
    $(this).datepicker("hide");
  });

   $("#cbDatepickerEnd").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#cbDatepickerEnd").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $http.get(url_base+'cashbank/glAccountCashBankList').success(function (records){
    $scope.glAccountList = records;
  });

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;

      var debit = 0;
      var credit = 0;
      var saldo = 0;

      for (var i = 0; i < $scope.filtered.length; i++){
        for (var j = 0; j < $scope.filtered[i]['detail'].length; j++){      
          if ($scope.filtered[i]['detail'][j]['iscredit'] == 1){
            saldo = parseFloat(saldo) - parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
            credit = parseFloat(credit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
          }
          else{
            saldo = parseFloat(saldo) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
            debit = parseFloat(debit) + parseFloat($scope.filtered[i]['detail'][j]['jumlah']);
          }

          $scope.filtered[i]['detail'][j]['saldo'] = convertToRp(saldo);
        }
      }

      $scope.journalDebit = convertToRp(debit);
      $scope.journalCredit = convertToRp(credit);
      $scope.journalDelta = convertToRp(Math.abs(debit-credit));
      $scope.$apply();
    }, 50);
  };

  function total(type){
    var total = 0;

    for (var i = $scope.journal.length - 1; i >= 0; i--) {
      if ($scope.journal[i]['iscredit'] == type){
        total = parseFloat($scope.journal[i]['jumlah']) + parseFloat(total);
      }
    };

    return total;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $http.get(url_base+'cashbank/lastMonthCashBank').success(function (records){
    $scope.journal = records;
    var temp = '';
    var j = 0;
    var k = 0;
    var saldo = 0;

    for (var i = 0; i < $scope.journal.length; i++){
      if (temp != $scope.journal[i]['journalid']){
        $scope.journal2[j] = {journalid:$scope.journal[i]['journalid'],tanggal:$scope.journal[i]['tanggal'],keterangan:$scope.journal[i]['keterangan'],notrans:$scope.journal[i]['notrans'],detail:[]};
        temp = $scope.journal[i]['journalid'];
        j++;
        k = 0;
      }

      if ($scope.journal[i]['iscredit'] == 1){
        saldo = parseFloat(saldo) - parseFloat($scope.journal[i]['jumlah']);
      }
      else{
        saldo = parseFloat(saldo) + parseFloat($scope.journal[i]['jumlah']);
      }

      $scope.journal2[j-1]['detail'][k] = {glno:$scope.journal[i]['glno'],accountname:$scope.journal[i]['accountname'],iscredit:$scope.journal[i]['iscredit'],jumlah:$scope.journal[i]['jumlah'],jumlah2:convertToRp($scope.journal[i]['jumlah']),saldo:convertToRp(saldo)};
      k++;
    }

    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.journal2.length;
    $scope.totalItems = $scope.journal2.length;

    $scope.journalDebit = convertToRp(total(0));
    $scope.journalCredit = convertToRp(total(1));
    $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
  });

  $scope.newTab = function(id){
    $window.open('#/cashbank2/'+id);
  };

  $scope.generateCashBank = function(){
    if ($("#cbDatepickerStart").val() == ''){
      $.growl.notice({ message: "Fill in Start Date" });
    }
    else if($("#cbDatepickerEnd").val() == ''){
      $.growl.notice({ message: "Fill in End Date" });
    }
    else if(Date.parse($("#cbDatepickerStart").val()) > Date.parse($("#cbDatepickerEnd").val())){
      $.growl.notice({ message: "Start Date must be lower than End Date" });
    }
    else{
      if ($scope.account === undefined) {
        $scope.account = '0000000000'
      }

      $scope.inputDate = {"start":$("#cbDatepickerStart").val(),"end":$("#cbDatepickerEnd").val(),"account":$scope.account};

      var json = JSON.stringify($scope.inputDate);

      $.ajax({
        type: 'post',
        url:url_base+'cashbank/generateCashBank',
        data: "json="+json,
        success: function(msg){
          $scope.journal = JSON.parse(msg);
          $scope.journal2 = [];
          var temp = '';
          var j = 0;
          var k = 0;
          var saldo = 0

          for (var i = 0; i < $scope.journal.length; i++){
            if (temp != $scope.journal[i]['journalid']){
              $scope.journal2[j] = {journalid:$scope.journal[i]['journalid'],tanggal:$scope.journal[i]['tanggal'],keterangan:$scope.journal[i]['keterangan'],notrans:$scope.journal[i]['notrans'],detail:[]};
              temp = $scope.journal[i]['journalid'];
              j++;
              k = 0;
            }

            if ($scope.journal[i]['iscredit'] == 1){
              saldo = parseFloat(saldo) - parseFloat($scope.journal[i]['jumlah']);
            }
            else{
              saldo = parseFloat(saldo) + parseFloat($scope.journal[i]['jumlah']);
            }

            $scope.journal2[j-1]['detail'][k] = {glno:$scope.journal[i]['glno'],accountname:$scope.journal[i]['accountname'],iscredit:$scope.journal[i]['iscredit'],jumlah:$scope.journal[i]['jumlah'],jumlah2:convertToRp($scope.journal[i]['jumlah']),saldo:convertToRp(saldo)};
            k++;
          }

          $scope.currentPage = 1;
          $scope.entryLimit = 25;
          $scope.filteredItems = $scope.journal2.length;
          $scope.totalItems = $scope.journal2.length;

          $scope.journalDebit = convertToRp(total(0));
          $scope.journalCredit = convertToRp(total(1));
          $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));

          $scope.$apply();
        },
        error: function() {
          $.growl.error({ message: "Failed. <br/>Check connection and try again !" });
        } 
      });
    }
  }
});

app.controller('CashBankEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;
    $("#datepickerCashBank").datepicker({
      format:"yyyy-mm-dd"
    });

    $("#datepickerCashBank").on('changeDate',function(){
      $(this).datepicker("hide");
    });

    $(document).on('change', function() {
      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        $scope.journalDetail[i].glno = $("#g"+i).val();
        $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();
        $scope.$apply();
      };
    })

    function convertToRp(input){
      var rp = '';    
      input = parseFloat(input).toFixed(2);
      var angkarev = input.toString().split('').reverse().join('');
      var dec = angkarev.substr(0,2).split('').reverse().join('');
      var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

      angkarev = num.toString().split('').reverse().join('');

      for(var i = 0; i < angkarev.length; i++){
        if(i%3 == 0){
          rp += angkarev.substr(i,3)+'.';
        } 
      } 

      var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

      if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
        output = '-'+output.substr(2,output.length-2);
      }

      return output;
    }

    function total(type){
      var total = 0;

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (type == 0){
          total = parseFloat($scope.journalDetail[i]['debit']) + parseFloat(total);
        }
        else {
          total = parseFloat($scope.journalDetail[i]['credit']) + parseFloat(total);
        }
      };

      return total;
    };

    $http.get(url_base+'cashbank/getJournalHeader/'+id).success(function (records){
      $scope.journalId = records[0]['journalid'];
      $("#datepickerCashBank").val(records[0]['tanggal']);
      $scope.journalDesc = records[0]['keterangan'];
      $scope.noTrans = records[0]['notrans'];
      $scope.createdBy = records[0]['dibuat'];
    });

    $http.get(url_base+'cashbank/getJournalDetail/'+id).success(function (records){
      $scope.journalDetail = records;
      $scope.journalDebit = convertToRp(total(0));
      $scope.journalCredit = convertToRp(total(1));
      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
    });

    $http.get(url_base+'cashbank/glAccountListEdit').success(function (records){
      $scope.glAccountList = records;
      $scope.glAccountList.splice(0,1);
    });

    $scope.addRow = function() {
      $scope.journalDetail.push({"journalid":id,"glno":"","accountname":"","debit":"0","credit":"0"});
      $scope.$apply();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        $scope.journalDetail[i].glno = $("#g"+i).val();
        $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();
        $scope.$apply();
      };
    };

    $scope.updateTotal = function(index,iscredit){
      if (iscredit == 0){
        var pId = "p"+index;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if (i == index) {
            $scope.journalDetail[i].debit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalDebit = convertToRp(total(0));
      }
      else{
        var pId = "s"+index;
        var newVal = $("#"+pId).val();

        for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
          if (i == index) {
            $scope.journalDetail[i].credit = newVal;

            $("#"+pId).val(newVal);
          };
        };

        $scope.journalCredit = convertToRp(total(1));
      }

      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
    };

    $scope.deleteJournal = function(index) {
      var no = index+1;
      if (confirm("Delete journal with NO : "+no+"?")){
        $scope.journalDetail.splice(index,1);
        $scope.journalDebit = convertToRp(total(0));
        $scope.journalCredit = convertToRp(total(1));
        $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
        $scope.$apply();
      }
    };

    $scope.saveJournal = function(isgen,status) {
      var temp = '';
      var idem = 0;
      var valid = 0;

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if ($scope.journalDetail[i].debit > 0 && $scope.journalDetail[i].credit > 0){
          valid = 1;
          break;
        }
       
        for (var j = $scope.journalDetail.length - 1 - ($scope.journalDetail.length - i); j >= 0; j--) {
          if ($scope.journalDetail[i].glno == $scope.journalDetail[j].glno){
            idem = 1; 
            break;
          }
        }

        if ($scope.journalDetail[i].debit > $scope.journalDetail[i].credit){
          $scope.journalDetail[i].iscredit = 0;
        }
        else{
          $scope.journalDetail[i].iscredit = 1;
        }

        $scope.journalDetail[i].jumlah = parseFloat($scope.journalDetail[i].debit) + parseFloat($scope.journalDetail[i].credit);
      };

      if ($scope.journalDelta != '0,00'){
        $.growl.warning({ message: 'Unbalance' });
      }
      else if (idem == 1){
        $.growl.warning({ message: 'Duplicate GL Account' });
      }
      else if (valid == 1){
        $.growl.warning({ message: 'Fill Only Debit / Credit' });
      }
      else {
        if(!isgen){
          $scope.loading = true; 
        };

        $scope.journalHeader = {"date":$("#datepickerCashBank").val()};

        var json = JSON.stringify($scope.journalDetail);
        var json2 = JSON.stringify($scope.journalHeader);

        $.ajax({
          type: 'post',
          url:url_base+'cashbank/editCashBank',
          data: "json="+json+"&json2="+json2,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data updated" });
                } 
                else {
                  $.growl.error({ message: "Update failed. Try again !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
            },1000);
          } 
        });
      }

    };

  }
]);

app.controller('CashBankNewController', function($scope,$http, $timeout) {
  $scope.journalDetail = [];
  $scope.journalDebit = 0;
  $scope.journalCredit = 0;
  $scope.journalDelta = 0;
  $scope.invisible = true;

  $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0","type":""});

  $("#cbDatepickerNew").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#cbDatepickerNew").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $(document).on('change', function() {
    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      $scope.journalDetail[i].glno = $("#g"+i).val();
      $scope.journalDetail[i].accountname = $("#g"+i+" :selected").text();

      for (var j = $scope.glAccountList.length - 1; j >= 0; j--){
        if ($scope.glAccountList[j].glno == $("#g"+i).val()){
          $scope.journalDetail[i].type = $scope.glAccountList[j].type;
        }
      }

      $scope.$apply();
    };
  })

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  function total(type){
    var total = 0;

    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      if (type == 0){
        total = parseFloat($scope.journalDetail[i]['debit']) + parseFloat(total);
      }
      else {
        total = parseFloat($scope.journalDetail[i]['credit']) + parseFloat(total);
      }
    };

    return total;
  };

  function newId(count){
    var embed = 0;
    var zero = 'CB';

    embed = 10-(count.length+2);

    for (var i = 0; i < embed; i++){
      zero = zero + 0;
    }

    return zero;
  }

  $scope.checkRequirement = function(){
    var temp = 0;

    for(i=0;i<$scope.newDesc.length;i++) {
      if($scope.newDesc[i] == '&' || $scope.newDesc[i] == '|' || $scope.newDesc[i] == '$' || $scope.newDesc[i] == '^' || $scope.newDesc[i] == '<' || $scope.newDesc[i] == '>'){
        temp++
      }
    }

    if (temp > 0) {
      $scope.invisible = false;
    }else{
      $scope.invisible = true;
    }
  }

  $scope.addRow = function() {
    $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0","type":""});
  };

  $http.get(url_base+'cashbank/glAccountList').success(function (records){
    $scope.glAccountList = records;
    $scope.glAccountList.splice(0,1);
  });

  $http.get(url_base+'cashbank/getNewId').success(function (records){
    $scope.newTrans = newId(records[0]['newid'])+records[0]['newid'];
  });

  $scope.updateTotal = function(index,iscredit){
    if (iscredit == 0){
      var pId = "p"+index;
      var newVal = $("#"+pId).val();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (i == index) {
          $scope.journalDetail[i].debit = newVal;

          $("#"+pId).val(newVal);
        };
      };

      $scope.journalDebit = convertToRp(total(0));
    }
    else{
      var pId = "s"+index;
      var newVal = $("#"+pId).val();

      for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
        if (i == index) {
          $scope.journalDetail[i].credit = newVal;

          $("#"+pId).val(newVal);
        };
      };

      $scope.journalCredit = convertToRp(total(1));
    }

    $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
  };

  $scope.deleteCashBank = function(index) {
    var no = index+1;
    if (confirm("Delete cash & bank with NO : "+no+"?")){
      $scope.journalDetail.splice(index,1);
      $scope.journalDebit = convertToRp(total(0));
      $scope.journalCredit = convertToRp(total(1));
      $scope.journalDelta = convertToRp(Math.abs(total(0)-total(1)));
      $scope.$apply();
    }
  };

  $scope.saveCashBank = function(isgen,status) {
    var temp = '';
    var tempX = 0;
    var tempY = 0;
    var idem = 0;
    var valid = 0;
    var empty = 0;

    for (var i = $scope.journalDetail.length - 1; i >= 0; i--) {
      if ($scope.journalDetail[i].debit > 0 && $scope.journalDetail[i].credit > 0){
        valid = 1;
        break;
      }

      if ($scope.journalDetail[i].glno == "" || $scope.journalDetail[i].glno === null){
        empty = 1;
        break;
      }
     
      for (var j = $scope.journalDetail.length - 1 - ($scope.journalDetail.length - i); j >= 0; j--) {
        if ($scope.journalDetail[i].glno == $scope.journalDetail[j].glno){
          idem = 1; 
          break;
        }
      }

      if ($scope.journalDetail[i].debit > $scope.journalDetail[i].credit){
        $scope.journalDetail[i].iscredit = 0;
      }
      else{
        $scope.journalDetail[i].iscredit = 1;
      }

      if ($scope.journalDetail[i].type == 'X'){
        tempX = 1;
      }

      if ($scope.journalDetail[i].type == 'Y'){
        tempY = 1;
      }

      $scope.journalDetail[i].jumlah = parseFloat($scope.journalDetail[i].debit) + parseFloat($scope.journalDetail[i].credit);
    };

    if ($("#cbDatepickerNew").val() === ''){
      $.growl.warning({ message: 'Choose Journal Date' });
    }
    else if ($scope.invisible == false){
      $.growl.warning({ message: 'Description Field Is Not Valid' });
    }
    else if ($scope.journalDelta != '0,00'){
      $.growl.warning({ message: 'Unbalance' });
    }
    else if (idem == 1){
      $.growl.warning({ message: 'Duplicate GL Account' });
    }
    else if (valid == 1){
      $.growl.warning({ message: 'Fill Only Debit / Credit' });
    }
    else if (empty == 1){
      $.growl.warning({ message: 'Empty Account' });
    }
    else if (tempX == 0 || tempY == 0){
      $.growl.warning({ message: 'Account [X-Y] Does Not Match' });
    }
    else {
      $http.get(url_base+'cashbank/getNewId').success(function (records){
        $scope.newTrans = newId(records[0]['newid'])+records[0]['newid'];
      });

      if ($scope.newDesc === undefined || $scope.newDesc === "") {
        $scope.newDesc = '-'
      }

      if(!isgen){
        $scope.loading = true; 
      };

      $scope.journalHeader = {"noTrans":$scope.newTrans,"keterangan":"Cash Bank | "+$scope.newTrans+" | "+$scope.newDesc,"date":$("#cbDatepickerNew").val()};

      var json = JSON.stringify($scope.journalDetail);
      var json2 = JSON.stringify($scope.journalHeader);

      $.ajax({
        type: 'post',
        url:url_base+'cashbank/insertCashBank',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data inserted" });

                $scope.journalDetail = [];
                $scope.journalDebit = 0;
                $scope.journalCredit = 0;
                $scope.journalDelta = 0;
                $http.get(url_base+'cashbank/getNewId').success(function (records){
                  $scope.newTrans = newId(records[0]['newid'])+records[0]['newid'];
                });
                $scope.newDesc = "";
                $("#cbDatepickerNew").val("");

                $scope.journalDetail.push({"glno":"","accountname":"","debit":"0","credit":"0","type":""});
                $scope.$apply();
              } 
              else {
                $.growl.error({ message: "Insert failed. Try again !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Insert failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }

  };

});


