app.controller('CancelsDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.eid;

    function convertRp(input){
      var money = input.toString();
      var pointer = money.length % 3;
      var dot = Math.floor(money.length / 3);
      var rp = money.substring(0,pointer);

      if (pointer != 0){
        rp = rp + String.fromCharCode(46);
      }
      //1.234.567
      for (var i = 0; i < dot; i++){
        rp = rp + money.substring(pointer,pointer + 3) + String.fromCharCode(46);
        pointer = pointer + 3;
      }

      rp = rp.substring(0,rp.length - 1);
      rp = 'Rp ' + rp;

      return rp;
    };
        
    $http.get(url_base+"canceling/BAViewDetail/"+id).success(function (records) {
      $scope.BADetail = records;

      for (var i = 0; i < $scope.BADetail.length; i++){
        $scope.BADetail[i]['priceRp'] = convertRp($scope.BADetail[i]['price']);
        $scope.BADetail[i]['subtotalRp'] = convertRp($scope.BADetail[i]['subtotal']);
        $scope.BADetail[i]['totalRp'] = convertRp($scope.BADetail[i]['total']);
        $scope.BADetail[i]['serviceRp'] = convertRp($scope.BADetail[i]['service']);
        $scope.BADetail[i]['taxRp'] = convertRp($scope.BADetail[i]['tax']);
        $scope.BADetail[i]['total2Rp'] = convertRp($scope.BADetail[i]['total2']);
      }
    });

    $http.get(url_base+"canceling/getCancelDetail/"+id).success(function (records) {
      $scope.bySelected = records[0]['full_name'];
      $scope.codeSelected = records[0]['code'];
      $scope.dateSelected = records[0]['ba_date'];
      $scope.statusSelected = records[0]['status'];
      $scope.atSelected = records[0]['created_at'];
    });
  }
]);

app.controller('CancelsController', function($scope,$http,$timeout) {
  $scope.cancelList = [];
  $scope.date = '';
  $scope.table = '';
  $scope.comment = '';
  $scope.distinctItem = 0;
  $scope.totalPrice = 0;
  $scope.service = 0;
  $scope.tax = 0;
  $scope.totalPrice2 = 0;
  $scope.hidden = true;
  $("#masking").hide();
  $("#divList").hide();
  $("#divNotif").hide();

  $("#datepicker").datepicker();

  $http.get(url_base+"canceling/BAView").success(function (records) {
    $scope.BA = records;
    $scope.currentPage = 1; //current page
    $scope.entryLimit = 25; //max no of items to display in a page
    $scope.filteredItems = $scope.BA.length; //Initially for no filter  
    $scope.totalItems = $scope.BA.length;
  });

  $http.get(url_base+"canceling/menuView").success(function (records) {
    $scope.names = records;
    $scope.currentPage = 1; //current page
    $scope.entryLimit = 9999; //max no of items to display in a page
    $scope.filteredItems = $scope.names.length; //Initially for no filter  
    $scope.totalItems = $scope.names.length;

    for (var i = 0; i < $scope.names.length; i++){
      $scope.names[i]['menu_priceRp'] = convertRp($scope.names[i]['menu_price']);
    }
  });

  function isExist(id){
    for (var i = $scope.cancelList.length - 1; i >= 0; i--) {
      if ($scope.cancelList[i].menu_id == id) {
        return true;
      };
    };
    return false;
  };

  function parsingDate(date) {
    //09/01/2015   1 sep 2015
    var identify1 = date.substring(2,3);
    var identify2 = date.substring(5,6);
    if (identify1 == '/' && identify2 == '/'){
      if (date == '') {
        return '';
      }
      else {
        var dd = date.substring(3,5);
        var mm = date.substring(0,2);
        var yyyy = date.substring(6,10);
        var parsing = yyyy+"-"+mm+"-"+dd;

        return parsing;
      }
    }
    else{
      return date;
    }
  }

  function totalPrice(){
    var total = 0;

    for (var i = $scope.cancelList.length - 1; i >= 0; i--) {
      total = parseInt(total) + parseInt($scope.cancelList[i].subtotal);
    };

    return total;
  };

  function convertRp(input){
    var money = input.toString();
    var pointer = money.length % 3;
    var dot = Math.floor(money.length / 3);
    var rp = money.substring(0,pointer);

    if (pointer != 0){
      rp = rp + String.fromCharCode(46);
    }
    //1.234.567
    for (var i = 0; i < dot; i++){
      rp = rp + money.substring(pointer,pointer + 3) + String.fromCharCode(46);
      pointer = pointer + 3;
    }

    rp = rp.substring(0,rp.length - 1);
    rp = 'Rp ' + rp;

    return rp;
  };

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
    $timeout(function() { 
      $scope.filteredItems = $scope.filtered.length;
    }, 25);
    alert($scope.filtered.length);
  };

  $scope.addCancelMenu = function(id,code,name,price) {
    $scope.menuName = name;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addCount = function(count){
      if ($scope.count > 0) {
        if (isExist(id) == false) {
          $scope.cancelList.push({"menu_id":id,"menu_code":code,"menu_name":name,"menu_price":price,"quantity":count,"subtotal":price*count,"rp":convertRp(price),"rp2":convertRp(price*count)});
        }
        else {
          for (var i = $scope.cancelList.length - 1; i >= 0; i--) {
            if ($scope.cancelList[i].menu_id == id) {
              var qty = parseFloat($scope.cancelList[i].quantity) + parseFloat(count);

              $scope.cancelList[i].quantity = qty;
              $scope.cancelList[i].subtotal = qty * price;
            };
          };
        };
        $scope.distinctItem = $scope.cancelList.length;
        $scope.totalPrice = totalPrice();
        $scope.service = Math.floor($scope.totalPrice / 20);
        $scope.tax = Math.floor($scope.totalPrice / 10);
        $scope.totalPrice2 = $scope.totalPrice + $scope.service + $scope.tax;
        $scope.totalPriceRp = convertRp($scope.totalPrice);
        $scope.serviceRp = convertRp($scope.service);
        $scope.taxRp = convertRp($scope.tax);
        $scope.totalPrice2Rp = convertRp($scope.totalPrice2);
        $scope.count = '';
        $scope.menuName = '';
        $("#masking").hide();
      }
      else{
        $.growl.notice({ message: "Jumlah harus diatas 0" });
      }
    };
  };

  $scope.deleteCancelMenu = function(index) {
    $scope.cancelList.splice(index,1);
    $scope.distinctItem = $scope.cancelList.length;
    $scope.totalPrice = totalPrice();
    $scope.service = Math.floor($scope.totalPrice / 20);
    $scope.tax = Math.floor($scope.totalPrice / 10);
    $scope.totalPrice2 = $scope.totalPrice + $scope.service + $scope.tax;
    $scope.totalPriceRp = convertRp($scope.totalPrice);
    $scope.serviceRp = convertRp($scope.service);
    $scope.taxRp = convertRp($scope.tax);
    $scope.totalPrice2Rp = convertRp($scope.totalPrice2);
  };

  $scope.updateCount = function(id){
    var cId = "c"+id;
    var newVal = $("#"+cId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.cancelList.length - 1; i >= 0; i--) {
      if ($scope.cancelList[i].menu_id == id) {
        $scope.cancelList[i].quantity = newVal;
        $scope.cancelList[i].subtotal = newVal * $scope.cancelList[i].menu_price;
        $scope.cancelList[i].rp2 = convertRp($scope.cancelList[i].subtotal);
        $scope.totalPrice = totalPrice();
        $scope.service = Math.floor($scope.totalPrice / 20);
        $scope.tax = Math.floor($scope.totalPrice / 10);
        $scope.totalPrice2 = $scope.totalPrice + $scope.service + $scope.tax;
        $scope.totalPriceRp = convertRp($scope.totalPrice);
        $scope.serviceRp = convertRp($scope.service);
        $scope.taxRp = convertRp($scope.tax);
        $scope.totalPrice2Rp = convertRp($scope.totalPrice2);
      };
    };
  };

  $scope.saveMenuDetail = function(isgen) {
    var date = parsingDate($("#datepicker").val());

    if (date === ''){
      $.growl.warning({ message: 'Tanggal BA belum diisi' });
    }
    else if ($scope.table === ''){
      $.growl.warning({ message: 'No. meja belum diisi' });
    }
     else if ($scope.comment === ''){
      $.growl.warning({ message: 'Komentar belum diisi' });
    }
    else if ($scope.cancelList.length == 0){
      $.growl.warning({ message: 'Data menu yang dibatalkan belum ada' });
    }
    else{
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.date = parsingDate($("#datepicker").val());
      $scope.cancel = {"date":$scope.date,"table":$scope.table,"comment":$scope.comment};

      var json = JSON.stringify($scope.cancelList);
      var json2 = JSON.stringify($scope.cancel);
      
      $.ajax({
        type: 'post',
        url:url_base+'canceling/saveCancelOrder',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"canceling/getNotif").success(function (records) {
                  $scope.byNotif = records[0]['outlet_name'];
                  $scope.atNotif = records[0]['at'];
                  $scope.codeNotif = records[0]['code'];
                  $scope.closingNotif = records[0]['closing_date'];
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

  $scope.showDivList = function() {
    window.scrollTo(0,0);
    $("#divMain").hide();
    $("#divList").css({top:-80,left:0,position:"absolute"});
    $("#divList").css("z-index","9998");
    $("#divList").show();
    $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.count = '';
  };
});