var app = angular.module('engagement', [
	'ngRoute','ngAnimate','angular-ladda','ui.bootstrap'
]);

app.config(['$routeProvider', function ($routeProvider) {
  $routeProvider
	// Home
	.when("/", {templateUrl:url_base+"src/warehouse/home.html", controller: "WhHomeController"})
	.when("/profile", {templateUrl: url_base+"src/warehouse/profile.html", controller: "profile"})

	//Product
	.when("/product1", {templateUrl:url_base+"src/warehouse/product/productView.html", controller: "ProductController"})
	.when("/product2", {templateUrl:url_base+"src/warehouse/product/productNew.html", controller: "ProductNewController"})
	.when("/product3/:id", {templateUrl:url_base+"src/warehouse/product/productEdit.html", controller: "ProductEditController"})
	.when("/product4", {templateUrl:url_base+"src/warehouse/warehouse2/product/productView.html", controller: "ProductController"})
	.when("/product5", {templateUrl:url_base+"src/warehouse/warehouse2/product/productNew.html", controller: "ProductNewController"})
	.when("/product6/:id", {templateUrl:url_base+"src/warehouse/product/warehouse2/productEdit.html", controller: "ProductEditController"})

	//Category
	.when("/category1", {templateUrl:url_base+"src/warehouse/product/categoryView.html", controller: "CategoryController"})
	.when("/category2", {templateUrl:url_base+"src/warehouse/product/categoryNew.html", controller: "CategoryNewController"})
	.when("/category3/:id", {templateUrl:url_base+"src/warehouse/product/categoryEdit.html", controller: "CategoryEditController"})
	.when("/category4", {templateUrl:url_base+"src/warehouse/warehouse2/product/categoryView.html", controller: "CategoryController"})
	.when("/category5", {templateUrl:url_base+"src/warehouse/warehouse2/product/categoryNew.html", controller: "CategoryNewController"})
	.when("/category6/:id", {templateUrl:url_base+"src/warehouse/warehouse2/product/categoryEdit.html", controller: "CategoryEditController"})

	//Group
	.when("/group1", {templateUrl:url_base+"src/warehouse/product/groupView.html", controller: "GroupController"})
	.when("/group2", {templateUrl:url_base+"src/warehouse/product/groupNew.html", controller: "GroupNewController"})
	.when("/group3/:id", {templateUrl:url_base+"src/warehouse/product/groupEdit.html", controller: "GroupEditController"})
	.when("/group4", {templateUrl:url_base+"src/warehouse/warehouse2/product/groupView.html", controller: "GroupController"})
	.when("/group5", {templateUrl:url_base+"src/warehouse/warehouse2/product/groupNew.html", controller: "GroupNewController"})
	.when("/group6/:id", {templateUrl:url_base+"src/warehouse/warehouse2/product/groupEdit.html", controller: "GroupEditController"})

	//Supplier
	.when("/supplier1", {templateUrl:url_base+"src/warehouse/supplier/supplierView.html", controller: "SupplierController"})
	.when("/supplier2", {templateUrl:url_base+"src/warehouse/supplier/supplierNew.html", controller: "SupplierNewController"})
	.when("/supplier3/:id", {templateUrl:url_base+"src/warehouse/supplier/supplierEdit.html", controller: "SupplierEditController"})

	//Section
	.when("/section1", {templateUrl:url_base+"src/warehouse/section/sectionView.html", controller: "SectionController"})
	.when("/section2", {templateUrl:url_base+"src/warehouse/section/sectionNew.html", controller: "SectionNewController"})
	.when("/section3/:id", {templateUrl:url_base+"src/warehouse/section/sectionEdit.html", controller: "SectionEditController"})

	//projection
	.when("/projection1", {templateUrl:url_base+"src/warehouse/projection/projectionView.html", controller: "ProjectionController"})
	.when("/projection2", {templateUrl:url_base+"src/warehouse/projection/projectionNew.html", controller: "ProjectionNewController"})
	.when("/projection3/:id", {templateUrl:url_base+"src/warehouse/projection/projectionViewDetail.html", controller: "ProjectionDetailController"})
	.when("/projection4/:id", {templateUrl:url_base+"src/warehouse/projection/projectionEditDetail.html", controller: "ProjectionEditController"})
	.when("/projection5/:id", {templateUrl:url_base+"src/warehouse/projection/projectionBreakDown.html", controller: "ProjectionBreakDownController"})

	//PO
	.when("/purchaseOrder1", {templateUrl:url_base+"src/warehouse/po/poView.html", controller: "PoController"})
	.when("/purchaseOrder2/:id", {templateUrl:url_base+"src/warehouse/po/poViewDetail.html", controller: "PoDetailController"})
	.when("/purchaseOrder3", {templateUrl:url_base+"src/warehouse/po/poNew.html", controller: "PoNewController"})

	//PR
	.when("/purchaseReceipt1", {templateUrl:url_base+"src/warehouse/pr/prView.html", controller: "PrController"})
	.when("/purchaseReceipt2/:id", {templateUrl:url_base+"src/warehouse/pr/prViewDetail.html", controller: "PrDetailController"})
	.when("/purchaseReceipt3", {templateUrl:url_base+"src/warehouse/pr/prNew.html", controller: "PrNewController"})
	.when("/purchaseReceipt4", {templateUrl:url_base+"src/warehouse/warehouse2/pr/prView.html", controller: "PrController"})
	.when("/purchaseReceipt5/:id", {templateUrl:url_base+"src/warehouse/warehouse2/pr/prViewDetail.html", controller: "PrDetailController"})
	.when("/purchaseReceipt6", {templateUrl:url_base+"src/warehouse/warehouse2/pr/prNew.html", controller: "PrNewController"})

	//RT
	.when("/purchaseReturn1", {templateUrl:url_base+"src/warehouse/rt/rtView.html", controller: "RtController"})
	.when("/purchaseReturn2/:id", {templateUrl:url_base+"src/warehouse/rt/rtViewDetail.html", controller: "RtDetailController"})
	.when("/purchaseReturn3", {templateUrl:url_base+"src/warehouse/rt/rtNew.html", controller: "RtNewController"})
	.when("/purchaseReturn4", {templateUrl:url_base+"src/warehouse/warehouse2/rt/rtView.html", controller: "RtController"})
	.when("/purchaseReturn5/:id", {templateUrl:url_base+"src/warehouse/warehouse2/rt/rtViewDetail.html", controller: "RtDetailController"})
	.when("/purchaseReturn6", {templateUrl:url_base+"src/warehouse/warehouse2/rt/rtNew.html", controller: "RtNewController"})

	//DO
	.when("/deliveryOrder1", {templateUrl:url_base+"src/warehouse/do/doView.html", controller: "DoController"})
	.when("/deliveryOrder2/:id", {templateUrl:url_base+"src/warehouse/do/doViewDetail.html", controller: "DoDetailController"})
	.when("/deliveryOrder3", {templateUrl:url_base+"src/warehouse/do/doNew.html", controller: "DoNewController"})
	.when("/deliveryOrder4", {templateUrl:url_base+"src/warehouse/warehouse2/do/doView.html", controller: "DoController"})
	.when("/deliveryOrder5/:id", {templateUrl:url_base+"src/warehouse/warehouse2/do/doViewDetail.html", controller: "DoDetailController"})
	.when("/deliveryOrder6", {templateUrl:url_base+"src/warehouse/warehouse2/do/doNew.html", controller: "DoNewController"})

	//SO
	.when("/salesOrder1", {templateUrl:url_base+"src/warehouse/so/soView.html", controller: "SoController"})
	.when("/salesOrder2/:id", {templateUrl:url_base+"src/warehouse/so/soViewDetail.html", controller: "SoDetailController"})
	.when("/salesOrder3", {templateUrl:url_base+"src/warehouse/so/soNew.html", controller: "SoNewController"})
	.when("/salesOrder4/:id", {templateUrl:url_base+"src/warehouse/so/soDetailEdit.html", controller: "SoEditController"})
	
	//MR
	.when("/manufacturReceipt1", {templateUrl:url_base+"src/warehouse/mr/mrView.html", controller: "MrController"})
	.when("/manufacturReceipt2/:id", {templateUrl:url_base+"src/warehouse/mr/mrViewDetail.html", controller: "MrDetailController"})
	.when("/manufacturReceipt3", {templateUrl:url_base+"src/warehouse/mr/mrNew.html", controller: "MrNewController"})
	.when("/manufacturReceipt4", {templateUrl:url_base+"src/warehouse/warehouse2/mr/mrView.html", controller: "MrController"})
	.when("/manufacturReceipt5/:id", {templateUrl:url_base+"src/warehouse/warehouse2/mr/mrViewDetail.html", controller: "MrDetailController"})
	.when("/manufacturReceipt6", {templateUrl:url_base+"src/warehouse/warehouse2/mr/mrNew.html", controller: "MrNewController"})

	//MO
	.when("/manufacturOrder1", {templateUrl:url_base+"src/warehouse/mo/moView.html", controller: "MoController"})
	.when("/manufacturOrder2/:id", {templateUrl:url_base+"src/warehouse/mo/moViewDetail.html", controller: "MoDetailController"})
	.when("/manufacturOrder3", {templateUrl:url_base+"src/warehouse/mo/moNew.html", controller: "MoNewController"})

	//MT
	.when("/materialOut1", {templateUrl:url_base+"src/warehouse/mt/mtView.html", controller: "MtController"})
	.when("/materialOut2/:id", {templateUrl:url_base+"src/warehouse/mt/mtViewDetail.html", controller: "MtDetailController"})
	.when("/materialOut3", {templateUrl:url_base+"src/warehouse/mt/mtNew.html", controller: "MtNewController"})
	.when("/materialOut4", {templateUrl:url_base+"src/warehouse/warehouse2/mt/mtView.html", controller: "MtController"})
	.when("/materialOut5/:id", {templateUrl:url_base+"src/warehouse/warehouse2/mt/mtViewDetail.html", controller: "MtDetailController"})
	.when("/materialOut6", {templateUrl:url_base+"src/warehouse/warehouse2/mt/mtNew.html", controller: "MtNewController"})


	//TI
	.when("/transferIn1", {templateUrl:url_base+"src/warehouse/ti/tiView.html", controller: "TiController"})
	.when("/transferIn2/:id", {templateUrl:url_base+"src/warehouse/ti/tiViewDetail.html", controller: "TiDetailController"})
	.when("/transferIn3", {templateUrl:url_base+"src/warehouse/ti/tiNew.html", controller: "TiNewController"})
	.when("/transferIn4", {templateUrl:url_base+"src/warehouse/warehouse2/ti/tiView.html", controller: "TiController"})
	.when("/transferIn5/:id", {templateUrl:url_base+"src/warehouse/warehouse2/ti/tiViewDetail.html", controller: "TiDetailController"})
	.when("/transferIn6", {templateUrl:url_base+"src/warehouse/warehouse2/ti/tiNew.html", controller: "TiNewController"})

	//TO
	.when("/transferOut1", {templateUrl:url_base+"src/warehouse/to/toView.html", controller: "ToController"})
	.when("/transferOut2/:id", {templateUrl:url_base+"src/warehouse/to/toViewDetail.html", controller: "ToDetailController"})
	.when("/transferOut3", {templateUrl:url_base+"src/warehouse/to/toNew.html", controller: "ToNewController"})
	.when("/transferOut4", {templateUrl:url_base+"src/warehouse/warehouse2/to/toView.html", controller: "ToController"})
	.when("/transferOut5/:id", {templateUrl:url_base+"src/warehouse/warehouse2/to/toViewDetail.html", controller: "ToDetailController"})
	.when("/transferOut6", {templateUrl:url_base+"src/warehouse/warehouse2/to/toNew.html", controller: "ToNewController"})

	//ST
	.when("/stockOpname1", {templateUrl:url_base+"src/warehouse/st/stView.html", controller: "StController"})
	.when("/stockOpname2/:id", {templateUrl:url_base+"src/warehouse/st/stViewDetail.html", controller: "StDetailController"})
	.when("/stockOpname3", {templateUrl:url_base+"src/warehouse/st/stNew.html", controller: "StNewController"})
	.when("/stockOpname4/:id", {templateUrl:url_base+"src/warehouse/st/stEditDetail.html", controller: "StEditDetailController"})

	//CS
	.when("/currentStock1", {templateUrl:url_base+"src/warehouse/cs/csView.html", controller: "CsController"})

	//RP
	.when("/report1", {templateUrl:url_base+"src/warehouse/rp/r1.html", controller: "R1Controller"})
	.when("/report2", {templateUrl:url_base+"src/warehouse/rp/r2.html", controller: "R2Controller"})
	.when("/report3", {templateUrl:url_base+"src/warehouse/rp/r3.html", controller: "R3Controller"})

	//Finance
	.when("/finance1", {templateUrl:url_base+"src/warehouse/fin/journal.html", controller: "JournalController"})
	.when("/finance2/:id", {templateUrl:url_base+"src/warehouse/fin/journalEdit.html", controller: "JournalEditController"})
	.when("/finance3", {templateUrl:url_base+"src/warehouse/fin/journalNew.html", controller: "JournalNewController"})

	//Cash Bank
	.when("/cashbank1", {templateUrl:url_base+"src/warehouse/cb/cashbank.html", controller: "CashBankController"})
	.when("/cashbank2/:id", {templateUrl:url_base+"src/warehouse/cb/cashbankEdit.html", controller: "CashBankEditController"})
	.when("/cashbank3", {templateUrl:url_base+"src/warehouse/cb/cashbankNew.html", controller: "CashBankNewController"})

	//Transfer Account
	.when("/transferaccount1", {templateUrl:url_base+"src/warehouse/ta/transferaccountNew.html", controller: "TransferAccountNewController"})

	//Cost Income
	.when("/costincome1", {templateUrl:url_base+"src/warehouse/ci/costincomeNew.html", controller: "CostIncomeNewController"})

	//Ledger
	.when("/ledger1", {templateUrl:url_base+"src/warehouse/led/ledger.html", controller: "LedgerController"})
	.when("/ledger2/:id", {templateUrl:url_base+"src/warehouse/led/ledgerEdit.html", controller: "LedgerEditController"})

	//Trial Balance
	.when("/trialbalance1", {templateUrl:url_base+"src/warehouse/tb/trialbalance.html", controller: "TrialBalanceController"})

	//Profit Loss
	.when("/profitloss1", {templateUrl:url_base+"src/warehouse/pl/profitloss.html", controller: "ProfitLossController"})

	//Balance Sheet
	.when("/balancesheet1", {templateUrl:url_base+"src/warehouse/bs/balancesheet.html", controller: "BalanceSheetController"})

	//Purchase History
	.when("/purchasehistory1", {templateUrl:url_base+"src/warehouse/ph/purchasehistory.html", controller: "PurchaseHistoryController"})
	.when("/purchasehistory2/:id", {templateUrl:url_base+"src/warehouse/ph/purchasehistorydetail.html", controller: "PurchaseHistoryDetailController"})
	
	//Purchase payment
	.when("/purchasepayment1", {templateUrl:url_base+"src/warehouse/pp/purchasepayment.html", controller: "PurchasePaymentController"})

	//Purchase giro
	.when("/purchasegiro1", {templateUrl:url_base+"src/warehouse/pg/purchasegiro.html", controller: "PurchaseGiroController"})

	//Sales payment
	.when("/salespayment1", {templateUrl:url_base+"src/warehouse/sp/salespayment.html", controller: "SalesPaymentController"})

	//Others
	.when("/etc1", {templateUrl:url_base+"src/warehouse/etc/initSaldo.html", controller: "InitSaldoController"})
	.when("/etc2", {templateUrl:url_base+"src/warehouse/etc/newAccount.html", controller: "NewAccountController"})
	.when("/etc3", {templateUrl:url_base+"src/warehouse/etc/groupAccount.html", controller: "GroupAccountController"})

	.otherwise("/404", {templateUrl: url_base+"src/page/404.html", controller: "PageCtrl"});
}]);

app.controller('PageCtrl', function($scope) {
	$scope.pageClass = 'page-home';
});


app.factory('StatusList', function(){
	var Statuses = {};
	Statuses.list = [{code:'1', name:'Aktif'}, {code:'0', name:'Tidak Aktif'}];
	return Statuses;
});


app.controller('produk_page', function ($scope, $http, $timeout) {
	$http.get(url_base+'index.php/master_products/find_all').success(function(data){
		$scope.list = data;	
		$scope.currentPage = 1; //current page
		$scope.entryLimit = 20; //max no of items to display in a page
		$scope.filteredItems = $scope.list.length; //Initially for no filter  
		$scope.totalItems = $scope.list.length;
	 });
	$scope.pageClass = 'page-home';
	$scope.setPage = function(pageNo) {
		$scope.currentPage = pageNo;
	};
	$scope.filter = function() {
		$timeout(function() { 
			$scope.filteredItems = $scope.filtered.length;
		}, 10);
	};
	$scope.sort_by = function(predicate) {
		$scope.predicate = predicate;
		$scope.reverse = !$scope.reverse;
	};

});

app.directive('onlyNumbers', function() {
	return function(scope, element, attrs) {
		var keyCode = [8,9,13,37,39,46,48,49,50,51,52,53,54,55,56,57,96,97,98,99,100,101,102,103,104,105,110,190];
		element.bind("keydown", function(event) {
		 if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
				event.preventDefault();
			 }

			});
		};
});

app.directive('onlyIntegers', function() {
	return function(scope, element, attrs) {
		var keyCode = [8,9,13,35,36,37,39,48,49,50,51,52,53,54,55,56,57,127];
		element.bind("keydown", function(event) {
		 if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
				event.preventDefault();
			 }

			});
		};
});

app.filter('startFrom', function() {
	return function(input, start) {
		if(input) {
			start = +start; //parse to int
			return input.slice(start);
		}
		return [];
	}
});


app.factory('UtilList', function($http)
{
	return {
		outletList: function(callback) {
			var url = url_base + 'master/outlets/';
			$http.get(url).success(callback);
		},
		menuActiveList: function(callback) {
			var url = url_base + 'master/menus/getActiveMenus';
			$http.get(url).success(callback);
		},
	}
});

app.directive('ngEnter', function () {
	return function (scope, element, attrs) {
		element.bind("keydown keypress", function (event) {
			if(event.which === 13) {
				scope.$apply(function (){
					scope.$eval(attrs.ngEnter);
				});

				event.preventDefault();
			}
		});
	};
});