<?php 
class wh_projection extends CI_Controller{
	function getLv(){
		$author_id = $this->session->userdata('author_id');

		$sql = "select level
				from user_apps
				where id = ".$author_id;

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function pjViewDetailHeader($id){
		$sql = "select a.id,code,date,section_name,b.id section_id
				from projection_products a inner join master_sections b
				on a.section_id = b.id
				where a.status = 1
				and a.id = ".$id."
				order by 2";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function pjViewDetail($id){
		$sql = "select product_id,product_name,product_code,unit_large,saldo,plan_in,total_order,projection_qty,stock,stock - total_order sisa
				from(
				select product_id,product_name,product_code,unit_large,saldo,plan_in,total_order,projection_qty,saldo+plan_in stock
				from (
				select a.product_id,concat(product_name,' (1 ',b.unit_large,' = ',conversion,' ',unit_small,')') product_name,product_code,b.unit_large,saldo,plan_in,total_order,projection_qty
				from projection_product_details a inner join master_products b
				on a.product_id = b.product_id
				where projection_id = ".$id.") a) b
				order by 2";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}
	
	function projectionView(){
		$sql = "select a.id,code,date,section_name
				from projection_products a inner join master_sections b
				on a.section_id = b.id
				where a.status = 1
				order by 2";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function categoryEditView($id){
		$sql = "select category_name,is_active
				from master_product_categories
				where category_id = ".$id;

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function saveNew(){
		$data = json_decode($this->input->post('json'));

		$this->db->trans_begin();

		$sql = "select count(*) x
				from master_sections
				where section_code = '".$data->code."'";

		$count = $this->db->query($sql)->row();

		if ($count->x == 0){
			$insert = "insert into master_sections values('','".$data->name."',".$data->active.",'".$data->code."',0)";

			$this->db->query($insert);

			if ($this->db->trans_status() === FALSE)
			{
			    $this->db->trans_rollback();
			    $result = array('status' => 'gagal');
			    print json_encode($result);
			}
			else
			{
			    $this->db->trans_commit();
			    $result = array('status' => 'sukses');
			    print json_encode($result);
			}
		}
		else {
			$result = array('status' => 'duplikat');
			print json_encode($result);
		}
	}

	function sectionView(){
		$sql = "select id,section_name
				from master_sections
				order by 2";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function ceilProduct(){
		$data = json_decode(file_get_contents('php://input'));

		$sql = "select yield * cooking_standard x
				from master_recipee
				where product_id = ".$data->id;

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function generateProjection(){
		//$data = json_decode($this->input->post('json'));

		$data = json_decode(file_get_contents('php://input'));

		$sql = "select product_id,product_name,product_code,unit_large,ifnull(saldo,0) saldo,ifnull(p_in,0) p_in,ifnull(stock,0) stock,ifnull(orders,0) orders,ifnull(stock,0)-ifnull(orders,0) lefts,0 x,0 y from
				(select product_id,product_name,product_code,unit_large,saldo,p_in,saldo+p_in stock,orders from
				(select product_id,concat(product_name,' (1 ',unit_large,' = ',conversion,' ',unit_small,')') product_name,product_code,unit_large,
				(select ifnull(sum(physical_stock),0)
				from wh_stock_opname_detail a inner join wh_stock_opname b
				where product_id = x.product_id
				and a.opname_id = b.id
				and b.is_deleted = 0
				and b.deleted_notes <> 'invalid'
				and b.id = (select max(id)
						    from wh_stock_opname
						    where storage_id = b.storage_id)) +
				(select ifnull(sum(qty),0)
				from(
				select a.product_id,a.qty
				from wh_purchase_receipt_detail a,wh_purchase_receipt b
				where a.pr_id = b.id
				and b.createdat >= (select max(period_end)
									from wh_stock_opname
									where storage_id = b.storage_id)
				and b.createdat < (select concat(date(sysdate()),' 04:00:00'))
				union all
				select a.product_id,a.qty
				from wh_manufacturing_receipt_detail a,wh_manufacturing_receipt b
				where a.mr_id = b.id
				and b.createdat >= (select max(period_end)
									from wh_stock_opname
									where storage_id = b.storage_id)
				and b.createdat < (select concat(date(sysdate()),' 04:00:00'))
				union all
				select a.product_id,a.qty
				from wh_transfer_detail a,wh_transfer b
				where a.tr_id = b.id
				and tr_io = 'in'
				and b.createdat >= (select max(period_end)
								    from wh_stock_opname
								    where storage_id = b.tr_to)
				and b.createdat < (select concat(date(sysdate()),' 04:00:00'))
				) a
				where product_id = x.product_id) +
				(select ifnull(sum(qty),0)
				from(
				select a.product_id,a.qty
				from wh_purchase_return_detail a,wh_purchase_return b
				where a.return_id = b.id
				and b.createdat >= (select max(period_end)
									from wh_stock_opname
									where storage_id = b.storage_id)
				and b.createdat < (select concat(date(sysdate()),' 04:00:00'))
				union all
				select a.product_id,a.qty
				from wh_delivery_order_details a,wh_delivery_orders b
				where a.do_id = b.id
				and b.created_at >= (select max(period_end)
								     from wh_stock_opname
								     where storage_id = b.storage_id)
				and b.created_at < (select concat(date(sysdate()),' 04:00:00'))
				union all
				select a.material_id,a.qty
				from wh_material_out_detail a,wh_material_out b
				where a.mt_id = b.id
				and b.createdat >= (select max(period_end)
								     from wh_stock_opname
								     where storage_id = b.storage_id)
				and b.createdat < (select concat(date(sysdate()),' 04:00:00'))
				union all
				select a.product_id,a.qty
				from wh_transfer_detail a,wh_transfer b
				where a.tr_id = b.id
				and tr_io = 'out'
				and b.createdat >= (select max(period_end)
								    from wh_stock_opname
								    where storage_id = b.tr_from)
				and b.createdat < (select concat(date(sysdate()),' 04:00:00'))
				) a
				where product_id = x.product_id) saldo,
				(select projection_qty
				from projection_product_details
				where projection_id = (select max(id)
										from projection_products
										where date = date(sysdate())
										and status = 1)
				and product_id = x.product_id
				) p_in,
				(select ifnull(sum(qty),0)
				from wh_sales_order_detail
				where product_id = x.product_id
				and so_id in (select id
								from wh_sales_order
								where so_date = date(sysdate() + interval 1 day))) orders
				from master_products x
				where section_id = ".$data->section."
				) y) z
				order by 2";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function saveProjection(){
		$data = json_decode($this->input->post('json'));
		$data2 = json_decode($this->input->post('json2'));

		$author_id = $this->session->userdata('author_id');

		$select = "select warehouse_generate_code('PJ','projection',".$data2->section.",'section') code";
		$code = $this->db->query($select)->row();
		
		$select = "select coalesce(max(id),0) + 1 max_id
				   from projection_products";
		$nextId = $this->db->query($select)->row();

		$this->db->trans_begin();

		$insert = "insert into projection_products values(".$nextId->max_id.",'".$code->code."','".$data2->date."',".$data2->section.",".$author_id.",sysdate(),1)";
		$this->db->query($insert);

		for ($i = 0; $i < count($data); $i++) {
			$insert = "insert into projection_product_details values('',".$nextId->max_id.",".$data[$i]->product_id.",'".$data[$i]->unit_large."',".$data[$i]->saldo.",".$data[$i]->p_in.",".$data[$i]->orders.",0,".$data[$i]->y.")";
			$this->db->query($insert);
		}

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();
		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}
	}

	function saveEdit(){
		$data = json_decode($this->input->post('json'));
		$data2 = json_decode($this->input->post('json2'));

		$author_id = $this->session->userdata('author_id');

		$this->db->trans_begin();

		$update = "update projection_products
				   set date = '".$data2->date."'
				   where id = ".$data2->id;

		$this->db->query($update);

		for ($i = 0; $i < count($data); $i++) {
			$update = "update projection_product_details 
					   set projection_qty = ".$data[$i]->projection_qty."   
					   where projection_id = ".$data2->id."
					   and product_id = ".$data[$i]->product_id;

			$this->db->query($update);
		}

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();
		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}
	}


	function saveDelete(){
		$data = json_decode($this->input->post('json'));

		$this->db->trans_begin();

		
		$delete = "update projection_products
			       set status = 0
			       where id = ".$data->id;

		$this->db->query($delete);
		
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();
		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}
	}

	function projectionBreakDown($id){
		$sql = "select material_id,product_code,concat(product_name,' (1 ',unit_large,' = ',conversion,' ',unit_small,')') product_name,b.unit_large,round(x,2) x
				from(
				select material_id,sum(x) x
				from(
				select a.product_id,a.projection_qty,b.material_id,b.qty,a.projection_qty*b.qty/(select yield*cooking_standard
																								 from master_recipee
																								 where product_id = a.product_id) x
				from projection_product_details a inner join master_recipee_compositions b
				on a.product_id = b.product_id
				where projection_id = ".$id.") a
				group by material_id) a inner join master_products b
				on a.material_id = b.product_id
				where x <> 0
				order by 3";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function import(){
		$data = json_decode($this->input->post('json'));
		$data2 = json_decode($this->input->post('json2'));
		$data3 = json_decode($this->input->post('json3'));

		$author_id = $this->session->userdata('author_id');

		$select = "select warehouse_generate_code('MO','manufactur_order',".$data2->sectionId.",'section') code";
		$code = $this->db->query($select)->row();
		
		$select = "select coalesce(max(id),0) + 1 max_id
				   from wh_manufacturing_order";
		$nextId = $this->db->query($select)->row();

		$totalCount = 0;

		$this->db->trans_begin();

		$insert = "insert into wh_manufacturing_order values(".$nextId->max_id.",".$data2->sectionId.",'".$code->code."',sysdate(),'".$data2->dateSchedulle."',".$data2->distinctCount.",0,'save',sysdate(),".$author_id.")";

		$this->db->query($insert);

		for ($i = 0; $i < count($data); $i++) {
			$insert = "insert into wh_manufacturing_order_details values ('',".$nextId->max_id.",".$data3[$i]->product_id.",".$data3[$i]->projection_qty.")";
			$this->db->query($insert);

			$totalCount = $totalCount + $data[$i]->x;
		}

		for ($i = 0; $i < count($data); $i++) {
			$insert = "insert into wh_manufacturing_order_product_to_consume values ('',".$nextId->max_id.",".$data[$i]->material_id.",".$data[$i]->x.")";
			$this->db->query($insert);
		}

		$update = "update wh_manufacturing_order 
				   set total_item_qty = ".$totalCount."
				   where id = ".$nextId->max_id;

		$this->db->query($update);

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();
		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}	
	}


	function export(){
		$data = json_decode(file_get_contents('php://input'));

		$sql = "select a.id,a.date,upper(b.section_name) section_name
				from projection_products a inner join master_sections b
                on a.section_id = b.id
				where a.date = '".$data->date."'
				and status = 1";

		$model = $this->db->query($sql)->result();

		if ($data->type == 0){
			//$this->load->library('excel');
			$i = 0;

			foreach($model as $id){
				$this->load->library('excel');
				$this->excel->createSheet($i);
				$this->excel->setActiveSheetIndex($i);
				$this->excel->getActiveSheet()->setTitle('sheet'.$i);	
				
				//Report Title
				$row = 1;
				$this->excel->getActiveSheet()->setCellValue('A'.$row, "PROYEKSI TANGGAL ".$id->date);
				$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
				$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
				
				$row++;
				$this->excel->getActiveSheet()->setCellValue('A'.$row,$id->section_name);
				$row++;
				$row++;
				$this->excel->getActiveSheet()->setCellValue('A'.$row,"BREAKDOWN MATERIAL");
				
				$row+=1; 
				$header = $row;

				$this->excel->getActiveSheet()->setCellValue('A'.$row, "Kode");
				$this->excel->getActiveSheet()->setCellValue('B'.$row, "Nama");
				$this->excel->getActiveSheet()->setCellValue('C'.$row, "Unit");
				$this->excel->getActiveSheet()->setCellValue('D'.$row, "Qty");

				$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
				$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
				$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
				$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(10);

				$objRow = $this->excel->getActiveSheet()->getStyle('A'.$header.':D'.$header);
				$objRow->getFont()->setBold(true);
				$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
				$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FF99d9ea');

				$sql = "select material_id,product_code,product_name,b.unit_large,x
						from(
						select material_id,sum(x) x
						from(
						select a.product_id,a.projection_qty,b.material_id,b.qty,a.projection_qty*b.qty x
						from projection_product_details a inner join master_recipee_compositions b
						on a.product_id = b.product_id
						where projection_id = ".$id->id.") a
						group by material_id) a inner join master_products b
						on a.material_id = b.product_id";

				$model2 = $this->db->query($sql)->result();

				foreach($model2 as $product){
					$row+=1;

					$this->excel->getActiveSheet()->setCellValue('A'.$row, $product->product_code);
					$this->excel->getActiveSheet()->setCellValue('B'.$row, $product->product_name);
					$this->excel->getActiveSheet()->setCellValue('C'.$row, $product->unit_large);
					$this->excel->getActiveSheet()->setCellValue('D'.$row, $product->x);
				}

				$objRow = $this->excel->getActiveSheet()->getStyle('A1');
				$i++;
			}
		}
		else{
			//$this->load->library('excel');
			$i = 0;

			foreach($model as $id){
				$this->load->library('excel');
				$this->excel->createSheet($i);
				$this->excel->setActiveSheetIndex($i);
				$this->excel->getActiveSheet()->setTitle('sheet'.$i);	
				
				//Report Title
				$row = 1;
				$this->excel->getActiveSheet()->setCellValue('A'.$row, "PROYEKSI TANGGAL ".$id->date);
				$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
				$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
				
				$row++;
				$this->excel->getActiveSheet()->setCellValue('A'.$row,$id->section_name);
				$row++;
				$row++;
				$this->excel->getActiveSheet()->setCellValue('A'.$row,"DETAIL PROYEKSI");
				
				$row+=1; 
				$header = $row;

				$this->excel->getActiveSheet()->setCellValue('A'.$row, "Kode");
				$this->excel->getActiveSheet()->setCellValue('B'.$row, "Nama");
				$this->excel->getActiveSheet()->setCellValue('C'.$row, "Unit");
				$this->excel->getActiveSheet()->setCellValue('D'.$row, "Saldo");
				$this->excel->getActiveSheet()->setCellValue('E'.$row, "In");
				$this->excel->getActiveSheet()->setCellValue('F'.$row, "Stock");
				$this->excel->getActiveSheet()->setCellValue('G'.$row, "Order");
				$this->excel->getActiveSheet()->setCellValue('H'.$row, "Sisa");
				$this->excel->getActiveSheet()->setCellValue('I'.$row, "Proyeksi");

				$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
				$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
				$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
				$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
				$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
				$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
				$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
				$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
				$this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(10);

				$objRow = $this->excel->getActiveSheet()->getStyle('A'.$header.':I'.$header);
				$objRow->getFont()->setBold(true);
				$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
				$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FF99d9ea');

				$sql = "select b.product_id,b.product_name,b.product_code,b.unit_large,saldo,plan_in,saldo+plan_in stock,total_order,projection_qty,stock-total_order lefts
						from(
						select product_id,saldo,plan_in,saldo+plan_in stock,total_order,projection_qty
						from projection_product_details
						where projection_id = ".$id->id.") a inner join master_products b
						on a.product_id = b.product_id";

				$model2 = $this->db->query($sql)->result();

				foreach($model2 as $product){
					$row+=1;

					$this->excel->getActiveSheet()->setCellValue('A'.$row, $product->product_code);
					$this->excel->getActiveSheet()->setCellValue('B'.$row, $product->product_name);
					$this->excel->getActiveSheet()->setCellValue('C'.$row, $product->unit_large);
					$this->excel->getActiveSheet()->setCellValue('D'.$row, $product->saldo);
					$this->excel->getActiveSheet()->setCellValue('E'.$row, $product->plan_in);
					$this->excel->getActiveSheet()->setCellValue('F'.$row, $product->stock);
					$this->excel->getActiveSheet()->setCellValue('G'.$row, $product->total_order);
					$this->excel->getActiveSheet()->setCellValue('H'.$row, $product->lefts);
					$this->excel->getActiveSheet()->setCellValue('I'.$row, $product->projection_qty);
				}

				$objRow = $this->excel->getActiveSheet()->getStyle('A1');
				$i++;
			}
		}

		$filename = 'report_proyeksi_'.date('Ymd-Hi').'.xls';
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;
		
		if(file_exists($filepath))
			unlink($filepath);
		
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter,$this->excel);
		
		exit;
	}

	function exportDetail(){
		$data = json_decode(file_get_contents('php://input'));

		$sql = "select a.date,upper(b.section_name) section_name
				from projection_products a inner join master_sections b
				on a.section_id = b.id
				where a.id = ".$data->id;

		$model = $this->db->query($sql)->result();

		$i = 0;

		$this->load->library('excel');
		$this->excel->createSheet($i);
		$this->excel->setActiveSheetIndex($i);
		$this->excel->getActiveSheet()->setTitle('sheet'.$i);	
		
		//Report Title
		$row = 1;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "PROYEKSI TANGGAL ".$model[0]->date);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
		
		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row,$model[0]->section_name);
		$row++;
		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row,"DETAIL PROYEKSI");
		
		$row+=1; 
		$header = $row;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, "Kode");
		$this->excel->getActiveSheet()->setCellValue('B'.$row, "Nama");
		$this->excel->getActiveSheet()->setCellValue('C'.$row, "Unit");
		$this->excel->getActiveSheet()->setCellValue('D'.$row, "Saldo");
		$this->excel->getActiveSheet()->setCellValue('E'.$row, "In");
		$this->excel->getActiveSheet()->setCellValue('F'.$row, "Stock");
		$this->excel->getActiveSheet()->setCellValue('G'.$row, "Order");
		$this->excel->getActiveSheet()->setCellValue('H'.$row, "Sisa");
		$this->excel->getActiveSheet()->setCellValue('I'.$row, "Proyeksi");

		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(10);

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$header.':I'.$header);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FF99d9ea');

		$sql = "select b.product_id,b.product_name,b.product_code,b.unit_large,saldo,plan_in,saldo+plan_in stock,total_order,projection_qty,stock-total_order lefts
				from(
				select product_id,saldo,plan_in,saldo+plan_in stock,total_order,projection_qty
				from projection_product_details
				where projection_id = ".$data->id.") a inner join master_products b
				on a.product_id = b.product_id";

		$model2 = $this->db->query($sql)->result();

		foreach($model2 as $product){
			$row+=1;

			$this->excel->getActiveSheet()->setCellValue('A'.$row, $product->product_code);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $product->product_name);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $product->unit_large);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $product->saldo);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $product->plan_in);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $product->stock);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, $product->total_order);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, $product->lefts);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, $product->projection_qty);
		}

		$objRow = $this->excel->getActiveSheet()->getStyle('A1');

		$i++;

		$this->load->library('excel');
		$this->excel->createSheet($i);
		$this->excel->setActiveSheetIndex($i);
		$this->excel->getActiveSheet()->setTitle('sheet'.$i);	
		
		//Report Title
		$row = 1;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "PROYEKSI TANGGAL ".$model[0]->date);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
		
		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row,$model[0]->section_name);
		$row++;
		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row,"BREAKDOWN MATERIAL");
		
		$row+=1; 
		$header = $row;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, "Kode");
		$this->excel->getActiveSheet()->setCellValue('B'.$row, "Nama");
		$this->excel->getActiveSheet()->setCellValue('C'.$row, "Unit");
		$this->excel->getActiveSheet()->setCellValue('D'.$row, "Qty");

		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(10);

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$header.':D'.$header);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FF99d9ea');

		$sql = "select material_id,product_code,product_name,b.unit_large,x
				from(
				select material_id,sum(x) x
				from(
				select a.product_id,a.projection_qty,b.material_id,b.qty,a.projection_qty*b.qty x
				from projection_product_details a inner join master_recipee_compositions b
				on a.product_id = b.product_id
				where projection_id = ".$data->id.") a
				group by material_id) a inner join master_products b
				on a.material_id = b.product_id";

		$model2 = $this->db->query($sql)->result();

		foreach($model2 as $product){
			$row+=1;

			$this->excel->getActiveSheet()->setCellValue('A'.$row, $product->product_code);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $product->product_name);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $product->unit_large);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $product->x);
		}

		$objRow = $this->excel->getActiveSheet()->getStyle('A1');

		$filename = 'report_proyeksi_'.date('Ymd-Hi').'.xls';
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;
		
		if(file_exists($filepath))
			unlink($filepath);
		
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter,$this->excel);
		
		exit;
	}
}
?>