<?php /**
* 
*/
class Sale_Menu extends CI_Controller
{
	function index()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
			echo json_encode($this->generateReport($data->Reports));
	}
	
	function generateReport($data)
	{
		$fields = array(
				array('code'=>'menu_id', 'title'=>'ID', 'width'=>5),
				array('code'=>'menu_code', 'title'=>'Kode', 'width'=>8), 
				array('code'=>'menu_name', 'title'=> 'Nama Menu', 'width'=>40), 
				array('code'=>'price', 'title'=> 'Harga', 'width'=>12),
				array('code'=>'total', 'title'=> 'Total', 'width'=>8));
		$this->load->model('report_sale_menu');
		if($data->viewtype == 'total')
			return $this->report_sale_menu->viewTotal($data, $fields);
		else if($data->viewtype == 'monthly')
			return $this->report_sale_menu->viewMonthly($data, $fields);
		else
			return $this->report_sale_menu->viewDaily($data, $fields);
	}
	
	function export()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
		{
			$result = $this->generateReport($data->Reports);
			$this->load->model('outlets');
			$outlet_name = (isset($data->Reports->outlet_id)) && ($data->Reports->outlet_id * 1) > 0 ? $this->outlets->getOutletName($data->Reports->outlet_id) : 'All Outlet';
			$header_view = array();
			$header_view[] = 'Outlet : '.$outlet_name;
			$header_view[] = 'Periode : '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end;
			$filename = $data->label.($outlet_name == '' ? '' : ' '.$outlet_name).' '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end.' '.$data->Reports->viewtype.'.xls';
			$this->load->model('Export_Excel');
			$this->Export_Excel->runExport($data->title, $header_view, $result['fields'], $result['field_values'], $filename);
		}
	}
} ?>