<?php /**
* 
*/
class Menus extends CI_Controller
{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Menus))
			{
				$data = $data->Menus;
				$result = $this->db->insert('master_menus',$data);
				$result = $this->findby_pk($this->db->insert_id());
				echo '{"success":{"msg":"Data menu BERHASIL disimpan !"}, "menu":'.json_encode($result).'}';
			} else {
				echo json_encode(array('categories'=>$this->find_all_categories()));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data menu !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Menus))
			{
				$data = $data->Menus;
				$this->db->where('menu_id', $id);
				$result = $this->db->update('master_menus',$data);
				$result = $this->findby_pk($id);
				echo '{"success":{"msg":"Data menu BERHASIL disimpan !"}, "menu":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode(array(
							'list'=>$result,
							'packages'=>$this->find_menu_packages($id),
							'compositions'=>$this->find_menu_compositions($id),
							'package_compositions'=>$this->find_menu_package_compositions($id),
							'categories'=>$this->find_all_categories()));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data menu !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('menu_id', $id);
			$this->db->delete('master_menus');
			
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data menu !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			$result = $this->findby_pk($id);
			echo json_encode(array(
						'list'=>$result,
						'packages'=>$this->find_menu_packages($id),
						'compositions'=>$this->find_menu_compositions($id),
						'package_compositions'=>$this->find_menu_package_compositions($id),
						'categories'=>$this->find_all_categories()));
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data menu !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function getActiveMenus()
	{
		$result = $this->find_active();
		echo json_encode($result);
	}
	
	function find_all()
	{
		$sql = "select menu_id, category_id, menu_code, menu_name, menu_nick, fc_format_rupiah(menu_price) AS menu_price, is_active, is_package from master_menus";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "select * from master_menus where menu_id= ".$id_;
		return $this->db->query($sql)->result();
	}
	
	function find_all_categories()
	{
		$sql = "select * from master_menu_categories";
		return $this->db->query($sql)->result();
	}
	
	function find_menu_packages($id)
	{
		$sql = "SELECT A.*, B.menu_code, B.menu_name, B.menu_nick, B.menu_price, B.is_active 
				FROM `master_menu_packages` A INNER JOIN `master_menus` B ON A.menu_id = B.menu_id 
				WHERE A.package_id = ".$id;
		return $this->db->query($sql)->result();
	}
	
	function find_menu_compositions($id)
	{
		$sql = "SELECT A.*, B.product_name, B.unit_small, B.is_active 
				FROM `master_menu_compositions` A INNER JOIN `master_products` B ON A.product_id = B.product_id 
				WHERE A.menu_id = ".$id;
		return $this->db->query($sql)->result();
	}
	
	function find_menu_package_compositions($id)
	{
		$sql = "SELECT C.product_id, D.product_code, D.product_name, unit_small, SUM(MENU.qty * qty_dynein) AS qty_dynein, SUM(MENU.qty * qty_deltak) AS qty_deltak, D.is_active
				FROM (SELECT A.menu_id AS `package_id`
							  , CASE WHEN B.menu_id IS NULL THEN A.menu_id ELSE B.menu_id END AS `menu_id`
							, CASE WHEN B.menu_id IS NULL THEN 1 ELSE B.qty END AS `qty`
					FROM `master_menus` A LEFT JOIN `master_menu_packages` B ON A.menu_id = B.package_id
					WHERE A.menu_id = ".$id.") MENU INNER JOIN `master_menu_compositions` C ON MENU.menu_id = C.menu_id
							INNER JOIN `master_products` D ON C.product_id = D.product_id
				GROUP BY C.product_id, D.product_code, D.product_name, unit_small";
		return $this->db->query($sql)->result();
	}
	
	function find_active()
	{
		$sql = "SELECT menu_id, menu_code, menu_name, is_package FROM master_menus WHERE is_active = 1 ORDER BY menu_name";
		return $this->db->query($sql)->result();
	}
	
	function export()
	{
		$sql = "SELECT A.menu_id, B.menu_code, B.menu_name, A.product_id, C.product_code, C.product_name, C.unit_small, A.qty_dynein, qty_deltak
				FROM `master_menu_compositions` A INNER JOIN `master_menus` B ON A.menu_id = B.menu_id
					INNER JOIN `master_products` C ON A.product_id = C.product_id
				ORDER BY B.menu_code, C.product_name";
		$model = $this->db->query($sql)->result();
		
		$this->load->library('excel');
		$this->excel->setActiveSheetIndex(0);
		$this->excel->getActiveSheet()->setTitle('sheet1');
		
		//Report Title
		$row = 1;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "DAFTAR KOMPOSISI MENU");
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
		
		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "Aplikasi Inventory Web");
		
		$row+=2; $header_start = $row;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "Menu Info");
		$this->excel->getActiveSheet()->mergeCells('A'.$row.':C'.$row);
		$this->excel->getActiveSheet()->setCellValue('D'.$row, "Product Info");
		$this->excel->getActiveSheet()->mergeCells('D'.$row.':F'.$row);
		$this->excel->getActiveSheet()->setCellValue('H'.$row, "Komposisi");
		$this->excel->getActiveSheet()->mergeCells('H'.$row.':I'.$row);
		
		$row+=1; $header_end = $row;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "ID");
		$this->excel->getActiveSheet()->setCellValue('B'.$row, "CODE");
		$this->excel->getActiveSheet()->setCellValue('C'.$row, "NAME");
		$this->excel->getActiveSheet()->setCellValue('D'.$row, "ID");
		$this->excel->getActiveSheet()->setCellValue('E'.$row, "CODE");
		$this->excel->getActiveSheet()->setCellValue('F'.$row, "NAME");
		$this->excel->getActiveSheet()->setCellValue('G'.$row, "UNIT");
		$this->excel->getActiveSheet()->setCellValue('H'.$row, "DYNE IN");
		$this->excel->getActiveSheet()->setCellValue('I'.$row, "DELTAK");
		
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(8);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(40);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(7);
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(40);
		$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(12);
		$this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
		
		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$header_start.':I'.$header_end);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		foreach($model as $comp)
		{
			$row+=1;
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $comp->menu_id);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $comp->menu_code);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $comp->menu_name);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $comp->product_id);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $comp->product_code);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $comp->product_name);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, $comp->unit_small);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, $comp->qty_dynein);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, $comp->qty_deltak);
		}
		
		$styleArray = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$this->excel->getActiveSheet()->getStyle('A'.$header_start.':I'.$row)->applyFromArray($styleArray);
		
		unset($styleArray);
		
		$filename = 'Komposisi Menu '.date('Ymd-Hi').'.xls';
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;
		
		if(file_exists($filepath))
			unlink($filepath);
		
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}
} ?>