<?php 
class journal extends CI_Controller{
	function lastMonthJournal(){
		$sql = "select a.journalid,tanggal,keterangan,dibuat,notrans,glno,accountname,iscredit,jumlah,(
					select count(*)+1
					from journaldetail 
					where journalid = a.journalid
				) span
				from journal a,journaldetail b
				where tanggal >= (select date_sub(last_day(now())-interval 1 month, interval dayofmonth(last_day(now())-interval 1 month)-1 day))
				and a.journalid = b.journalid
				order by 2,3,1,8";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function glAccountList(){
		$sql = "select *
				from glaccount
				where head <> 0
				order by glno";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function generateJournal(){
		$data = json_decode($this->input->post('json'));

		$sql = "select a.journalid,tanggal,keterangan,dibuat,notrans,glno,accountname,iscredit,jumlah,(
					select count(*)+1
					from journaldetail 
					where journalid = a.journalid
				) span
				from journal a,journaldetail b
				where tanggal between '".$data->start."' and '".$data->end."'
				and a.journalid = b.journalid
				order by 2,3,1,8";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function checkUnbalance(){
		$data = json_decode($this->input->post('json'));

		$sql = "select a.journalid,tanggal,keterangan,dibuat,notrans,glno,accountname,iscredit,jumlah,(
					select count(*)+1
					from journaldetail 
					where journalid = a.journalid
				) span
				from journal a,journaldetail b
				where tanggal between '".$data->start."' and '".$data->end."'
				and a.journalid = b.journalid
				and a.journalid in (
					select journalid from (
						select journalid,(select ifnull(sum(jumlah),0)
							from journaldetail
							where journalid = c.journalid
							and iscredit = 0) debit,(select ifnull(sum(jumlah),0)
							from journaldetail
							where journalid = c.journalid
							and iscredit = 1) credit	
						from journal c
						) d
					where abs(debit - credit) > 10
				)
				order by 2,3,1,8";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function getJournalHeader($id){
		$sql = "select journalid,tanggal,keterangan,jenis,notrans,(select full_name
					from user_apps
					where id = a.dibuat) dibuat
				from journal a
				where journalid = ".$id;

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function getJournalDetail($id){
		$sql = "select *,case when iscredit = 0 then
					jumlah 
				else
				    0
				end debit,case when iscredit = 1 then
					jumlah 
				else
				    0
				end credit
				from journaldetail
				where journalid = ".$id."
				order by iscredit";

		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function editJournal(){
		$data = json_decode($this->input->post('json'));
		$data2 = json_decode($this->input->post('json2'));
		$author_id = $this->session->userdata('author_id');

		$this->db->trans_begin();

		$update = "update journal
				   set tanggal = '".$data2->date."'
				   where journalid = ".$data[0]->journalid;

		$this->db->query($update);

		$delete = "delete from journaldetail
				   where journalid = ".$data[0]->journalid;

		$this->db->query($delete);

		for ($i = 0; $i < count($data); $i++) {
			$insert = "insert into journaldetail values (".$data[$i]->journalid.",'".$data[$i]->glno."','".$data[$i]->accountname."',".$data[$i]->iscredit.",".$data[$i]->jumlah.")";
			$this->db->query($insert);
		}

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();

		    $log = "insert into user_log values('',".$author_id.",".$data[0]->journalid.",'Update Journal',now())";
			$this->db->query($log);

		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}	
	}

	function deleteJournal(){
		$data = json_decode($this->input->post('json'));
		$author_id = $this->session->userdata('author_id');

		$this->db->trans_begin();

		$insert = "insert into journaldetaildeleted 
				   select * from journaldetail
				   where journalid = ".$data->id;

		$insert2 = "insert into journaldeleted
				   select * from journal
				   where journalid = ".$data->id;

		$this->db->query($insert);
		$this->db->query($insert2);

		$delete = "delete from journaldetail
				   where journalid = ".$data->id;

		$delete2 = "delete from journal
				   where journalid = ".$data->id; 
				   
		$this->db->query($delete);
		$this->db->query($delete2); 

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();

		    $log = "insert into user_log values('',".$author_id.",".$data->id.",'Delete Journal',now())";
			$this->db->query($log);

		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}	
	}

	function insertJournal(){
		$data = json_decode($this->input->post('json'));
		$data2 = json_decode($this->input->post('json2'));
		$author_id = $this->session->userdata('author_id');

		$this->db->trans_begin();

		$select = "select min(journalid)-1 id from journal";
		$nextId = $this->db->query($select)->row();

		$insert = "insert into journal values(".$nextId->id.",'".$data2->date."','".$data2->keterangan."',".$author_id.",0,-6,'".$data2->noTrans."')";

		$this->db->query($insert);

		for ($i = 0; $i < count($data); $i++) {
			$insert = "insert into journaldetail values (".$nextId->id.",'".$data[$i]->glno."','".$data[$i]->accountname."',".$data[$i]->iscredit.",".$data[$i]->jumlah.")";
			$this->db->query($insert);
		}

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();

		    $log = "insert into user_log values('',".$author_id.",".$nextId->id.",'Insert Journal',now())";
			$this->db->query($log);

		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}	
	}
}
?>