<?php /**
* 
*/
class Opnames extends CI_Controller
{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Products))
			{
				$data = $data->Products;
				$result = $this->db->insert('master_products',$data);
				$result = $this->findby_pk($this->db->insert_id());
				echo '{"success":{"msg":"Data produk BERHASIL disimpan !"}, "produk":'.json_encode($result).'}';
			} else {
				echo json_encode(array('categories'=>$this->find_all_categories(), 'groups'=>$this->find_all_groups()));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	/* ==============================================================================================================*/
	/*                                           Tambahan Pian
	/* ==============================================================================================================*/

	function transaction_update(){
		try {
			$json = $this->input->post('json');
			$array_php = json_decode($json);
			$this->db->trans_begin();
			foreach ($array_php as $key) {
				$obj_detail_opnames = array('physical_stock' => $key->physical_stock,'deviation'=>$key->deviation);
				$edit_detail($obj_detail_opnames,$key->id);
			}

			if ($this->db->trans_status() === FALSE){
			    $this->db->trans_rollback();
			    echo "gagal";
			}else{
			    $this->db->trans_commit();
			    echo 'ok';
			}

		} catch (Exception $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function edit_detail($obj,$id){
		try {
			$this->db->where('outlet_stock_opname_details',$id);
			$this->db->update('outlet_stock_opname_details',$obj);
		} catch (PDOException $e) {
			
		}
	}


	/* ==============================================================================================================*/
	/*                                        End Tambahan Pian
	/* ==============================================================================================================*/

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Products))
			{
				$data = $data->Products;
				$this->db->where('product_id', $id);
				$this->db->update('master_products',$data);
				$result = $this->findby_pk($id);
				echo '{"success":{"msg":"Data produk BERHASIL disimpan !"}, "produk":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode(array('opname'=>$result, 'details'=>$this->findDetails($id)));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('product_id', $id);
			$this->db->update('master_products');
			
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			echo json_encode(array(
					'opname' => $this->findby_pk($id),
					'details' => $this->findDetails($id),
				));
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL mengambil data stock opname !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function find_all()
	{
		$sql = "select * from outlet_stock_opnames WHERE outlet_id = 1";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "select * from outlet_stock_opnames WHERE outlet_id = 1 AND id = ".$id_;
		return $this->db->query($sql)->result();
	}
	
	function findDetails($id)
	{
		$id_ = addslashes($id);
		$sql = "SELECT A.*, B.product_code, B.product_name 
				FROM outlet_stock_opname_details A INNER JOIN `master_products` B ON A.product_id = B.product_id 
				WHERE opname_id IN (SELECT id FROM outlet_stock_opnames WHERE outlet_id = 1 AND id = ".$id_.")";
		return $this->db->query($sql)->result();
	}
} ?>