<?php /**
* 
*/
class Suppliers extends CI_Controller
{
	function index()
	{
		$outlet_id = $this->session->userdata('outlet_id')*1;
		if(is_int($outlet_id) && $outlet_id > 0)
			$result = $this->find_all_byoutlet($outlet_id);
		else 
			$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Suppliers))
			{
				$data = $data->Suppliers;
				$data->outlet_id = $this->session->userdata('outlet_id');
				$result = $this->db->insert('master_supplier',$data);
				$result = $this->findby_pk($this->db->insert_id());
				$this->histories('create');
				echo '{"success":{"msg":"Data supplier BERHASIL disimpan !"}, "supplier":'.json_encode($result).'}';
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data supplier !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Suppliers))
			{
				$data = $data->Suppliers;
				$this->db->where('id', $id);
				$result = $this->db->update('master_supplier',$data);
				$result = $this->findby_pk($id);
				$this->histories('update');
				echo '{"success":{"msg":"Data supplier BERHASIL disimpan !"}, "supplier":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode($result);
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data supplier !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('id', $id);
			$this->db->delete('master_supplier');
			$this->histories('delete');
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data supplier !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			$id_ = addslashes($id);
			$sql = "SELECT A.*, B.outlets_name FROM master_supplier A INNER JOIN master_outlets B ON A.outlet_id = B.outlets_id WHERE A.id= ".$id_;
			$result = $this->db->query($sql)->result();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL mengambil data supplier !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function find_all()
	{
		$sql = "SELECT A.*, B.outlets_name FROM master_supplier A INNER JOIN master_outlets B ON A.outlet_id = B.outlets_id";
		return $this->db->query($sql)->result();
	}
	
	function find_all_byoutlet($oid)
	{
		$sql = "SELECT * FROM master_supplier WHERE outlet_id = ".$oid;
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "SELECT * FROM master_supplier WHERE id= ".$id_;
		return $this->db->query($sql)->result();
	}

	function histories($treatment){
		$log_history = array('treatment' =>$treatment ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'Suppliers');
				$this->db->insert('log_history',$log_history);
	}

} ?>