// DRIVERS
app.controller('DriversController',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/drivers').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
	
	$scope.delete_driver = function(did) {
		var strconfirm = confirm("Apakah Anda yakin driver dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/drivers/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;				
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
});


app.controller("NewDriverController",function ($scope,$routeParams,$location,$http,$timeout,StatusList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Driver';	
			var url = url_base + 'master/drivers/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {			
				$scope.driver = data[0];
			});
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Driver';
			$scope.driver = {};
		}
		
		$scope.submitForm = function (driver)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/drivers/update/' + edit_id;
				var responseData = $http.post(url,{'Drivers':driver});
			} else {
				var url = url_base + 'master/drivers/create';
				var responseData = $http.post(url,{'Drivers':driver});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.driver[0].id;
					$location.path('driver_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('drivers');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
});

app.controller("ViewDriverController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Driver';
		var url = url_base + 'master/drivers/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.driver = data[0];
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});

// SUPPLIER
app.controller('SuppliersController',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/suppliers').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
	
	$scope.delete_supplier = function(did) {
		var strconfirm = confirm("Apakah Anda yakin supplier dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/suppliers/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;				
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
});


app.controller("NewSupplierController",function ($scope,$routeParams,$location,$http,$timeout,StatusList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Supplier';	
			var url = url_base + 'master/suppliers/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {			
				$scope.supplier = data[0];
			});
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Supplier';
			$scope.supplier = {};
		}
		
		$scope.submitForm = function (supplier)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/suppliers/update/' + edit_id;
				var responseData = $http.post(url,{'Suppliers':supplier});
			} else {
				var url = url_base + 'master/suppliers/create';
				var responseData = $http.post(url,{'Suppliers':supplier});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.supplier[0].id;
					$location.path('supplier_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('suppliers');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
});

app.controller("ViewSupplierController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Supplier';
		var url = url_base + 'master/suppliers/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.supplier = data[0];
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});