var app = angular.module('engagement', [
	'ngRoute','ngAnimate','angular-ladda','ui.bootstrap'
]);

app.run(['$route', '$rootScope', '$location', '$routeParams', function ($route, $rootScope, $location, $routeParams) {
    var original = $location.path;
    $location.path = function (path, reload) {
        if (reload === false) {
            var lastRoute = $route.current;
            var un = $rootScope.$on('$locationChangeSuccess', function () {
                $route.current = lastRoute;
                un();
            });
        }
        return original.apply($location, [path]);
    };
}]);

app.config(['$routeProvider', function ($routeProvider) {
  $routeProvider
	// Home
	.when("/", {templateUrl:url_base+"src/page/home.html", controller: "PageCtrl"})
	
	// Menus
	.when("/menu_categories", {templateUrl: url_base+"src/page/menus/categories.html", controller: "MenuCategoriesController"})
	.when("/menu_category_new", {templateUrl: url_base+"src/page/menus/category_new.html", controller: "NewMenuCategoryController"})
	.when("/menu_category_new/:eid", {templateUrl: url_base+"src/page/menus/category_new.html", controller: "NewMenuCategoryController"})
	
	.when("/menus", {templateUrl: url_base+"src/page/menus/menus.html", controller: "MenusController"})
	.when("/menu_new", {templateUrl: url_base+"src/page/menus/menu_new.html", controller: "NewMenuController"})
	.when("/menu_create", {templateUrl: url_base+"src/page/menus/create_menu.html", controller: "CreateMenuController"})
	.when("/menu_create/:eid", {templateUrl: url_base+"src/page/menus/create_menu.html", controller: "CreateMenuController"})
	.when("/menu_new/:eid", {templateUrl: url_base+"src/page/menus/menu_new.html", controller: "NewMenuController"})
	
	// Outlets
	.when("/outlets", {templateUrl: url_base+"src/page/outlets/outlets.html", controller: "OutletsController"})
	.when("/outlet_new", {templateUrl: url_base+"src/page/outlets/outlet_new.html", controller: "NewOutletController"})
	.when("/outlet_new/:eid", {templateUrl: url_base+"src/page/outlets/outlet_new.html", controller: "NewOutletController"})
	
	// Products
	.when("/product_categories", {templateUrl: url_base+"src/page/products/categories.html", controller: "ProductCategoriesController"})
	.when("/product_category_new", {templateUrl: url_base+"src/page/products/category_new.html", controller: "NewProductCategoryController"})
	.when("/product_category_new/:eid", {templateUrl: url_base+"src/page/products/category_new.html", controller: "NewProductCategoryController"})
	
	.when("/product_groups", {templateUrl: url_base+"src/page/products/groups.html", controller: "ProductGroupsController"})
	.when("/product_group_new", {templateUrl: url_base+"src/page/products/group_new.html", controller: "NewProductGroupController"})
	.when("/product_group_new/:eid", {templateUrl: url_base+"src/page/products/group_new.html", controller: "NewProductGroupController"})
	
	.when("/products", {templateUrl: url_base+"src/page/products/products.html", controller: "ProductsController"})
	.when("/product_new", {templateUrl: url_base+"src/page/products/product_new.html", controller: "NewProductController"})
	.when("/product_new/:eid", {templateUrl: url_base+"src/page/products/product_new.html", controller: "NewProductController"})
	
	// Transactions
	// IN
	.when("/receiving", {templateUrl:url_base+"src/page/transactions/receiving/list_receiving.html", controller: "receiving"})
	.when("/receiving/:id", {templateUrl:url_base+"src/page/transactions/receiving/detail_receiving.html", controller: "view_receiving"})
	.when("/view_receiving/:id", {templateUrl:url_base+"src/page/transactions/receiving/view_receiving.html", controller: "view_pr"})
	
	.when("/purchases", {templateUrl:url_base+"src/page/transactions/purchases/purchases.html", controller: "PurchasesController"})
	.when("/purchase_view/:eid", {templateUrl:url_base+"src/page/transactions/purchases/purchase_view.html", controller: "ViewPurchaseController"})
	
	// OUT
	.when("/waste", {templateUrl:url_base+"src/page/transactions/waste/waste.html", controller: "waste"})
	.when("/view_waste/:id", {templateUrl:url_base+"src/page/transactions/waste/view_receiving.html", controller: "view_pr"})
	.when("/waste/:id", {templateUrl:url_base+"src/page/transactions/waste/view_waste.html", controller: "waste_id"})

	//waste by menu 
	.when('/waste_menu',{templateUrl:url_base+"src/page/transactions/waste_menu/list.html",controller:"waste_menu"})
	.when('/waste_menu/:id',{templateUrl:url_base+"src/page/transactions/waste_menu/view.html",controller:"waste_menu_view"})

	.when("/purchase", {templateUrl:url_base+"src/page/transactions/purchase/purchase.html", controller: "purchase"})
	.when("/purchase/:id", {templateUrl:url_base+"src/page/transactions/purchase/view_purchase.html", controller: "purchase_id"})
	.when("/sales_order", {templateUrl:url_base+"src/page/transactions/stock/sales_order.html", controller: "PageCtrl"})
	
	// Reports
	.when("/report/received", {templateUrl:url_base+"src/page/reports/received.html", controller: "ReceivedController"})
	.when("/report/purchased", {templateUrl:url_base+"src/page/reports/purchased.html", controller: "PurchasedController"})
	.when("/report/sales", {templateUrl:url_base+"src/page/reports/sales.html", controller: "SalesController"})
	.when("/report/sale_menu", {templateUrl:url_base+"src/page/reports/sale_menu.html", controller: "SaleMenuController"})
	.when("/report/waste", {templateUrl:url_base+"src/page/reports/waste.html", controller: "WasteController"})
	
	// Stock
	.when("/stock", {templateUrl:url_base+"src/page/stock/stock.html", controller: "ViewStockController"})
	.when("/stock_opname", {templateUrl:url_base+"src/page/stock/stock_opname.html", controller: "StockOpnameController"})
	.when("/stock_opname_view/:eid", {templateUrl:url_base+"src/page/stock/stock_opname_view.html", controller: "ViewStockOpnameController"})
	.when("/stock_opname_new", {templateUrl:url_base+"src/page/stock/stock_opname_new.html", controller: "NewStockOpnameController"})
	.when("/stock_opname_new/:eid", {templateUrl:url_base+"src/page/stock/stock_opname_new.html", controller: "NewStockOpnameController"})
	
	//
	.when("/drivers", {templateUrl: url_base+"src/page/masters/drivers.html", controller: "DriversController"})
	.when("/driver_new", {templateUrl: url_base+"src/page/masters/driver_new.html", controller: "NewDriverController"})
	.when("/driver_new/:eid", {templateUrl: url_base+"src/page/masters/driver_new.html", controller: "NewDriverController"})
	
	.when("/suppliers", {templateUrl: url_base+"src/page/masters/suppliers.html", controller: "SuppliersController"})
	.when("/supplier_view/:eid", {templateUrl: url_base+"src/page/masters/supplier_view.html", controller: "ViewSupplierController"})
	
	.otherwise("/404", {templateUrl: url_base+"src/page/404.html", controller: "PageCtrl"});
}]);

app.factory('StatusList', function(){
	var Statuses = {};
	Statuses.list = [{code:'1', name:'Aktif'}, {code:'0', name:'Tidak Aktif'}];
	return Statuses;
});

app.factory('UtilList', function($http)
{
	return {
		productCategories: function(callback) {
			var url = url_base + 'master/product_categories/';
			$http.get(url).success(callback);
		},
		
		productGroups: function(callback) {
			var url = url_base + 'master/product_groups/';
			$http.get(url).success(callback);
		},
		
		menuCategories: function(callback) {
			var url = url_base + 'master/menu_categories/';
		    $http.get(url).success(callback);
		},
		
		outletList: function(callback) {
			var url = url_base + 'master/outlets/';
			$http.get(url).success(callback);
		},
	}
});

app.controller('PageCtrl', function($scope) {
	$scope.pageClass = 'page-home';
});

app.directive('focusOn', function() { 
   return function(scope, elem, attr) {
	  scope.$on('focusOn', function(e, name) {
		if(name === attr.focusOn) {
		  elem[0].focus();
		}
	  });
   };
});

app.directive('focus', function() {
	return function(scope, element) {
		element[0].focus();
	}      
});

app.factory('focus', function ($rootScope, $timeout) {
  return function(name) {
	$timeout(function (){
	  $rootScope.$broadcast('focusOn', name);
	});
  }
});

app.directive('onlyNumbers', function()
{
	return function(scope, element, attrs) {
	var keyCode = [8,9,13,37,39,46,48,49,50,51,52,53,54,55,56,57,96,97,98,99,100,101,102,103,104,105,110,190];
	element.bind("keydown", function(event) {
		if($.inArray(event.which,keyCode) == -1) {
			scope.$apply(function(){
				scope.$eval(attrs.onlyNum);
				event.preventDefault();
			});
			event.preventDefault();
		}
	});
	};
});

app.filter('startFrom', function() {
	return function(input, start) {
		if(input) {
			start = +start; //parse to int
			return input.slice(start);
		}
		return [];
	}
});

app.directive('selectpicker', function () {
	return {
		restrict: 'C',
		link: function (scope, element) {
			$(element).selectpicker({
				style: 'btn-default',
				size: false
			});
		}
	};
});

app.directive('calendarsari', function()
{
	return {
		require: 'ngModel',
		link: function (scope, element, attr, ngModel) {
			element.on('changeDate', function(){
				scope.$apply(function () {
					ngModel.$setViewValue(element.val());
				});
			})
		}
	}
});

app.directive('calendar', function () {
	return {
		require: 'ngModel',
		link: function (scope, element, attr, ngModel) {
			$(element).datepicker({
				format: 'yyyy-mm-yy',
			}).on('changeDate', function(ev){
				scope.$apply(function () {
					ngModel.$setViewValue(ev.date);
				});
			});
		}
	};
});
/*app.directive('calendar', function () {
	return {
		require: 'ngModel',
		link: function (scope, el, attr, ngModel) {
			$(el).datepicker({
				dateFormat: 'yyyy-mm-dd',
				onRender: function (dateText) {
					scope.$apply(function () {
						ngModel.$setViewValue(dateText);
					});
				}
			});
		}
	};
})*/