<?php /**
* 
*/
class Products extends CI_Controller
{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}

	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Products))
			{
				$data = $data->Products;
				$result = $this->db->insert('master_products',$data);
				$result = $this->findby_pk($this->db->insert_id());
				$this->histories('create');

				echo '{"success":{"msg":"Data produk BERHASIL disimpan !"}, "produk":'.json_encode($result).'}';
			} else {
				echo json_encode(array('categories'=>$this->find_all_categories(), 'groups'=>$this->find_all_groups()));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Products))
			{
				$data = $data->Products;
				$this->db->where('product_id', $id);
				$result = $this->db->update('master_products',$data);
				$result = $this->findby_pk($id);
				$this->histories('update');

				echo '{"success":{"msg":"Data produk BERHASIL disimpan !"}, "produk":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode($result);
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('product_id', $id);
			$this->db->delete('master_products');
			$this->histories('delete');
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			$result = $this->findby_pk($id);
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL mengambil data produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function find_all()
	{
		$sql = "select * from master_products";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "select * from master_products where product_id= ".$id_;
		return $this->db->query($sql)->result();
	}
	
	function find_all_categories()
	{
		$sql = "select * from master_product_categories";
		return $this->db->query($sql)->result();
	}
	
	function find_all_groups()
	{
		$sql = "select * from master_product_groups";
		return $this->db->query($sql)->result();
	}

	function histories($treatment){
		$log_history = array('treatment' =>$treatment ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'Product');
				$this->db->insert('log_history',$log_history);
	}

} ?>