app.controller('ProductsController',function($scope, $http, $timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/products').success(function(data){
        //console.log(data);
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 50; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
    });
	 
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 50);
    };
	
	$scope.delete_product = function(did) {
		var strconfirm = confirm("Apakah Anda yakin produk dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/products/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;			
				//$(event.target).parent().parent().css('display','none');				
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
}); 

app.controller("NewProductController",function ($scope,$routeParams,$http,$timeout,StatusList,UtilList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;
	UtilList.productCategories(function(data) {
		$scope.categories = data;
	});
	UtilList.productGroups(function(data) {
		$scope.groups = data;
	});

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Product';	
			var url = url_base + 'master/products/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {
				$scope.products = data[0];
			});
			responseData.error(function(data, status, headers, config) {
				alert("Data tidak bisa di ambil !");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Product';
			$scope.products = {};
		}
		
		$scope.submitForm = function (products)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/products/update/' + edit_id;
				var responseData = $http.post(url,{'Products':products});
			} else {
				var url = url_base + 'master/products/create';
				var responseData = $http.post(url,{'Products':products});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.product[0].product_id;
					$location.path('product_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('products');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
});

app.controller("ViewProductController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Produk';
		var url = url_base + 'master/products/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.products = data[0];
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});


// CATEGORIES
app.controller('ProductCategoriesController',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/product_categories').success(function(data){
        //console.log(data);
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
	
	$scope.delete_category = function(did) {
		var strconfirm = confirm("Apakah Anda yakin kategori dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/product_categories/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;			
				//$(event.target).parent().parent().css('display','none');				
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
});


app.controller("NewProductCategoryController",function ($scope,$routeParams,$http,$timeout,StatusList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Kategori Produk';	
			var url = url_base + 'master/product_categories/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {			
				$scope.category = data[0];
			});
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Kategori Produk';
			$scope.category = {};
		}
		
		$scope.submitForm = function (category)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/product_categories/update/' + edit_id;
				var responseData = $http.post(url,{'ProductCategories':category});
			} else {
				var url = url_base + 'master/product_categories/create';
				var responseData = $http.post(url,{'ProductCategories':category});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.category[0].category_id;
					$location.path('product_category_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('product_categories');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
});

app.controller("ViewProductCategoryController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Category Produk';
		var url = url_base + 'master/product_categories/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.category = data[0];
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});


// GROUPS
app.controller('ProductGroupsController',function($scope,$http,$timeout){
    $scope.pageClass = 'page-home';
    $http.get(url_base+'master/product_groups').success(function(data){
        //console.log(data);
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 25; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };
	
	$scope.delete_group = function(did) {
		var strconfirm = confirm("Apakah Anda yakin kategori dengan id '"+did+"' akan dihapus ?");
		if (strconfirm == true)
		{
			var url = url_base + 'master/product_groups/delete/' + did;
			var responseData = $http.delete(url);
			
			responseData.success(function(data, status, headers, config) {			
				$scope.list = data;
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		}
	};
});


app.controller("NewProductGroupController",function ($scope,$routeParams,$http,$timeout,StatusList)
{ 
	var edit_id = +($routeParams.eid);
	$scope.save_success = '';
	$scope.save_error = '';
	$scope.statuses = StatusList.list;

	if((angular.isNumber(edit_id) && !isNaN(edit_id)) || (angular.isUndefined($routeParams.eid)))
	{
		if(angular.isNumber(edit_id) && !isNaN(edit_id))
		{
			$scope.title = 'Ubah Group Produk';	
			var url = url_base + 'master/product_groups/update/' + edit_id;

			var responseData = $http.get(url);
			responseData.success(function(data, status, headers, config) {			
				$scope.group = data[0];
			});
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		} else if(angular.isUndefined($routeParams.eid)) {
			$scope.title = 'Tambah Group Produk';
			$scope.group = {};
		}
		
		$scope.submitForm = function (group)
		{
			var edit_id = +($routeParams.eid);
			if(angular.isNumber(edit_id) && !isNaN(edit_id))
			{
				var url = url_base + 'master/product_groups/update/' + edit_id;
				var responseData = $http.post(url,{'ProductGroups':group});
			} else {
				var url = url_base + 'master/product_groups/create';
				var responseData = $http.post(url,{'ProductGroups':group});
			}
			
			responseData.success(function(data, status, headers, config)
			{
				$scope.save_success = '';
				if(data.success) {
					$scope.save_success = data.success.msg;
				}
				if(data.success) {
					$scope.save_success = data.success.msg;
					if(!(angular.isNumber(edit_id) && !isNaN(edit_id)))
						$routeParams.eid = data.group[0].group_id;
					$location.path('product_group_new/' + $routeParams.eid, false);
				}
				$scope.save_error = '';
				if(data.error) {
					$scope.save_error = data.error.msg;
				}
				if(data.status) {		
					$location.path('product_groups');			
				}
			});
			
			responseData.error(function(data, status, headers, config) {
				//alert("AJAX failed!");
			});
		};
	} else {
		$scope.msg = 'Wrong url input';
	}
});

app.controller("ViewProductGroupController",function ($scope,$routeParams,$http,$timeout)
{ 
	var view_id = +($routeParams.eid);

	if(angular.isNumber(view_id) && !isNaN(view_id))
	{
		$scope.title = 'View Group Produk';
		var url = url_base + 'master/product_groups/view/' + view_id;

		var responseData = $http.get(url);
		responseData.success(function(data, status, headers, config) {
			$scope.group = data[0];
		});
		responseData.error(function(data, status, headers, config) {
			alert("Data tidak bisa di ambil !");
		});
	} else {
		$scope.msg = 'Wrong url input';
	}
});