app.controller('EditPurchaseController',['$scope','$timeout','$location','$routeParams','$http',
    function($scope,$timeout,$location,$routeParams,$http){

    $scope.identity_purchase;
    $scope.data_purchase = [];
    $scope.current_open;

    $http.get(url_base+'master_products/find_all').success(function(data){
        $scope.list = data; 
        $scope.currentPage = 1; //current page
        $scope.entryLimit = 10; //max no of items to display in a page
        $scope.filteredItems = $scope.list.length; //Initially for no filter  
        $scope.totalItems = $scope.list.length;
     });
    
    //get detail purchases
    $http.get(url_base+'purchase/get_detail_purchases/'+$routeParams.eid).success(function(data){
        $scope.identity_purchase = data;
        $scope.is_supplier = {currentSelect: data.supplier_id};
    });

    //get detail purchases item
    $http.get(url_base+'purchase/get_detail_purchases/'+$routeParams.eid).success(function(data){
        $scope.identity_purchase = data;
        $scope.is_supplier = {currentSelect: data.supplier_id};
    });

    //create model supplier
    $http.get(url_base+'master/suppliers/outletsuppliers').success(function(data){
        $scope.list_supplier = [];
        $scope.list_supplier.push({
                supplier_id:"0",
                supplier_name: " -- pilih supplier --"
        });

        for (var i = 0; i < data.length; i++) {
            var obj = data[i];
            $scope.list_supplier.push({
                supplier_id:obj.id,
                supplier_name:obj.supplier_name
            });
        };
     });

    $http.get(url_base+'purchase/get_item_purchases/'+$routeParams.eid).success(function(data){
        console.log(data);
        $scope.data_purchase = data;
    });

     $scope.setPage = function(pageNo) {
        $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 10);
    };

    $scope.modal_product = function(){
        $('#modal_list_prodict').modal();
    }

    $scope.modal_product_hide = function(){
        $('#modal_list_prodict').modal('hide');   
    }

    $scope.add_product = function(data){
        //console.log(data.product_code);
        $('#modal_confirmation').modal({show:true,backdrop:false,});
        $('.unit_s').html(data.product_name+' Dalam Satuan '+data.unit_large);
        $('#quantity_item').focus();
        $scope.current_open = data;
    }

    $scope.modal_confirmation_add = function(){
		if ($('#quantity_item').val() == '' || $('#quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('#hb_quantity_item').html('Data JUMLAH tidak boleh kosong atau 0')
        } /*if ($('#price_item').val() == '' || $('#price_item').val() == '0') {
            $('#form_harga').addClass('has-error');
            $('#hb_price_item').html('Data HARGA tidak boleh kosong atau 0')
        } */else{
            $scope.insert_temporary();
            $('#quantity_item').val("");
			$('#price_item').val("");
			$('#comments_item').val("");
            $('#modal_confirmation').modal('hide');
            $('#form_qty').removeClass('has-error');
			$('#form_harga').removeClass('has-error');
            $('#hb_quantity_item').html('');
			$('#hb_price_item').html('');
        };
    }

	$scope.edit_data = function(data){
        $scope.current_open = data;
        $('#edit_quantity_item').val(data.qty);
		$('#edit_price_item').val(data.pricebuy);
		$('#edit_comments_item').val(data.comments);
        $('#modal_confirmation_edit').modal({show:true,backdrop:false,});
    }
	
	$scope.modal_confirmation_edit = function(){
		if ($('#edit_quantity_item').val() == '' || $('#edit_quantity_item').val() == '0') {
            $('#form_qty').addClass('has-error');
            $('#hb_quantity_item_item').html('Data JUMLAH tidak boleh kosong atau 0')
        } /*if ($('#price_item_item').val() == '' || $('#price_item_item').val() == '0') {
            $('#form_harga').addClass('has-error');
            $('#hb_price_item_item').html('Data HARGA tidak boleh kosong atau 0')
        } */else{
            $scope.current_open.qty = $('#edit_quantity_item').val();
            $scope.current_open.pricebuy = $('#edit_price_item').val();
			$scope.current_open.comments = $('#edit_comments_item').val();
            $('#edit_quantity_item').val("");
			$('#edit_price_item').val("");
			$('#edit_price_item').val("");
            $('#modal_confirmation_edit').modal('hide');
            $('#form_qty_edit').removeClass('has-error');
			$('#form_harga_edit').removeClass('has-error');
            $('#hb_quantity_item_edit').html('');
			$('#hb_price_item_edit').html('');
        };
    }
	
    $scope.insert_temporary = function(){
        //console.log($scope.cek_avaliable());
        if ($scope.cek_avaliable() == true) {
            $scope.replaces_data();
        } else{
            $scope.add_data();
        };
    }

    $scope.replaces_data = function(){
        var data_temp = [];
        for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
            var temp = $scope.data_purchase[i];
            if (temp.product_code == $scope.current_open.product_code) {
                //console.log(parseFloat($('#fixed_qty_'+temp.product_code).val())+" + "+parseFloat($('#quantity_item').val()));
                $scope.current_open.qty = parseFloat($('#fixed_qty_'+temp.product_code).val())+ parseFloat($('#quantity_item').val());
				$scope.current_open.pricebuy = parseFloat($('#price_item').val());
				$scope.current_open.comments = $('#comments_item').val();
                data_temp.push($scope.current_open);
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_purchase = data_temp;
    }

    $scope.add_data = function(){
        $scope.current_open.qty = $('#quantity_item').val();
		$scope.current_open.pricebuy = $('#price_item').val();
		$scope.current_open.comments = $('#comments_item').val();
        $scope.data_purchase.push($scope.current_open);
    }

    $scope.cek_avaliable = function(){
        ////console.log($scope.current_open);
        var check_avaliable  = false;
        for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
            var temp = $scope.data_purchase[i];
            if (temp.product_code == $scope.current_open.product_code) {
                cek_avaliable = true;
                return true;
            };
        };

        return check_avaliable;
    }

    $scope.temp_delete;

    $scope.remove_data = function(data){
        $scope.temp_delete = data;
        $('#name_item').val($scope.temp_delete.product_name);
        $('#modal_confirmation_delete').modal({
            backdrop:false,
            show:true
        });
    }

    $scope.modal_confirmation_yes = function(){
        var data_temp = [];
        for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
            var temp = $scope.data_purchase[i];
            if (temp.product_code == $scope.temp_delete.product_code) {
            }else{
                data_temp.push(temp);
            };
        };
        $scope.data_purchase = data_temp;
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.modal_confirmation_no = function(){
        $('#modal_confirmation_delete').modal('hide');
    }

    $scope.convert_string = function(){
         for (var i = $scope.data_purchase.length - 1; i >= 0; i--) {
             $scope.data_purchase[i].qty = $('#fixed_qty_'+$scope.data_purchase[i].product_code).val();
         };
    }

    $scope.save_purchase = function(){
        if ($('#supplier_id').val()=='0') {
            $.growl.warning({message:"anda belum memilih suppliers"});
            return false;
        };

        if ($scope.data_purchase.length >0) {
            $scope.convert_string();
            var json = JSON.stringify($scope.data_purchase);
            //console.log(json);
            $scope.loading = true;
            $.ajax({
                url:url_base+'purchase/update_purchase',
                type:'post',
                data:'json='+json+'&id_supplier='+$('#supplier_id').val()+'&id_purchase='+$routeParams.eid,
                success:function(msg){
                    //console.log(msg);
                    $timeout(function(){
                        $scope.loading = false; // stop loading
                        if (msg!= 'gagal') {
                            data_purchase = [];
                            $.growl.notice({ message: "data telah kirim" });
                            $location.path('/purchase_edit/'+$routeParams.eid);  
                        } else{
                            $.growl.error({ message: "something wrong" });
                        };
                    },1000);
                }
            });
        } else{
            
            $.growl.warning({message:"tidak ada data yang dapat dikirim "});
        };

    }



}]); 
