deployQZ();

function deployQZ() {
	var attributes = {id: "qz", code:'qz.PrintApplet.class', 
		//archive:'D:/htdocs/inventory/qz-print.jar', width:1, height:1};
		archive:'/home/mujigaeapp/incoming/inventory/qz-print.jar', width:1, height:1};
	var parameters = {jnlp_href: getPath()+'qz-print_jnlp.jnlp',
		cache_option:'plugin', disable_logging:'false', 
		initial_focus:'false'};
	if (deployJava.versionCheck("1.7+") == true) {}
	else if (deployJava.versionCheck("1.6+") == true) {
		delete parameters['jnlp_href'];
	}
	deployJava.runApplet(attributes, parameters, '1.5');
}

function qzReady() {
	// Setup our global qz object
	window["qz"] = document.getElementById('qz');
	if (qz) {
		try {
			document.getElementById("printer_status").style.background = "green";
			document.getElementById("printer_status").innerHTML = 'Printer Ready';
		} catch(err) { // LiveConnect error, display a detailed meesage
			document.getElementById("printer_status").style.background = "red";
			document.getElementById("printer_status").innerHTML = 'ERROR: Applet tidak bisa di buka. Coba refresh ulang. tekan CTRL+F5';
	  }
  }
}

function notReady() {
	// If applet is not loaded, display an error
	if (!isLoaded()) {
		return true;
	}
	// If a printer hasn't been selected, display a message.
	else if (!qz.getPrinter()) {
		alert('Please select a printer first by using the "Detect Printer" button.');
		return true;
	}
	return false;
}

function isLoaded() {
	if (!qz) {
		alert('Error:\n\n\tPrint plugin is NOT loaded!');
		return false;
	} else {
		try {
			if (!qz.isActive()) {
				alert('Error:\n\n\tPrint plugin is loaded but NOT active!');
				return false;
			}
		} catch (err) {
			alert('Error:\n\n\tPrint plugin is NOT loaded properly!'+err.msg);
			return false;
		}
	}
	return true;
}

function findPrinter(name) {
	if (isLoaded()) {
		// Searches for locally installed printer with specified name
		qz.findPrinter(name);
		
		// Automatically gets called when "qz.findPrinter()" is finished.
		window['qzDoneFinding'] = function() {
			var printer = qz.getPrinter();
			
			// Alert the printer name to user
			//alert(printer !== null ? 'Printer found: "' + printer + 
			//	'" after searching for "' + name + '"' : 'Printer "' + 
			//	name + '" not found.');
			
			
			// Remove reference to this function
			window['qzDoneFinding'] = null;
		};
	}
}

function renderCenter(pcontent, plen)
{
	var vString = '';
	var vloop = Math.floor((plen - pcontent.length) / 2);
	for(i=0; i<vloop; i++)
		vString = vString + ' ';
	return vString + pcontent;
}

function renderContent(pcontent, plen, ppos)
{
	pcontent = pcontent.substring(0, plen);
	var vString = '';
	var vloop = plen - pcontent.length;
	for(i=0; i<vloop; i++)
		vString = vString + ' ';
	if(ppos == 'left')
		return pcontent + vString
	else
		return vString + pcontent;
}

function printESCP() {
	if (notReady()) { return; }

	var maxlength = 40;
	$.ajax({
		url: getPath()+'closing/print_waste',
		type: 'GET',
		success: function(data) {
			qz.append("\x1B\x40"); // 1
			qz.append(renderCenter(data['outlet'], maxlength)+"\n");
			//qz.append("        Cihampelas Walk Bandung\n");
			qz.append(" \n");
			qz.append("\x1B\x21\x01"); // 3
			qz.append("----------------------------------------\n");
			qz.append("Tanggal: "+data['closing_date']+"\n");
			qz.append(" \n");

			if(data.waste_menus.length > 0)
			{
				qz.append("\x1B\x21\x10");
				qz.append("WASTE MENU (AP)\n");
				qz.append("\x1B\x21\x01");
				qz.append("----------------------------------------\n");

				data.waste_menus.forEach(function(obj) {
					qz.append(renderContent(obj.menu_name, 34, 'left')+" "+renderContent(obj.qty, 5, 'right')+"\n");
				});

				qz.append("----------------------------------------"+"\n");
				qz.append(" \r\n");
			}

			if(data.waste_products.length > 0)
			{
				qz.append("\x1B\x21\x10");
				qz.append("WASTE PRODUCT (BP)\n");
				qz.append("\x1B\x21\x01");
				qz.append("----------------------------------------"+"\n");

				data.waste_products.forEach(function(obj) {
					qz.append(renderContent(obj.product_name, 28, 'left')+" "+renderContent(obj.qty, 5, 'right')+" "+renderContent(obj.unit_small, 5, 'left')+"\n");
				});

				qz.append("----------------------------------------"+"\n");
				qz.append(" \r\n");
			}
			
			qz.append(" \r\n");
			qz.append("     DRIVER               RM/SPV/CPT    "+"\n");
			qz.append(" \r\n");
			qz.append(" \r\n");
			qz.append("(              )       (               )"+"\n");
			qz.append(" \r\n");

			qz.append("\x1D\x56\x41"); // 4
			qz.append("\x1B\x40"); // 5

			qz.print();
		},
		error: function(e) {
			alert('Gagal Print Waste. Hubungi Webmaster !');
		}
	});
}

function logFeatures() {
	if (isLoaded()) {
		var logging = qz.getLogPostScriptFeatures();
		qz.setLogPostScriptFeatures(!logging);
		alert('Logging of PostScript printer capabilities to console set to "' + !logging + '"');
	}
}

/***************************************************************************
* Gets the current url's path, such as http://site.com/example/dist/
***************************************************************************/
function getPath() {
	var path = window.location.href;
	return path.substring(0, path.lastIndexOf("/")) + "/";
}

function outletClose()
{
	printESCP();
		
	loading = true;
	var url = url_base + 'closing/startclose/';
	//var obj = JSON.stringify($scope.data);
	$.ajax({
		url:url,
		type:'post',
		//data:'json='+obj,
		success:function(msg){
			alert(msg);
		}
	});
}