<?php /**
* 
*/
class Auto_Report extends CI_Controller
{
	function index()
	{
		$year = date('Y');
		$month = date('m');
		
		$start = new DateTime($year.'-'.$month.'-1');
		$lastDate = $start->format('t')*1;
		$end = new DateTime($year.'-'.$month.'-'.$lastDate);

		$_newDate = clone $start;
		$fields = array();
		$_sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('d'), 'title'=>$_newDate->format('d'));
			$_sql .= ", SUM(CASE WHEN DATE_FORMAT(A.tglClosing,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN A.JmlPenjualan ELSE 0 END) AS `q".$_newDate->format('d')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$sql = "SELECT B.outlets_id, B.other_code AS `outlets_code`, B.outlets_name, SUM(A.JmlPenjualan) AS `total` ".$_sql." 
				FROM `outlet_sales_orders` A INNER JOIN `master_outlets` B ON A.KdOutlet = B.other_code
				WHERE A.SdhBayar = 'T' AND YEAR(A.tglClosing) = ".$year." AND MONTH(A.tglClosing) = ".$month." 
				GROUP BY B.outlets_id, B.other_code, B.outlets_name
				ORDER BY B.outlets_name";
		
		$result = $this->db->query($sql)->result();
		
		
		$row = 1;
		$startChar = 'C';
		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('sheet1');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Laporan Penjualan Mujigae');
		//change the font size
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		//make the font become bold
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);

		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Periode: Juni 2015');
			
		$row+=2;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, 'Kode');
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(8);
		$this->excel->getActiveSheet()->setCellValue('B'.$row, 'Nama Outlet');
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
		$i=$startChar; $j=''; $k='';
		foreach($fields as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, $field['title']);
			$this->excel->getActiveSheet()->getColumnDimension($k)->setWidth(15);
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
		$this->excel->getActiveSheet()->setCellValue($j.$i.$row, 'Total');
		$this->excel->getActiveSheet()->getColumnDimension($j.$i)->setWidth(15);
		
		$this->excel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
		$dimension_title = 'A'.$row.':'.$j.$i.$row;
		$objRow = $this->excel->getActiveSheet()->getStyle($dimension_title);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$row++;
		$start_row = $row;
		foreach($result as $data)
		{
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $data->outlets_code);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $data->outlets_name);
			$this->writeRow($row, $startChar, $fields, $data);
			$row++;
		}
		
		$end_row = $row-1;
		$i=$startChar; $j=''; $k='';
		foreach($fields as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, '=SUM('.$k.$start_row.':'.$k.$end_row.')');
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
		$this->excel->getActiveSheet()->setCellValue($j.$i.$row, '=SUM('.$startChar.$row.':'.$k.$row.')');
		$this->excel->getActiveSheet()->getStyle($j.$i.($start_row-1).':'.$j.$i.$end_row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');
		$this->excel->getActiveSheet()->getStyle('A'.$row.':'.$j.$i.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFfde9d9');
		
		$this->excel->getActiveSheet()
					->getStyle($startChar.$start_row.':'.$j.$i.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');
		
		
		$filepath = '/home/mujigaeapp/incoming/exports/';
		$filename = $filepath.'LaporanPenjualan_'.$year.'_'.$month.'.xls';
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5'); 
		$objWriter->save($filename);
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		
		$ci = get_instance();
		$ci->load->library('email');
		$config['protocol'] = "smtp";
		$config['smtp_host'] = "ssl://smtp.yandex.com";
		$config['smtp_port'] = "465";
		$config['smtp_user'] = "sari@mujigae.com"; 
		$config['smtp_pass'] = "Ramdhan105";
		$config['charset'] = "utf-8";
		$config['mailtype'] = "html";
		$config['newline'] = "\r\n";

		$ci->email->initialize($config);

		$ci->email->from('sari@mujigae.com', 'Sari');
		$list = array('firman@garudagames.com');
		//$list = array('sari@beegros.com');
		$ci->email->to($list);
		$ci->email->bcc(array('sarimoon98@gmail.com'));
		$ci->email->subject('Laporan Penjualan Outlet '.date('M').' '.$year);
		$ci->email->message('Laporan Penjualan Outlet '.date('M').' '.$year);
		$ci->email->attach($filename);
		$ci->email->send();
		
		exit;
	}
	
	function writeRow($row, $startChar, $field_array, $data)
	{
		$i=$startChar; $j=''; $k='';
		foreach($field_array as $field)
		{
			$k = $j.$i;
			$this->excel->getActiveSheet()->setCellValue($k.$row, $data->$field['code']);
			$last = $k;
			if($i == 'Z')
			{
				$i='A';
				$j.=$i;
			} else $i++;
		}
		$this->excel->getActiveSheet()->setCellValue($j.$i.$row, '=SUM(C'.$row.':'.$k.$row.')');
	}
} ?>