<?php /**
* 
*/
class Receiving extends CI_Controller
{
	
	function get_receiving(){
		$sql = "select id,code from wh_delivery_orders where outlet_id = ".$this->session->userdata('outlet_id')." and state = 'new' and status =  'sent' ";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}	

	function find_all(){
		$cd = $this->get_tanggal_closing();
		$sql = "select * from outlet_purchase_receives where outlet_id = ".$this->session->userdata('outlet_id')." and closing_date = '$cd'
			order by id desc";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function findby_pk($id){
		$sql = "select d.*,p.*,@a:=@a+1 as no from (SELECT @a:= 0) as a,outlet_purchase_receive_details d inner join master_products p on (d.product_id=p.product_id) where d.pr_id = ".$id;
		$data['detail_order'] = $this->db->query($sql)->result();	
		$sql = "select d.*,o.outlets_name from outlet_purchase_receives d inner join master_outlets o on (d.outlet_id = o.outlets_id) where d.id = ".$id;
		$data['header'] = $this->db->query($sql)->result();
		echo json_encode($data);
	}	

	function create_receiving(){
		$array = json_decode($this->input->post('json'));
		$header = $array[0];
		$detail = $array[1];

		$new_purchase  = array(
			'code' => $this->generate($header->outlet_id), 
			'outlet_id' => $header->outlet_id, 
			'closing_date'=>$this->get_tanggal_closing(),
			'do_id' =>$header->id , 
			'author_id' => 1, 
			'created_at' => date("Y-m-d H:i:s"), 
		);

		$this->db->trans_begin();		
		$this->db->insert('outlet_purchase_receives',$new_purchase);
		$id = $this->db->insert_id();
		$this->create_receiving_detail($detail,$id);
		$this->update_status_do($header->id);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo "gagal";
		}
		else
		{
			$log_history = array('treatment' =>'create' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
			'datatable'=>'receiving' );
			$this->db->insert('log_history',$log_history);

		    $this->db->trans_commit();
		    echo $id;
		}
	}

	function create_receiving_detail($detail,$id){
		foreach ($detail as $d) {
			$new_detail = array(
				'pr_id'=>$id,
				'do_det_id'=>$d->id,
				'product_id'=>$d->product_id,
				'unit_large'=>$d->unit_large,
				'unit_small'=>$d->unit_small,
				'conversion'=>$d->conversion,
				'qty'=>$d->qty
				);

			$this->db->insert('outlet_purchase_receive_details',$new_detail);
		}
	}

	function update_status_do($id){
		$update_obj = array('state' => 'received');
		$this->db->where('id',$id);
		$this->db->update('wh_delivery_orders',$update_obj);
	}

	function generate($_outlet_id){
		$year = date("Y");
        $month = date("m");
		
		$this->load->model('outlets');
		$code = "PR-".$this->outlets->getOutletCode($_outlet_id).'-';

		$select = "select count(id) as total from outlet_purchase_receives where MONTH(created_at) = $month and YEAR(created_at) = $year AND code like '".$code."%'";
		$data = $this->db->query($select)->row();
		
		return $code.substr($year, 2)."".$month."".$this->get_zero($data->total+1);
	}

	function generates(){
		$year = date("Y");
        $month = date("m");

		$select = "select count(id) as total from outlet_purchase_receives where MONTH(created_at) = $month and YEAR(created_at) = $year";
		$data = $this->db->query($select)->row();
		echo $select."<br>";
		echo "PR-".substr($year, 2)."".$month."".$this->get_zero($data->total+1);
	}

	function get_zero($id){
		$zero = "";
		for ($i=0; $i < 4-strlen($id.""); $i++) { 
			$zero.="0";
		}
		return $zero.$id;
	}





	function create_receiving_manualy(){
		$array = json_decode($this->input->post('json'));
		$driver_id = $this->input->post('id_driver');
		$detail = $array;
		$closing_date = $this->get_tanggal_closing();
		$new_purchase  = array(
			'code' => $this->generate($this->session->userdata('outlet_id')), 
			'outlet_id' => $this->session->userdata('outlet_id'), 
			'closing_date'=>$closing_date,
			'driver_id' => $driver_id,
			'author_id' => 1, 
			'created_at' => date("Y-m-d H:i:s"), 
		);

		$this->db->trans_begin();		
		$this->db->insert('outlet_purchase_receives',$new_purchase);
		$id = $this->db->insert_id();
		$this->create_receiving_detail_manualy($detail,$id);
		header("Content-Type: application/json", true);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    echo json_encode(array('msg'=>'gagal'));
		}
		else
		{
			$log_history = array('treatment' =>'create' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
			'datatable'=>'receiving','closing_date'=>$closing_date,'outlet_id'=>$this->session->userdata('outlet_id'));
			$this->db->insert('log_history',$log_history);

		    $this->db->trans_commit();
			echo json_encode(array('msg'=>'berhasil', 'id'=>$id));
		}
	}

	function create_receiving_detail_manualy($detail,$id){
		foreach ($detail as $d) {
			$new_detail = array(
				'pr_id'=>$id,
				'product_id'=>$d->product_id,
				'unit_large'=>$d->unit_large,
				'unit_small'=>$d->unit_small,
				'conversion'=>$d->conversion,
				'qty'=>$d->qty
				);
			$this->db->insert('outlet_purchase_receive_details',$new_detail);
		}
	}

	function get_receiving_edit($id){
		$sql  =  "select p.*,r.qty from outlet_purchase_receives o inner join outlet_purchase_receive_details r 
		on (r.pr_id = o.id) inner join master_products p on(r.product_id = p.product_id) where o.id = ".$id;
		$result = $this->db->query($sql);
		echo json_encode($result->result());
	}

	function update_receiving_manualy(){
		$array = json_decode($this->input->post('json'));
		$id_receives = $this->input->post('id');
		$detail = $array;

		$this->db->trans_begin();
		$this->db->where('pr_id',$id_receives);
		$this->db->delete('outlet_purchase_receive_details');
		$this->update_receiving_detail_manualy($detail,$id_receives);
		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
			echo json_encode(array('msg'=>'gagal'));
		}
		else
		{
			$log_history = array('treatment' =>'update' ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
			'datatable'=>'receiving','closing_date'=>$this->get_tanggal_closing(),'outlet_id'=>$this->session->userdata('outlet_id') );
			$this->db->insert('log_history',$log_history);
		    $this->db->trans_commit();
			echo json_encode(array('msg'=>'berhasil', 'id'=>$id_receives));
		}
	}

	function get_tanggal_closing()
	{
		$sql = "select value from outlet_config where code = 'closing_date' and outlet_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result->value;
	}

	function update_receiving_detail_manualy($detail,$id){
		foreach ($detail as $d) {
			$new_detail = array(
				'pr_id'=>$id,
				'product_id'=>$d->product_id,
				'unit_large'=>$d->unit_large,
				'unit_small'=>$d->unit_small,
				'conversion'=>$d->conversion,
				'qty'=>$d->qty
				);
			$this->db->insert('outlet_purchase_receive_details',$new_detail);
		}
	}
} ?>