<?php /**
* 
*/
class Dashboard extends CI_Controller
{
	
	function index(){
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->year) && isset($data->month))
		{
			$chooseYear = $data->year;
			$chooseMonth = (int)$data->month+1;
		} else {
			$chooseYear = date("Y");
			$chooseMonth = date("m")*1;
		}
		
		$firstDayInMonth = strtotime($chooseYear.'-'.$chooseMonth.'-01');
		$_lastDate = date("t", $firstDayInMonth)*1;
		$lastDayInMonth = strtotime($chooseYear.'-'.$chooseMonth.'-'.$_lastDate);
		$currentDay = strtotime(date('Y-m-d'));
		
		if($lastDayInMonth < $currentDay)
			$_currentDate = $_lastDate;
		else if($currentDay < $firstDayInMonth)
			$_currentDate = 0;
		else $_currentDate = date("t", $currentDay)*1;
		
		$fields = array('01', '02', '03', '04', '05', '06', '07', '08', '09', '10'
						, '11', '12', '13', '14', '15', '16', '17', '18', '19', '20'
						, '21', '22', '23', '24', '25', '26', '27', '28');
		for ($i = 29; $i <= $_lastDate; $i++)
			$fields[] = (string)$i;
		
		$sql = "SELECT A.outlet_id, B.outlets_code, B.outlets_name ";
		for ($i = 0; $i < $_currentDate; $i++)
			$sql .= ", MAX(CASE DAY(closing_date) WHEN ".($i+1)." THEN 1 ELSE 0 END) AS 'd".$fields[$i]."' ";
		
		for ($i = $_currentDate; $i < $_lastDate; $i++)
			$sql .= ", '_' AS 'd".$fields[$i]."' ";
		
		$sql .= "FROM `log_closing` A RIGHT JOIN `master_outlets` B ON A.outlet_id = B.outlets_id 
				WHERE YEAR(closing_date) = ".$chooseYear." AND MONTH(closing_date) = ".$chooseMonth."
				GROUP BY A.outlet_id, B.outlets_code, B.outlets_name 
				ORDER BY A.outlet_id";

		$result = $this->db->query($sql)->result();
		echo json_encode(array('fields'=>$fields, 'results'=>$result));
	}

	function get_board(){
		$o_id = $this->session->userdata('outlet_id');
		$t_cl = $this->get_tanggal_closing();

		$dashboard['receiving'] = $this->db->query("select count(id) as total from  outlet_purchase_receives where closing_date = '$t_cl' and outlet_id = $o_id ")->row()->total;
		$dashboard['purchase'] = $this->db->query("select count(id) as total from  outlet_purchases where closing_date = '$t_cl' and outlet_id = $o_id ")->row()->total;
		$dashboard['waste'] = $this->db->query("select count(id) as total from  outlet_product_waste where closing_date = '$t_cl' and outlet_id = $o_id ")->row()->total;
		$dashboard['waste_menu'] = $this->db->query("select count(id) as total from  outlet_menu_waste where closing_date = '$t_cl' and outlet_id = $o_id ")->row()->total;

		print json_encode($dashboard);
	}

	function get_history(){
		$sql = "select h.* , u.full_name from log_history h 
		inner join user_apps u on (u.id = h.author_id)
		where h.closing_date = '".$this->get_tanggal_closing()."' and 
		h.outlet_id = ".$this->session->userdata('outlet_id')." order by h.id desc limit 0,5";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function get_tanggal_closing()
	{
		$sql = "select value from outlet_config where code = 'closing_date' and outlet_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result->value;
	}


} ?>