app.controller('SupplierController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $("#a").hide();
  //$("#b").hide();
  //$("#c").hide();
  $scope.b = true;
  $scope.c = true;

  $http.get(url_base+"wh_supplier/supView").success(function (records) {
    $scope.wh_supplier = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_supplier.length;
    $scope.totalItems = $scope.wh_supplier.length;
  });

  $http.get(url_base+"wh_supplier/getLv").success(function (records) {
    if (records[0]['level'] == 5){
      //$("#c").show();
      $scope.c = false
    }
    else{
      $("#a").show();
      //$("#b").show(); 
      $scope.b = false;   
    }
  });

  $scope.saveDelete = function(id,name) {
    if (confirm("Hapus supplier "+name+"?")){
      $scope.dataDelete = {"id":id};

      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'wh_supplier/saveDelete',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diHapus" });

              $http.get(url_base+"wh_supplier/supView").success(function (records) {
                $scope.wh_supplier = records;
                $scope.currentPage = 1;
                $scope.entryLimit = 25;
                $scope.filteredItems = $scope.wh_supplier.length;
                $scope.totalItems = $scope.wh_supplier.length;
              });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            }
            else{
              $.growl.notice({ message: "Data TIDAK BISA dihapus" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
    return false;
  };

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('SupplierNewController', function($scope,$http, $timeout) {
  $scope.name = '';
  $scope.address1 = '';
  $scope.address2 = '';
  $scope.postcode = '';
  $scope.website = '';
  $scope.phone1 = '';
  $scope.phone2 = '';
  $scope.fax = '';
  $scope.email = '';
  $("#divList").hide();
  $("#masking").hide();
  $scope.sp = [];
  $scope.hide = true;

  $scope.showDivList = function() {
    $http.get(url_base+'wh_supplier/productView').success(function (records){
      $scope.products = records;
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.products.length;
      $scope.totalItems = $scope.products.length;

      window.scrollTo(0,0);
      $("#divMain").hide();
      $("#divList").css({top:-80,left:0,position:"absolute"});
      $("#divList").css("z-index","9998");
      $("#divList").show(function(){
        $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
      
        if ($(window).width() < 752){
          $("#divExtend").height(80);
        }
        else{
          $("#divExtend").height(0);
        }
      });
    });
  };

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };


  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.search = '';
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.sku = '';
    $scope.snp = '' ;       
    $scope.price = '';
  };

  function isExist(code){
    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].code == code) {
        return true;
      };
    };
    return false;
  };

  $scope.addProduct = function(id,code,name) {
    $scope.productName = name;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addRow = function(sku,snp,price) {
      if (isExist(code) == false) {
        $scope.sp.push({"id":id,"code":code,"name":name,"sku":sku,"snp":snp,"price":price,"supId":$scope.newId});
      }
      else {
        for (var i = $scope.sp.length - 1; i >= 0; i--) {
          if ($scope.sp[i].id == id) {
            $scope.sp[i].sku = sku;
            $scope.sp[i].snp = snp;
            $scope.sp[i].price = price;
          };
        };
      };

      $scope.sku = '';
      $scope.snp = '' ;       
      $scope.price = '';
      $("#masking").hide();
    };
  };

  $scope.deleteProduct = function(index) {
    $scope.sp.splice(index,1);
  };

  $scope.updateSku = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].id == id) {
        $scope.sp[i].sku = newVal;

        $("#"+pId).val(newVal);
      };
    };
  };

  $scope.updateSnp = function(id){
    var pId = "p2"+id;
    var newVal = $("#"+pId).val();

    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].id == id) {
        $scope.sp[i].snp = newVal;

        $("#"+pId).val(newVal);
      };
    };
  };

  $scope.updatePrice = function(id){
    var pId = "p3"+id;
    var newVal = $("#"+pId).val();

    for (var i = $scope.sp.length - 1; i >= 0; i--) {
      if ($scope.sp[i].id == id) {
        $scope.sp[i].price = newVal;

        $("#"+pId).val(newVal);
      };
    };
  };

  $scope.saveSupplierProduct = function(isgen,status) {
    if(!isgen){
      if (status == 'save') {
        $scope.loading = true; 
      }
      else {
        $scope.loading2 = true; 
      }
    };

    var json = JSON.stringify($scope.sp);

    $.ajax({
      type: 'post',
      url:url_base+'wh_supplier/saveSupplierProduct',
      data: "json="+json,
      success: function(msg){
        var obj = JSON.parse(msg);
        $timeout(function(){
          if(!isgen){
            $scope.loading = false;
            $scope.loading2 = false;
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diSimpan" });
            } else {
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            };
          }
        },1000);
      },
      error: function(XMLHttpRequest, textStatus, errorThrown) {
        $timeout(function(){
          if(!isgen){
            $scope.loading = false;
            $scope.loading2 = false;
          }
          $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
        },1000);
      } 
    });
  };

  $scope.saveNew = function(isgen,status) {
    //alert($("#supCode").val());
    if($("#supCode").val() == ''){
      $.growl.warning({ message: 'Kode tidak boleh kosong' });
    }
    else if($("#supCode").val().length != 3){
      $.growl.warning({ message: 'Kode Supplier harus 3 karakter' });
    }
    else{
      if(!isgen){
        $scope.loading = true; 
      };

      $scope.dataNew = {"name":$("#a").val(),"code":$("#supCode").val(),"address1":$("#b").val(),"address2":$("#c").val(),"postcode":$("#d").val(),"website":$("#e").val(),"phone1":$("#f").val(),"phone2":$("#g").val(),"fax":$("#h").val(),"email":$("#i").val(),"isActive":$("#isActive").val()};

      var json = JSON.stringify($scope.dataNew);

      $.ajax({
        type: 'post',
        url:url_base+'wh_supplier/saveNew',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
                $scope.newId = obj.supId;
                $scope.hide = false;
              } 
              else if(obj.status == 'duplikat'){
                $.growl.error({ message: "Kode Supplier sudah ada. Ganti kode !" });
              }
              else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };
});

app.controller('SupplierEditController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;
    $("#divList").hide();
    $("#masking").hide();
    $scope.sp = [];

    $http.get(url_base+'wh_supplier/supplierEditView/'+id).success(function (records){
      $scope.namesEdit = records[0]['sup_name'];
      $("#supCode").val(records[0]['sup_code']);
      $scope.address1Edit = records[0]['sup_address_1'];
      $scope.address2Edit = records[0]['sup_address_2'];
      $scope.postcodeEdit = records[0]['sup_postcode'];
      $scope.websiteEdit = records[0]['sup_website'];
      $scope.phone1Edit = records[0]['sup_phone'];
      $scope.phone2Edit = records[0]['sup_mobile'];
      $scope.faxEdit = records[0]['sup_fax'];
      $scope.emailEdit = records[0]['sup_email'];
      $("#isActive").val(records[0]['sup_status']);
    });

    $http.get(url_base+'wh_supplier/initSupplierProduct/'+id).success(function (records){
      $scope.sp = records;
    });

    $scope.showDivList = function() {
      $http.get(url_base+'wh_supplier/productView').success(function (records){
        $scope.products = records;
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList").css({top:-80,left:0,position:"absolute"});
        $("#divList").css("z-index","9998");
        $("#divList").show(function(){
          $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend").height(80);
          }
          else{
            $("#divExtend").height(0);
          }
        });
      });
    };

    $scope.showDivMain = function() {
      $("#divMain").show();
      $("#divList").hide();
      $scope.search = '';
    };

    $scope.hideDivCount = function() {
      $("#masking").hide();
      $scope.sku = '';
      $scope.snp = '' ;       
      $scope.price = '';
    };

    function isExist(code){
      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].code == code) {
          return true;
        };
      };
      return false;
    };

    $scope.addProduct = function(id,code,name) {
      $scope.productName = name;

      $("#masking").css({top:0,left:0,position:"absolute"});
      $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
      $("#masking").css("z-index","9999");
      $("#masking").show();

      var x = $(window).scrollTop();
      var y = $("#masking").width();
      var z = $("#divCount").width();
      $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

      $("#autofocus").focus();

      $scope.addRow = function(sku,snp,price) {
        if (isExist(code) == false) {
          $scope.sp.push({"id":id,"code":code,"name":name,"sku":sku,"snp":snp,"price":price,"supId":$routeParams.id});
        }
        else {
          for (var i = $scope.sp.length - 1; i >= 0; i--) {
            if ($scope.sp[i].id == id) {
              $scope.sp[i].sku = sku;
              $scope.sp[i].snp = snp;
              $scope.sp[i].price = price;
            };
          };
        };

        $scope.sku = '';
        $scope.snp = '' ;       
        $scope.price = '';
        $("#masking").hide();
      };
    };

    $scope.deleteProduct = function(index) {
      $scope.sp.splice(index,1);
    };

    $scope.updateSku = function(id){
      var pId = "p"+id;
      var newVal = $("#"+pId).val();

      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].id == id) {
          $scope.sp[i].sku = newVal;

          $("#"+pId).val(newVal);
        };
      };
    };

    $scope.updateSnp = function(id){
      var pId = "p2"+id;
      var newVal = $("#"+pId).val();

      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].id == id) {
          $scope.sp[i].snp = newVal;

          $("#"+pId).val(newVal);
        };
      };
    };

    $scope.updatePrice = function(id){
      var pId = "p3"+id;
      var newVal = $("#"+pId).val();

      for (var i = $scope.sp.length - 1; i >= 0; i--) {
        if ($scope.sp[i].id == id) {
          $scope.sp[i].price = newVal;

          $("#"+pId).val(newVal);
        };
      };
    };

    $scope.saveSupplierProduct = function(isgen,status) {
      if(!isgen){
        if (status == 'save') {
          $scope.loading = true; 
        }
        else {
          $scope.loading2 = true; 
        }
      };

      var json = JSON.stringify($scope.sp);

      $.ajax({
        type: 'post',
        url:url_base+'wh_supplier/saveSupplierProduct',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    };

    $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
    };

    $scope.filter = function() {
        $timeout(function() { 
            $scope.filteredItems = $scope.filtered.length;
        }, 25);
    };

    $scope.saveEdit = function(isgen,status) {
      if($("#isActive").val() == ''){
        $.growl.warning({ message: "Isi status Supplier" });
      }
      else if($("#supCode").val() == ''){
        $.growl.warning({ message: 'Kode tidak boleh kosong' });
      }
      else if($("#supCode").val().length != 3){
        $.growl.warning({ message: 'Kode Supplier harus 3 karakter' });
      }
      else{
        if(!isgen){
          $scope.loading = true; 
        };

        $scope.dataNew = {"code":$("#supCode").val(),"id":id,"name":$("#a").val(),"address1":$("#b").val(),"address2":$("#c").val(),"postcode":$("#d").val(),"website":$("#e").val(),"phone1":$("#f").val(),"phone2":$("#g").val(),"fax":$("#h").val(),"email":$("#i").val(),"isActive":$("#isActive").val()};
        
        var json = JSON.stringify($scope.dataNew);

        $.ajax({
          type: 'post',
          url:url_base+'wh_supplier/saveEdit',
          data: "json="+json,
          success: function(msg){
            var obj = JSON.parse(msg);
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
                if (obj.status == 'sukses') {
                  $.growl.notice({ message: "Data BERHASIL diSimpan" });
                }
                else if(obj.status == 'duplikat') {
                  $.growl.error({ message: "Kode Supplier sudah ada. Ganti Kode Supplier !" });
                }
                else {
                  $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
                };
              }
            },1000);
          },
          error: function(XMLHttpRequest, textStatus, errorThrown) {
            $timeout(function(){
              if(!isgen){
                $scope.loading = false;
              }
              $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
            },1000);
          } 
        });
      }
    };
  }
]);