app.controller('StController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $http.get(url_base+"wh_st/stoView").success(function (records) {
    $scope.wh_st = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.wh_st.length;
    $scope.totalItems = $scope.wh_st.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };

  $scope.deleteStockOpname = function(id,code) {
    if (confirm("Hapus Opname "+code+"?")){
      $scope.dataDelete = {"id":id};

      var json = JSON.stringify($scope.dataDelete);

      $.ajax({
        type: 'post',
        url:url_base+'wh_st/deleteStockOpname',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
            if (obj.status == 'sukses') {
              $.growl.notice({ message: "Data BERHASIL diHapus" });

              $http.get(url_base+"wh_st/stoView").success(function (records) {
                $scope.wh_st = records;
                $scope.currentPage = 1;
                $scope.entryLimit = 25;
                $scope.filteredItems = $scope.wh_st.length;
                $scope.totalItems = $scope.wh_st.length;
              });
            } 
            else if (obj.status == 'gagal'){
              $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
            }
            else{
              $.growl.notice({ message: "Data TIDAK BISA dihapus" });
            };
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
    return false;
  };
});

app.controller('StDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    $http.get(url_base+'wh_st/stViewDetailHeader/'+id).success(function (records){
      $scope.codeStSelected = records[0]['code'];
      $scope.dateStartSelected = records[0]['period_start'];
      $scope.dateEndSelected = records[0]['period_end'];
      $scope.atSelected = records[0]['created_at'];
      $scope.bySelected = records[0]['full_name'];
      $scope.stSelected = records[0]['storage_name']; 
    });

    $http.get(url_base+'wh_st/stViewDetail/'+id).success(function (records){
      $scope.stDetail = records;
    });
  }
]);

app.controller('StNewController', function($scope,$http, $timeout) {
  $scope.periodStart = '';
  $scope.periodEnd = '';
  $scope.status = false;
  $("#divContent").hide();
  $("#divNotif").hide();
  
  $http.get(url_base+"wh_st/stView").success(function (records){
    //$scope.stSelectedView = records[0]['storage_name']; 
    //$scope.stSelectedView2 = records[0]['id']; 
    $scope.stList = records;

    //$http.get(url_base+"wh_st/getPeriodStart?stId="+$scope.stSelectedView2).success(function (records){
      //$scope.periodStart = records[0]['period_start']; 
      //$scope.periodEnd = curDate();

      //if ($scope.periodStart > $scope.periodEnd){
        //$scope.periodEnd = $scope.periodStart;
      //}
    //});
  });

  function curDate(){
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1;
    var yyyy = today.getFullYear();

    if (dd < 10){
      dd = '0'+dd;
    };

    if (mm < 10){
      mm = '0'+mm;
    };  

    today = yyyy+'-'+mm+'-'+dd; 

    return today;
  }

  $("#datepicker").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepicker").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $scope.updateStorage = function() {
    var stId = $("#stSelected").val();

    $http.get(url_base+"wh_st/getPeriodStart?stId="+stId).success(function (records){
      $scope.periodStart = records[0]['period_start']; 
      //$scope.periodEnd = curDate();

      //if ($scope.periodStart > $scope.periodEnd){
        //$scope.periodStart = $scope.periodEnd;
      //}
    });
  };

  $scope.generateStockOpname = function() {
    var stId = $("#stSelected").val();

    if($("#datepicker").val() == '' || $("#hour").val() == '' || $("#minute").val() == ''){
      $.growl.warning({ message: 'Periode Akhir, Jam, Menit belum diisi' });
    }
    else if ($("#hour").val() > 23){
      $.growl.warning({ message: 'Jam tidak valid' });
    }
    else if ($("#minute").val() > 59){
      $.growl.warning({ message: 'Menit tidak valid' });
    }
    else{
      //alert ($("#datepicker").val().concat(' ',$("#hour").val(),':',$("#minute").val(),':00'));
      var dt = $("#datepicker").val().concat(' ',$("#hour").val(),':',$("#minute").val(),':00');
      //alert (dt);
      if ($("#stSelected").val() != ''){
        $http.get(url_base+"wh_st/generateStockOpname?periodStart="+$scope.periodStart+"&periodEnd="+dt+"&stId="+stId).success(function (){
          $http.get(url_base+"wh_st/viewNewStockOpname").success(function (records){
            $scope.stDetail = records;
            $("#divContent").show();
            $scope.status = true;
          });
        });
      }
      else{
        $.growl.warning({ message: 'Pilih Gudang terlebih dahulu' });
      }    
    }
  };

  $scope.updatePhyStock = function(id) {
    var pId = "p"+id;
    var p2Id = "p2"+id;
    var p3Id = "p3"+id;
    var newVal = $("#"+p2Id).val();
    var deviation = $("#"+pId).val() - $("#"+p2Id).val();

    for (var i = $scope.stDetail.length - 1; i >= 0; i--) {
      if ($scope.stDetail[i].product_id == id) {
        $scope.stDetail[i].physical_stock = newVal;
        $("#"+p2Id).val(newVal);
        $scope.stDetail[i].deviation = deviation;
         $("#"+p3Id).val(deviation);
      };
    };
  };

  $scope.saveStockOpname = function(isgen) {
    if ($scope.status == false){
      $.growl.warning({ message: 'Generate data terlebih dahulu' });
    }
    else {
      if(!isgen){       
        $scope.loading = true; 
      };

      var json = JSON.stringify($scope.stDetail);

      $.ajax({
        type: 'post',
        url:url_base+'wh_st/saveStockOpname',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                //$("#divMain").hide();
                //$("#divNotif").show();
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

});

app.controller('StEditDetailController',['$scope','$routeParams','$http','$timeout',
  function($scope,$routeParams,$http,$timeout){
    var id = $routeParams.id;

    $http.get(url_base+'wh_st/stViewDetailHeader/'+id).success(function (records){
      $scope.codeStSelected = records[0]['code'];
      $scope.dateStartSelected = records[0]['period_start'];
      $scope.dateEndSelected = records[0]['period_end'];
      $scope.atSelected = records[0]['created_at'];
      $scope.bySelected = records[0]['full_name'];
      $scope.stSelected = records[0]['storage_name']; 
    });

    $http.get(url_base+'wh_st/stViewDetail/'+id).success(function (records){
      $scope.stDetail = records;
    });

    $scope.updatePhyStock = function(id) {
      var pId = "p"+id;
      var p2Id = "p2"+id;
      var p3Id = "p3"+id;
      var newVal = $("#"+p2Id).val();
      var deviation = $("#"+pId).val() - $("#"+p2Id).val();

      for (var i = $scope.stDetail.length - 1; i >= 0; i--) {
        if ($scope.stDetail[i].product_id == id) {
          $scope.stDetail[i].physical_stock = newVal;
          $("#"+p2Id).val(newVal);
          $scope.stDetail[i].deviation = deviation;
           $("#"+p3Id).val(deviation);
        };
      };
    };

    $scope.editStockOpname = function(isgen) {
      if(!isgen){       
        $scope.loading = true; 
      };

      var json = JSON.stringify($scope.stDetail);
      var json2 = JSON.stringify({"id":$routeParams.id});

      $.ajax({
        type: 'post',
        url:url_base+'wh_st/editStockOpname',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    };

  }
]);