app.controller('PrController', function($scope,$http,$timeout) {
  $(window).off("keypress");
  $http.get(url_base+"pr/prView").success(function (records) {
    $scope.pr = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.pr.length;
    $scope.totalItems = $scope.pr.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('PrDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    /*function convertRp(input){
      var round = Math.floor(input);
      var money = round.toString();
      var pointer = money.length % 3;
      var dot = Math.floor(money.length / 3);
      var rp = money.substring(0,pointer);

      if (pointer != 0){
        rp = rp + String.fromCharCode(46);
      }

      for (var i = 0; i < dot; i++){
        rp = rp + money.substring(pointer,pointer + 3) + String.fromCharCode(46);
        pointer = pointer + 3;
      }

      rp = rp.substring(0,rp.length - 1);
      rp = 'Rp ' + rp;

      return rp;
    };*/

    $http.get(url_base+'pr/prViewDetailHeader/'+id).success(function (records){
      $scope.prDetailHeader = records;
      $scope.prSelected = $scope.prDetailHeader[0]['pr_code'];
      $scope.invoiceSelected = $scope.prDetailHeader[0]['invoice_no'];
      $scope.dateInvoiceSelected = $scope.prDetailHeader[0]['invoice_date'];
      $scope.poSelected = $scope.prDetailHeader[0]['po_code'];
      $scope.datePrSelected = $scope.prDetailHeader[0]['receive_date'];
      //$scope.discountSelected = $scope.prDetailHeader[0]['invoice_discount_value'];
      //$scope.taxSelected = $scope.prDetailHeader[0]['invoice_tax_rate'];
      $scope.notesSelected = $scope.prDetailHeader[0]['notes'];
      $scope.atSelected = $scope.prDetailHeader[0]['createdat'];  
      $scope.bySelected = $scope.prDetailHeader[0]['createdby'];  
      $scope.distinctItem =  $scope.prDetailHeader[0]['item_count'];  
      $scope.countTotal =  $scope.prDetailHeader[0]['total_item_qty']; 
      //$scope.totalPriceRp = convertRp(Math.floor($scope.prDetailHeader[0]['invoice_total']));  
      //$scope.discountAmountRp = convertRp($scope.prDetailHeader[0]['invoice_discount_amount']);  
      //$scope.taxAmountRp = convertRp($scope.prDetailHeader[0]['invoice_tax_amount']);  
      //$scope.grandTotalRp = convertRp(Math.floor($scope.prDetailHeader[0]['grandtotal']));  
    });

    $http.get(url_base+'pr/prViewDetail/'+id).success(function (records){
      $scope.prDetail = records;

      /*for (var i = 0; i < $scope.prDetail.length; i++){
        $scope.prDetail[i]['priceRp'] = convertRp($scope.prDetail[i]['price']);
        $scope.prDetail[i]['subtotalRp'] = convertRp($scope.prDetail[i]['subtotal']);
      }*/
    });
  }
]);

app.controller('PrNewController', function($scope,$http, $timeout) {
  $scope.productList = [];
  $scope.barcodeX = [];
  $scope.barcodeY = [];
  $scope.invoiceNo = '';
  $scope.notes = '';
  $scope.distinctItem = 0;
  $scope.countTotal = 0;
  $scope.poId = '';
  $scope.poCode = '';
  $scope.statusBarcode = true;
  $scope.searchCode = '';
  $scope.searchName = '';
  $("#masking").hide();
  $("#divList").hide();
  $("#divList2").hide();
  $("#divNotif").hide();
  var pressed = false; 
  var chars = [];

  $http.get(url_base+"po/storageView").success(function (records){
    $scope.storageList = records;
  });

  $http.get(url_base+"pr/getInputMethod").success(function (records){
    if (records['input_method'] == 0){
      $("#tableEdit").hide();
      $("#buttonProduct").hide();

      $(window).on("keypress",function(ev) {
        if ((ev.which >= 48 && ev.which <= 57) || (ev.which >= 65 && ev.which <= 90)) {
          chars.push(String.fromCharCode(ev.which));
        }

        if (pressed == false) {
          setTimeout(function(){
            if (chars.length == 12) {
              var barcode = chars.join("");   
              $("#barcode").val(barcode);

              if($("#barcode").val().length == 12){
                var barcode = $("#barcode").val().substring(0,6);

                var is_barcode_exist_local = false;
                var is_barcode_exist_global = false;

                for (var i = 0; i < $scope.barcodeX.length; i++) {
                  if ($scope.barcodeX[i] == $("#barcode").val()){
                    is_barcode_exist_local = true;
                    $.growl.warning({ message: 'Produk sudah di scan di PR ini' });
                  }
                }

                for (var i = 0; i < $scope.barcodeY.length; i++) {
                  if ($scope.barcodeY[i] == $("#barcode").val()){
                    is_barcode_exist_global = true;
                    $.growl.warning({ message: 'Produk sudah di scan di PR sebelumnya' });
                  }
                }

                if (is_barcode_exist_local == false && is_barcode_exist_global == false){
                  $http.get(url_base+"pr/getProduct?code="+barcode).success(function (records){
                    $scope.productBarcode = records; 
                    if ($scope.productBarcode.length == 1){
                      var id = $scope.productBarcode[0]['product_id'];
                      var code = $scope.productBarcode[0]['product_code'];
                      var name = $scope.productBarcode[0]['product_name'];
                      var unitL = $scope.productBarcode[0]['unit_large'];
                      var quantity = $scope.productBarcode[0]['quantity'];
                      var quantity2 = $scope.productBarcode[0]['quantity2'];
                      var quantity3 = $scope.productBarcode[0]['quantity3'];

                      if (isExist(code) == false && $scope.statusBarcode == true) {
                        $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
                      }
                      else {
                        for (var i = $scope.productList.length - 1; i >= 0; i--) {
                          if ($scope.productList[i].code == code) {
                            var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

                            $scope.productList[i].quantity = qty;
                          };
                        };
                      };
                      
                      for (var i = $scope.productList.length - 1; i >= 0; i--) {
                        if ($scope.productList[i].code == code) {
                          if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                            $scope.productList[i].quantity = $scope.productList[i].quantity2
                            $.growl.warning({ message: 'Jumlah produk sudah melebihi jumlah PO' });
                          }
                          else{
                            $scope.barcodeX[$scope.barcodeX.length] = $("#barcode").val();

                            $scope.codeBarcodeView = $("#barcode").val();
                            $scope.nameBarcodeView = $scope.productList[i].name;
                            $scope.currentQtyBarcodeView = $scope.productList[i].quantity;
                            $scope.leftQtyBarcodeView = $scope.productList[i].quantity2;
                            if ($scope.leftQtyBarcodeView > 0){
                              $scope.separator = '/';
                            }
                            else{
                              $scope.separator = '';
                            }
                          };
                        };
                      };

                      if (isExist(code) == false && $scope.statusBarcode == false) {
                        $.growl.warning({ message: 'Produk tidak ada di list' });
                      }

                      $scope.distinctItem = $scope.productList.length;
                      $scope.countTotal = count();
                    }
                  });
                }
              }
            }
            chars = [];
            pressed = false;
          },500);
        }
        pressed = true;
      });
    }
    else{
      $("#tableNoEdit").hide();
      $("#divBarcode").hide();
    }
  });

  $http.get(url_base+"pr/categoryView").success(function (records){
    $scope.categoryList = records; 
  });

  $http.get(url_base+"pr/groupView").success(function (records){
    $scope.groupList = records; 
  });

  $("#datepickerInvoice").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerInvoice").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $(window).resize(function(){
    if ($(window).width() < 752){
      $("#divExtend").height(80);
    }
    else{
      $("#divExtend").height(0);
    }
  });

  $http.get(url_base+"pr/getBarcode").success(function (records){
    $scope.barcodeList = records; 

    for (var i = $scope.barcodeList.length - 1; i >= 0; i--) {
      $scope.barcodeY[$scope.barcodeY.length] = $scope.barcodeList[i].code;
    };
  });

  /*function parsingDate(date) {
    var identify1 = date.substring(2,3);
    var identify2 = date.substring(5,6);
    if (identify1 == '/' && identify2 == '/'){
      if (date == '') {
        return '';
      }
      else {
        var dd = date.substring(3,5);
        var mm = date.substring(0,2);
        var yyyy = date.substring(6,10);
        var parsing = yyyy+"-"+mm+"-"+dd;

        return parsing;
      }
    }
    else{
      return date;
    }
  }*/

  function isExist(code){
    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].code == code) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      count = parseFloat($scope.productList[i]['quantity']) + parseFloat(count);
    };

    return count;
  };

  function curDate(){
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1;
    var yyyy = today.getFullYear();

    if (dd < 10){
      dd = '0'+dd;
    };

    if (mm < 10){
      mm = '0'+mm;
    };  

    today = yyyy+'-'+mm+'-'+dd; 

    return today;
  }

  $scope.datePr = curDate();

  $scope.inputBarcode = function() {
    if($scope.barcode.length == 12){
      var barcode = $scope.barcode.substring(0,6);

      var is_barcode_exist_local = false;
      var is_barcode_exist_global = false;

      for (var i = 0; i < $scope.barcodeX.length; i++) {
        if ($scope.barcodeX[i] == $scope.barcode){
          is_barcode_exist_local = true;
          $.growl.warning({ message: 'Produk sudah di scan di PR ini' });
        }
      }

      for (var i = 0; i < $scope.barcodeY.length; i++) {
        if ($scope.barcodeY[i] == $scope.barcode){
          is_barcode_exist_global = true;
          $.growl.warning({ message: 'Produk sudah di scan di PR sebelumnya' });
        }
      }

      if (is_barcode_exist_local == false && is_barcode_exist_global == false){
        $http.get(url_base+"pr/getProduct?code="+barcode).success(function (records){
          $scope.productBarcode = records; 
          if ($scope.productBarcode.length == 1){
            var id = $scope.productBarcode[0]['product_id'];
            var code = $scope.productBarcode[0]['product_code'];
            var name = $scope.productBarcode[0]['product_name'];
            var unitL = $scope.productBarcode[0]['unit_large'];
            var quantity = $scope.productBarcode[0]['quantity'];
            var quantity2 = $scope.productBarcode[0]['quantity2'];
            var quantity3 = $scope.productBarcode[0]['quantity3'];

            if (isExist(code) == false && $scope.statusBarcode == true) {
              $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
            }
            else {
              for (var i = $scope.productList.length - 1; i >= 0; i--) {
                if ($scope.productList[i].code == code) {
                  var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

                  $scope.productList[i].quantity = qty;
                };
              };
            };
            
            for (var i = $scope.productList.length - 1; i >= 0; i--) {
              if ($scope.productList[i].code == code) {
                if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                  $scope.productList[i].quantity = $scope.productList[i].quantity2
                  $.growl.warning({ message: 'Jumlah produk sudah melebihi jumlah PO' });
                }
                else{
                  $scope.barcodeX[$scope.barcodeX.length] = $scope.barcode;

                  $scope.codeBarcodeView = $scope.barcode;
                  $scope.nameBarcodeView = $scope.productList[i].name;
                  $scope.currentQtyBarcodeView = $scope.productList[i].quantity;
                  $scope.leftQtyBarcodeView = $scope.productList[i].quantity2;
                  if ($scope.leftQtyBarcodeView > 0){
                    $scope.separator = '/';
                  }
                  else{
                    $scope.separator = '';
                  }
                };
              };
            };

            if (isExist(code) == false && $scope.statusBarcode == false) {
              $.growl.warning({ message: 'Produk tidak ada di list' });
            }

            $scope.distinctItem = $scope.productList.length;
            $scope.countTotal = count();
          }
           $scope.barcode = '';
        });
      }
      else{
        $scope.barcode = '';
      }
    }
  };

  $scope.searchProductList = function(code,name) {
    var poId = $scope.poId;
    var category = $("#categorySelected").val();
    var group = $("#groupSelected").val();

    if ($("#poSelected").val() == ""){
      $http.get(url_base+"pr/searchProductNullList?code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
        $scope.products = records;
      });
    }
    else{
      $http.get(url_base+"pr/searchProductList?poId="+poId+"&code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
        $scope.products = records;
      });
    }
  };

  /*$scope.updatePo = function() {
    $scope.productList = [];

    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
    $scope.totalPrice = totalPrice();
    $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
    $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.totalPriceRp = convertRp($scope.totalPrice);
    $scope.discountAmountRp = convertRp($scope.discountAmount);
    $scope.taxAmountRp = convertRp($scope.taxAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);
  };*/

  $scope.addProduct = function(id,code,name,unitL,quantity2,quantity3) {
    $scope.productName = name;
    $scope.unitL = unitL;

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList2").height()+"px","width": $("#divList2").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addCount = function(quantity) {
      if ($scope.count > 0) {
        if (isExist(code) == false) {
          if (quantity > quantity2){
            $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity2,"quantity2":quantity2,"quantity3":quantity3});
          }
          else{
            $scope.productList.push({"id":id,"code":code,"name":name,"unitL":unitL,"quantity":quantity,"quantity2":quantity2,"quantity3":quantity3});
          }
        }
        else {
          for (var i = $scope.productList.length - 1; i >= 0; i--) {
            if ($scope.productList[i].id == id) {
              var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

              $scope.productList[i].quantity = qty;

              if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
                $scope.productList[i].quantity = $scope.productList[i].quantity2;
              }

              var pId = "p"+id;
              $("#"+pId).val($scope.productList[i].quantity);
            };
          };
        };

        $scope.distinctItem = $scope.productList.length;
        $scope.countTotal = count();
        $scope.count = '';
        $("#masking").hide();
      }
      else{
        $.growl.notice({ message: "Jumlah harus diatas 0" });
      };
    };
  };

  $scope.updateCount = function(id){
    var pId = "p"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].quantity = newVal;

        if (parseFloat($scope.productList[i].quantity) > parseFloat($scope.productList[i].quantity2)) {
          $scope.productList[i].quantity = $scope.productList[i].quantity2
        }

        $("#"+pId).val($scope.productList[i].quantity);

        $scope.countTotal = count();
      };
    };
  };

  /*$scope.updatePrice = function(id){
    var pId = "p"+id;
    var p2Id = "p2"+id;
    var newVal = $("#"+p2Id).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].price = newVal;
      
        var subtotal = newVal * $("#"+pId).val();
        $scope.productList[i].subtotal = subtotal;
        $scope.productList[i].subtotalRp = convertRp(subtotal);

        $scope.totalPrice = totalPrice();
        $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
        $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
        $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
        $scope.totalPriceRp = convertRp($scope.totalPrice);
        $scope.discountAmountRp = convertRp($scope.discountAmount);
        $scope.taxAmountRp = convertRp($scope.taxAmount);
        $scope.grandTotalRp = convertRp($scope.grandTotal);
      };
    };
  };

  $scope.updateSkuSup = function(id){
    var p3Id = "p3"+id;
    var newVal = $("#"+p3Id).val();

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].skuSup = newVal;
      };
    };
  };

  $scope.updateProdSup = function(id){
    var p4Id = "p4"+id;
    var newVal = $("#"+p4Id).val();

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].prodSup = newVal;
      };
    };
  };

  $scope.updateDiscount = function(){
    $scope.discount = $("#discount").val();
    $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.discountAmountRp = convertRp($scope.discountAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);
  };

  $scope.updateTax = function(){
    $scope.tax = $("#tax").val();
    $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.taxAmountRp = convertRp($scope.taxAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);
  };*/

  $scope.deleteProduct = function(index) {
    for (var i = $scope.barcodeX.length - 1; i >= 0; i--) {
      if ($scope.barcodeX[i].substring(0,6) == $scope.productList[index].code) {
        $scope.barcodeX.splice(i,1);
      }
    };

    $scope.productList.splice(index,1);
    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();

    /*$scope.totalPrice = totalPrice();
    $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
    $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.totalPriceRp = convertRp($scope.totalPrice);
    $scope.discountAmountRp = convertRp($scope.discountAmount);
    $scope.taxAmountRp = convertRp($scope.taxAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);*/
  };

  $scope.savePurchaseReceipt = function(isgen,status) {
    var invoiceNo = $scope.invoiceNo;
    var dateInvoice = $("#datepickerInvoice").val();
    //var poId = $("#poSelected").val();
    var poId = $scope.poId;
    var datePr = $scope.datePr;
    //var discount = $("#discount").val();
    //var tax = $("#tax").val();
    var notes = $scope.notes;

    if(poId == "") {
      poId = "null";
    };

    if (invoiceNo === ''){
      $.growl.warning({ message: 'No Invoice belum diisi' });
    }
    else if (dateInvoice === ''){
      $.growl.warning({ message: 'Tanggal Invoice belum diisi' });
    }
    else if ($scope.productList.length == 0){
      $.growl.warning({ message: 'Data produk belum diisi' });
    }
    else {
      if(!isgen){
        if (status == 'save') {
          $scope.loading = true; 
        }
        else {
          $scope.loading2 = true; 
        }
      };

      $scope.productHeader = {"st":$("#storageSelected").val(),"invoiceNo":invoiceNo,"dateInvoice":dateInvoice,"poId":poId,"datePr":datePr,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal,"status":status,"notes":notes};

      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);
      var json3 = JSON.stringify($scope.barcodeX);

      $.ajax({
        type: 'post',
        url:url_base+'pr/savePurchaseReceipt',
        data: "json="+json+"&json2="+json2+"&json3="+json3,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"pr/getNotif").success(function (records) {
                  $scope.prNotif = records[0]['pr_code'];
                  $scope.poNotif = records[0]['po_code'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  $scope.invoiceNo = invoiceNo;
                  $scope.dateInvoice = dateInvoice;
                  $scope.datePr = datePr;
                  $scope.notes = notes;
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

  $scope.showDivList = function() {
    $http.get(url_base+"pr/poView").success(function (records){
      $scope.poList = records; 
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.poList.length;
      $scope.totalItems = $scope.poList.length;

      window.scrollTo(0,0);
      $("#divMain").hide();
      $("#divList").css({top:-80,left:0,position:"absolute"});
      $("#divList").css("z-index","9998");
      $("#divList").show(function(){
        $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
      
        if ($(window).width() < 752){
          $("#divExtend").height(80);
        }
        else{
          $("#divExtend").height(0);
        }
      });
    });

    $scope.barcodeX = [];
    $scope.codeBarcodeView = '';
    $scope.nameBarcodeView = '';
    $scope.currentQtyBarcodeView = '';
    $scope.leftQtyBarcodeView = '';
    $scope.separator = '';
    $scope.productList = [];
    $scope.distinctItem = 0;
    $scope.countTotal = 0;
    $scope.separator = '/';
  };

  $scope.showDivList2 = function() {
    if($scope.poCode == ''){
      $http.get(url_base+"pr/productView").success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList2").css({top:-80,left:0,position:"absolute"});
        $("#divList2").css("z-index","9998");
        $("#divList2").show(function(){
          $("#divList2").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend2").height(80);
          }
          else{
            $("#divExtend2").height(0);
          }
        });
      });
    }
    else {
      var poId = $scope.poId;

      $http.get(url_base+"pr/productView2?poId="+poId).success(function (records){
        $scope.products = records; 
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList2").css({top:-80,left:0,position:"absolute"});
        $("#divList2").css("z-index","9998");
        $("#divList2").show(function(){
          $("#divList2").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend").height(80);
          }
          else{
            $("#divExtend").height(0);
          }
        });
      });
    };
  };

  $scope.backMain = function(poId,poCode) {
    $("#divMain").show();
    $("#divList").hide();

    $scope.poId = poId;
    $scope.poCode = poCode;
    $scope.statusBarcode = false;

    $http.get(url_base+"pr/poDetailView?poId="+poId).success(function (records){
      $scope.productList = records; 
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.productList.length;
      $scope.totalItems = $scope.productList.length;
      $scope.distinctItem = $scope.productList.length;
      $scope.countTotal = count();
    });
  };


  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.search = '';
  };

  $scope.showDivMain2 = function() {
    $("#divMain").show();
    $("#divList2").hide();
    $scope.searchCode = '';
    $scope.searchName = '';
    $("#categorySelected").val("");
    $("#groupSelected").val("");
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.count = '';
  };

  $("#barcode").keypress(function(ev){
    if (ev.which === 13 ) {
      ev.preventDefault();
    }
  });

  $("button").click(function(){
    $(this).blur();
  });
});