app.controller('PoController', function($scope,$http, $timeout) {
  $(window).off("keypress");
  $http.get(url_base+"po/poView").success(function (records) {
    $scope.po = records;
    $scope.currentPage = 1;
    $scope.entryLimit = 25;
    $scope.filteredItems = $scope.po.length;
    $scope.totalItems = $scope.po.length;
  });

  $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
  };

  $scope.filter = function() {
      $timeout(function() { 
          $scope.filteredItems = $scope.filtered.length;
      }, 25);
  };
});

app.controller('PoDetailController',['$scope','$routeParams','$http',
  function($scope,$routeParams,$http){
    var id = $routeParams.id;

    function convertRp(input){
      var round = Math.floor(input);
      var money = round.toString();
      var pointer = money.length % 3;
      var dot = Math.floor(money.length / 3);
      var rp = money.substring(0,pointer);

      if (pointer != 0){
        rp = rp + String.fromCharCode(46);
      }

      for (var i = 0; i < dot; i++){
        rp = rp + money.substring(pointer,pointer + 3) + String.fromCharCode(46);
        pointer = pointer + 3;
      }

      rp = rp.substring(0,rp.length - 1);
      rp = 'Rp ' + rp;

      return rp;
    };

    $http.get(url_base+'po/poViewDetailHeader/'+id).success(function (records){
      $scope.poDetailHeader = records;
      $scope.codeSelected = $scope.poDetailHeader[0]['po_code'];
      $scope.datePoSelected = $scope.poDetailHeader[0]['po_date'];
      $scope.supplierSelected = $scope.poDetailHeader[0]['sup_name'];
      $scope.dateSupplySelected = $scope.poDetailHeader[0]['supply_date'];
      $scope.carrierSelected = $scope.poDetailHeader[0]['carrier_name'];
      $scope.paymentTypeSelected = $scope.poDetailHeader[0]['payment_type'];
      $scope.dateTermSelected = $scope.poDetailHeader[0]['payment_term'];
      $scope.discountSelected = $scope.poDetailHeader[0]['discount_value'];
      $scope.taxSelected = $scope.poDetailHeader[0]['tax_rate'];
      $scope.atSelected = $scope.poDetailHeader[0]['createdat'];  
      $scope.bySelected = $scope.poDetailHeader[0]['full_name'];  
      $scope.distinctItem =  $scope.poDetailHeader[0]['item_count'];  
      $scope.countTotal =  $scope.poDetailHeader[0]['total_item_qty'];  
      $scope.totalPriceRp = convertRp($scope.poDetailHeader[0]['subtotal']);  
      $scope.discountAmountRp = convertRp($scope.poDetailHeader[0]['discount_amount']);  
      $scope.taxAmountRp = convertRp($scope.poDetailHeader[0]['tax_amount']);  
      $scope.grandTotalRp = convertRp($scope.poDetailHeader[0]['grandtotal']);  
    });

    $http.get(url_base+'po/poViewDetail/'+id).success(function (records){
      $scope.poDetail = records;

      for (var i = 0; i < $scope.poDetail.length; i++){
        $scope.poDetail[i]['priceRp'] = convertRp($scope.poDetail[i]['price']);
        $scope.poDetail[i]['subtotalRp'] = convertRp($scope.poDetail[i]['subtotal']);
      }
    });
  }
]);

app.controller('PoNewController', function($scope,$http, $timeout) {
  $scope.productList = [];
  $scope.hidden = true;
  $scope.discount = 0;
  $scope.tax = 0;
  $scope.distinctItem = 0;
  $scope.countTotal = 0;
  $scope.totalPrice = 0;
  $scope.discountAmount = 0;
  $scope.taxAmount = 0;
  $scope.grandTotal = 0;
  $scope.sup = '';
  $scope.searchCode = '';
  $scope.searchName = '';
  $("#masking").hide();
  $("#divList").hide();
  $("#divNotif").hide();

  /*$http.get(url_base+"po/storageView").success(function (records){
    $scope.storageList = records;
  });*/

  $http.get(url_base+"po/supplierView").success(function (records){
    $scope.supplierList = records; 
  });

  $http.get(url_base+"po/carrierView").success(function (records){
    $scope.carrierList = records; 
  });

  $http.get(url_base+"po/categoryView").success(function (records){
    $scope.categoryList = records; 
  });

  $http.get(url_base+"po/groupView").success(function (records){
    $scope.groupList = records; 
  });

  $("#datepickerSupply").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerSupply").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $("#datepickerTerm").datepicker({
    format:"yyyy-mm-dd"
  });

  $("#datepickerTerm").on('changeDate',function(){
    $(this).datepicker("hide");
  });

  $(window).resize(function(){
    if ($(window).width() < 752){
      $("#divExtend").height(80);
    }
    else{
      $("#divExtend").height(0);
    }
  });

  function curDate(){
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1;
    var yyyy = today.getFullYear();

    if (dd < 10){
      dd = '0'+dd;
    };

    if (mm < 10){
      mm = '0'+mm;
    };  

    today = yyyy+'-'+mm+'-'+dd; 

    return today;
  }

  $scope.datePo = curDate();

  function isExist(id){
    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        return true;
      };
    };
    return false;
  };

  function count(){
    var count = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      count = parseFloat($scope.productList[i].quantity) + parseFloat(count);
    };

    return count;
  };

  /*function parsingDate(date) {
    var identify1 = date.substring(2,3);
    var identify2 = date.substring(5,6);
    if (identify1 == '/' && identify2 == '/'){
      if (date == '') {
        return '';
      }
      else {
        var dd = date.substring(3,5);
        var mm = date.substring(0,2);
        var yyyy = date.substring(6,10);
        var parsing = yyyy+"-"+mm+"-"+dd;

        return parsing;
      }
    }
    else{
      return date;
    }
  }*/

  function totalPrice(){
    var total = 0;

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      total = parseInt(total) + parseInt($scope.productList[i].subtotal);
    };

    return total;
  };

  function convertRp(input){
      var round = Math.floor(input);
      var money = round.toString();
      var pointer = money.length % 3;
      var dot = Math.floor(money.length / 3);
      var rp = money.substring(0,pointer);

      if (pointer != 0){
        rp = rp + String.fromCharCode(46);
      }
  
      for (var i = 0; i < dot; i++){
        rp = rp + money.substring(pointer,pointer + 3) + String.fromCharCode(46);
        pointer = pointer + 3;
      }

      rp = rp.substring(0,rp.length - 1);
      rp = 'Rp ' + rp;

      return rp;
    };

  $scope.updateSupplier = function() {
    $scope.productList = [];

    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
    $scope.totalPrice = totalPrice();
    $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
    $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.totalPriceRp = convertRp($scope.totalPrice);
    $scope.discountAmountRp = convertRp($scope.discountAmount);
    $scope.taxAmountRp = convertRp($scope.taxAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);
  };

  $scope.searchProductList = function(code,name) {
    var sup_id = $("#supplierSelected").val();
    var category = $("#categorySelected").val();
    var group = $("#groupSelected").val();

    $http.get(url_base+"po/searchProductList?supplier="+sup_id+"&code="+code+"&name="+name+"&category="+category+"&group="+group).success(function (records) {
      $scope.products = records;
      $scope.currentPage = 1;
      $scope.entryLimit = 100;
      $scope.filteredItems = $scope.products.length;
      $scope.totalItems = $scope.products.length;
    });
  };

  $scope.addProduct = function(category,group,id,code,name,unitS,unitL,lastPrice) {
    $scope.productName = name;
    $scope.unitL = unitL;

    if(lastPrice != '-') {
      $scope.lastPrice = convertRp(Math.floor(lastPrice));
    }
    else {
      $scope.lastPrice = lastPrice;
    }

    $("#masking").css({top:0,left:0,position:"absolute"});
    $("#masking").css({"height": $("#divList").height()+"px","width": $("#divList").width()+"px"});
    $("#masking").css("z-index","9999");
    $("#masking").show();

    var x = $(window).scrollTop();
    var y = $("#masking").width();
    var z = $("#divCount").width();
    $("#divCount").css({top:x,left:(y-z)/2,position:"absolute"});

    $("#autofocus").focus();

    $scope.addCount = function(quantity,price) {
      if ($scope.count > 0 && $scope.price > 0) {
        if (isExist(id) == false) {
          $scope.productList.push({"id":id,"code":code,"name":name,"unitS":unitS,"unitL":unitL,"quantity":quantity,"price":price,"subtotal":price*quantity,"priceRp":convertRp(price),"subtotalRp":convertRp(price*quantity)});
        }
        else {
          for (var i = $scope.productList.length - 1; i >= 0; i--) {
            if ($scope.productList[i].id == id) {
              var qty = parseFloat($scope.productList[i].quantity) + parseFloat(quantity);

              $scope.productList[i].quantity = qty;
              $scope.productList[i].price = price;
              $scope.productList[i].priceRp = convertRp(price);

              var pId = "p"+id;
              var p2Id = "p2"+id;
              $("#"+pId).val(qty);
              $("#"+p2Id).val(price);

              $scope.productList[i].subtotal = parseFloat($scope.productList[i].quantity) * parseFloat($scope.productList[i].price);
              $scope.productList[i].subtotalRp = convertRp($scope.productList[i].subtotal);
            };
          };
        };

        $scope.distinctItem = $scope.productList.length;
        $scope.countTotal = count();
        $scope.totalPrice = totalPrice();
        $scope.discountAmount = $scope.totalPrice * $scope.discount / 100;
        $scope.taxAmount = $scope.totalPrice * $scope.tax / 100;
        $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
        $scope.totalPriceRp = convertRp($scope.totalPrice);
        $scope.discountAmountRp = convertRp($scope.discountAmount);
        $scope.taxAmountRp = convertRp($scope.taxAmount);
        $scope.grandTotalRp = convertRp($scope.grandTotal);
        $scope.count = '';
        $scope.price = '';
        $("#masking").hide();
      }
      else{
        $.growl.notice({ message: "Jumlah dan Harga harus diatas 0" });
      };
    };
  };

  $scope.updateDiscount = function(){
    $scope.discount = $("#discount").val();
    $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.discountAmountRp = convertRp($scope.discountAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);
  };

  $scope.updateTax = function(){
    $scope.tax = $("#tax").val();
    $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.taxAmountRp = convertRp($scope.taxAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);
  };

  $scope.updateCount = function(id){
    var pId = "p"+id;
    var p2Id = "p2"+id;
    var newVal = $("#"+pId).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].quantity = newVal;
        $("#"+pId).val(newVal);
       
        var subtotal = newVal * $("#"+p2Id).val();
        $scope.productList[i].subtotal = subtotal;
        $scope.productList[i].subtotalRp = convertRp(subtotal);

        $scope.countTotal = count();
        $scope.totalPrice = totalPrice();
        $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
        $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
        $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
        $scope.totalPriceRp = convertRp($scope.totalPrice);
        $scope.discountAmountRp = convertRp($scope.discountAmount);
        $scope.taxAmountRp = convertRp($scope.taxAmount);
        $scope.grandTotalRp = convertRp($scope.grandTotal);
      };
    };
  };

  $scope.updatePrice = function(id){
    var pId = "p"+id;
    var p2Id = "p2"+id;
    var newVal = $("#"+p2Id).val();

    if (newVal == ''){
      newVal = 0;
    }

    for (var i = $scope.productList.length - 1; i >= 0; i--) {
      if ($scope.productList[i].id == id) {
        $scope.productList[i].price = newVal;
        $scope.productList[i].priceRp = convertRp(newVal);
        $("#"+p2Id).val(newVal);
      
        var subtotal = newVal * $("#"+pId).val();
        $scope.productList[i].subtotal = subtotal;
        $scope.productList[i].subtotalRp = convertRp(subtotal);

        $scope.totalPrice = totalPrice();
        $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
        $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
        $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
        $scope.totalPriceRp = convertRp($scope.totalPrice);
        $scope.discountAmountRp = convertRp($scope.discountAmount);
        $scope.taxAmountRp = convertRp($scope.taxAmount);
        $scope.grandTotalRp = convertRp($scope.grandTotal);
      };
    };
  };

  $scope.deleteProduct = function(index) {
    $scope.productList.splice(index,1);
    $scope.distinctItem = $scope.productList.length;
    $scope.countTotal = count();
    $scope.totalPrice = totalPrice();
    $scope.discountAmount = $scope.discount / 100 * $scope.totalPrice;
    $scope.taxAmount = $scope.tax / 100 * $scope.totalPrice;
    $scope.grandTotal = $scope.totalPrice - $scope.discountAmount + $scope.taxAmount;
    $scope.totalPriceRp = convertRp($scope.totalPrice);
    $scope.discountAmountRp = convertRp($scope.discountAmount);
    $scope.taxAmountRp = convertRp($scope.taxAmount);
    $scope.grandTotalRp = convertRp($scope.grandTotal);
  };

  $scope.savePurchaseOrder = function(isgen,status) {
    var datePo = $scope.datePo;
    var dateSupply = $("#datepickerSupply").val();
    var dateTerm = $("#datepickerTerm").val();
    var supplierId = $("#supplierSelected").val();
    var carrierId = $("#carrierSelected").val();
    var paymentType = $("#paymentSelected").val();
    var tax = $("#tax").val();
    var discount = $("#discount").val();

    if(carrierId == "") {
      carrierId = "null";
    };

    if ($("#supplierSelected").val() === ''){
      $.growl.warning({ message: 'Supplier belum diisi' });
    }
    else if ($("#datepickerSupply").val() === ''){
      $.growl.warning({ message: 'Tanggal Supply belum diisi' });
    }
    else if ($("#datepickerTerm").val() === ''){
      $.growl.warning({ message: 'Masa Pembayaran belum diisi' });
    }
    else if ($("#discount").val() === ''){
      $.growl.warning({ message: 'Diskon belum diisi' });
    }
    else if ($("#tax").val() === ''){
      $.growl.warning({ message: 'Pajak belum diisi' });
    }
    else if ($scope.productList.length == 0){
      $.growl.warning({ message: 'Data produk belum diisi' });
    }
    else {
      if(!isgen){
        if (status == 'save') {
          $scope.loading = true; 
        }
        else {
          $scope.loading2 = true; 
        }
      };

      $scope.productHeader = {"datePo":datePo,"supplierId":supplierId,"dateSupply":dateSupply,"itemCount":$scope.distinctItem,"totalItemQty":$scope.countTotal,"carrierId":carrierId,"dateTerm":dateTerm,"paymentType":paymentType,"subtotal":$scope.totalPrice,"discount":discount,"discountAmount":$scope.discountAmount,"tax":tax,"taxAmount":$scope.taxAmount,"grandTotal":$scope.grandTotal,"status":status};

      var json = JSON.stringify($scope.productList);
      var json2 = JSON.stringify($scope.productHeader);

      $.ajax({
        type: 'post',
        url:url_base+'po/savePurchaseOrder',
        data: "json="+json+"&json2="+json2,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
              if (obj.status == 'sukses') {
                $http.get(url_base+"po/getNotif").success(function (records) {
                  $scope.codeNotif = records[0]['po_code'];
                  $scope.supNotif = records[0]['sup_name'];
                  $scope.atNotif = records[0]['at'];
                  $scope.byNotif = records[0]['full_name'];
                  $scope.carrierNotif = records[0]['carrier_name'];
                  $scope.datePo = datePo;
                  $scope.dateSupply = dateSupply;
                  $scope.dateTerm = dateTerm;
                  $scope.paymentType = paymentType;
                  $scope.discount = discount;
                  $scope.tax = tax;
                  $("#divMain").hide();
                  $("#divNotif").show();
                });
                $.growl.notice({ message: "Data BERHASIL diSimpan" });
              } else {
                $.growl.error({ message: "Data GAGAL diSimpan. Ulangi Lagi !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              $scope.loading2 = false;
            }
            $.growl.error({ message: "Data GAGAL diSimpan. <br/>Cek koneksi internet dan ulangi Lagi !" });
          },1000);
        } 
      });
    }
  };

  $scope.showDivList = function() {
    if($scope.sup == ''){
      $.growl.warning({ message: 'Pilih supplier terlebih dahulu' });
    }
    else {
      var sup_id = $("#supplierSelected").val();

      $http.get(url_base+"po/productView/"+sup_id).success(function (records) {
        $scope.products = records;
        $scope.currentPage = 1;
        $scope.entryLimit = 100;
        $scope.filteredItems = $scope.products.length;
        $scope.totalItems = $scope.products.length;

        window.scrollTo(0,0);
        $("#divMain").hide();
        $("#divList").css({top:-80,left:0,position:"absolute"});
        $("#divList").css("z-index","9998");
        $("#divList").show(function(){
          $("#divList").css({"height": $(document).height()+"px","width": $(document).width()+"px"});
        
          if ($(window).width() < 752){
            $("#divExtend").height(80);
          }
          else{
            $("#divExtend").height(0);
          }
        });
      });
    };
  };

  $scope.showDivMain = function() {
    $("#divMain").show();
    $("#divList").hide();
    $scope.searchCode = '';
    $scope.searchName = '';

    $(function() {
      $("#categorySelected").val("");
      $("#groupSelected").val("");
    });
  };

  $scope.hideDivCount = function() {
    $("#masking").hide();
    $scope.count = '';
    $scope.price = '';
  };
});