app.controller('InitSaldoController', function($scope,$http, $timeout,$window) {
  $scope.glAccountListChild = [];
  $scope.accountType = [];
  $scope.total = 0;

  $scope.accountType.push({"id":"0","type":"debit"});
  $scope.accountType.push({"id":"1","type":"credit"});

  $http.get(url_base+'initsaldo/glAccountList').success(function (records){
    $scope.glAccountList = records;
  });

  $(document).on('change', function() {
    for (var i = $scope.glAccountListChild.length - 1; i >= 0; i--) {
      $scope.glAccountListChild[i].type = $("#t"+i).val();
     
      $scope.$apply();
    };
  })

  function total(){
    var total = 0;

    for(var i = 0; i < $scope.glAccountListChild.length; i++){
      total = parseFloat(total) + parseFloat($scope.glAccountListChild[i]['saldo']);
    } 
    
    return total;
  };

  function convertToRp(input){
    var rp = '';    
    input = parseFloat(input).toFixed(2);
    var angkarev = input.toString().split('').reverse().join('');
    var dec = angkarev.substr(0,2).split('').reverse().join('');
    var num = angkarev.substr(3,input.length-3).split('').reverse().join('');

    angkarev = num.toString().split('').reverse().join('');

    for(var i = 0; i < angkarev.length; i++){
      if(i%3 == 0){
        rp += angkarev.substr(i,3)+'.';
      } 
    } 

    var output = rp.split('',rp.length-1).reverse().join('')+','+dec;

    if (output.substr(0,1) == '-' && output.substr(1,1) == '.'){
      output = '-'+output.substr(2,output.length-2);
    }

    return output;
  }

  $scope.accountList = function(glno) {
    $http.get(url_base+'initsaldo/glAccountListChild/'+glno).success(function (records){
      $scope.glAccountListChild = records;

      $scope.total = convertToRp(total());
    });
  };

  $scope.updateTotal = function(index){
    var pId = "p"+index;
    var newVal = $("#"+pId).val();

    for (var i = $scope.glAccountListChild.length - 1; i >= 0; i--) {
      if (i == index) {
        $scope.glAccountListChild[i]['saldo'] = newVal;

        $("#"+pId).val(newVal);
      };
    };

    $scope.total = convertToRp(total());
  };

  $scope.saveInitSaldo = function(isgen,status) {
    if ($scope.glAccountListChild.length == 0){
      $.growl.warning({ message: 'Empty Data Set' });
    }
    else {
      if(!isgen){
        $scope.loading = true; 
      };

      var json = JSON.stringify($scope.glAccountListChild);

      $.ajax({
        type: 'post',
        url:url_base+'initsaldo/saveInitSaldo',
        data: "json="+json,
        success: function(msg){
          var obj = JSON.parse(msg);
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
              if (obj.status == 'sukses') {
                $.growl.notice({ message: "Data updated" });
              } 
              else {
                $.growl.error({ message: "Update failed. Try again !" });
              };
            }
          },1000);
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $timeout(function(){
            if(!isgen){
              $scope.loading = false;
            }
            $.growl.error({ message: "Update failed. <br/>Check connection and try again !" });
          },1000);
        } 
      });
    }

  };

  
});