<?php
class Report_Waste extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	function runQuery($_sql, $data)
	{
		if($data->group == 'products')
		{
			$sql = "CALL sp_report_waste_products(".(isset($data->outlet_id) && $data->outlet_id <> '' ? $data->outlet_id : '0').", '".$data->periode_start."', '".$data->periode_end."', '".$data->viewtype."')";
		} elseif($data->group == 'menus')
		{
			$sql = "SELECT B.menu_id, C.menu_code, C.menu_name, C.menu_price, SUM(B.qty) AS `total` ".$_sql."
					FROM `outlet_menu_waste` A INNER JOIN `outlet_menu_waste_details` B ON A.id = B.waste_menu_id 
						INNER JOIN `master_menus` C ON B.menu_id = C.menu_id
					WHERE A.closing_date BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".((isset($data->outlet_id)) && ($data->outlet_id * 1) > 0 ? " AND A.outlet_id = ".$data->outlet_id : '')." 
					GROUP BY B.menu_id, C.menu_code, C.menu_name, C.menu_price
					ORDER BY C.menu_name";
		}
	
		$qry_res = $this->db->query($sql);
		$result = $qry_res->result_array();
		$qry_res->next_result();
		$qry_res->free_result();
		
		return $result;
	}
	
	public function viewTotal($data, $fields)
	{
		$result = $this->runQuery('', $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewMonthly($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ym'), 'title'=>$_newDate->format('Ym'));
			if($data->group == 'menus')
				$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m') = '".$_newDate->format('Ym')."' THEN B.qty ELSE 0 END) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewDaily($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ymd'), 'title'=>$_newDate->format('Ymd'));
			if($data->group == 'menus')
				$sql .= ", SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN B.qty ELSE 0 END) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
}