<?php
class Report_Sales extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	function runQuery($_sql, $data)
	{
		$sql = "SELECT B.outlets_id, B.other_code AS `outlets_code`, B.outlets_name, fc_format_rupiah(SUM(A.JmlPenjualan)) AS `total` ".$_sql."
				FROM `outlet_sales_orders` A INNER JOIN `master_outlets` B ON A.KdOutlet = B.other_code
				WHERE A.SdhBayar = 'T' AND A.tglClosing BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".((isset($data->outlet_id)) && ($data->outlet_id * 1) > 0 ? " AND B.outlets_id = ".$data->outlet_id : '')." 
				GROUP BY B.outlets_id, B.other_code, B.outlets_name
				ORDER BY B.outlets_name";
		return $this->db->query($sql)->result_array();
	}
	
	public function viewTotal($data, $fields)
	{
		$result = $this->runQuery('', $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewMonthly($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ym'), 'title'=>$_newDate->format('Ym'));
			$sql .= ", fc_format_rupiah(SUM(CASE WHEN DATE_FORMAT(A.tglClosing,'%Y%m') = '".$_newDate->format('Ym')."' THEN A.JmlPenjualan ELSE 0 END)) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewDaily($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ymd'), 'title'=>$_newDate->format('Ymd'));
			$sql .= ", fc_format_rupiah(SUM(CASE WHEN DATE_FORMAT(A.tglClosing,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN A.JmlPenjualan ELSE 0 END)) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
}