<?php
class Report_Purchased extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	function runQuery($_sql, $data)
	{
		$sql = "SELECT B.product_id, C.product_code, C.product_name, CONCAT('1 ', C.unit_large, ' = ', C.Conversion, ' ', C.unit_small) AS `unit`, fc_format_number(SUM(B.qty)) AS `total` ".$_sql."
				FROM `outlet_purchases` A INNER JOIN `outlet_purchase_details` B ON A.id = B.purchase_id 
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE A.closing_date BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".((isset($data->outlet_id)) && ($data->outlet_id * 1) > 0 ? " AND A.outlet_id = ".$data->outlet_id : '')." 
				GROUP BY B.product_id, C.product_code, C.product_name, C.unit_large, C.unit_small, C.Conversion
				ORDER BY C.product_name";
		return $this->db->query($sql)->result_array();
	}
	
	public function viewTotal($data, $fields)
	{
		$result = $this->runQuery('', $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewMonthly($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ym'), 'title'=>$_newDate->format('Ym'));
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m') = '".$_newDate->format('Ym')."' THEN B.qty ELSE 0 END)) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
	
	function viewDaily($data, $fields)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = array('code'=>'q'.$_newDate->format('Ymd'), 'title'=>$_newDate->format('Ymd'));
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN B.qty ELSE 0 END)) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		return array('fields'=>$fields, 'field_values'=>$result);
	}
}