<?php /**
* 
*/
class Closing extends CI_Controller
{
	function index()
	{
		$myDateTime =new DateTime($this->get_tanggal_closing());

		$newDateString = $myDateTime->format('d-m-Y');

		$get_info = $this->get_closing_information();
		$sales = array(
					'total_sales' => "Rp.".number_format($get_info->TotalJual,2,',','.'),
					'total_discount' => "Rp.".number_format($get_info->TotalDiscount,2,',','.'),
					'total_cash' => "Rp.".number_format($get_info->TotalCash,2,',','.'),
					'total_credit' => "Rp.".number_format($get_info->TotalCreditCard,2,',','.'),
					'total_customer' => "Rp.".number_format($get_info->jmlCustomer,2,',','.'),
					'user_closing' => $this->get_user_closing(),
					'tanggal' =>date('d-m-Y H:i:s'),
					'tanggal_closing' => $newDateString,
					'author_id' =>$this->session->userdata('author_id'),
					'can_close' => ($get_info->TotalJual > 0 ? true : false),
				);
		echo json_encode($sales);
	}


	
	function startclose()
	{	
		$get_info = $this->get_closing_information();
		
		if($get_info->TotalJual > 0)
		{
			$json = $this->input->post('json');
			$arr_php = json_decode($json);
			$sql = "UPDATE `outlet_config` SET `value` = DATE_ADD(CAST(value AS DATE), INTERVAL 1 DAY)
					WHERE code='closing_date' AND outlet_id = 1";
			$this->db->trans_begin();

			$this->create_log($arr_php);
			$result = $this->db->query($sql);

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				echo "gagal";
			}
			else
			{
				$this->db->trans_commit();
				echo "ok";
			}
		} else {
			echo "gagal";
		}
	}

	function get_closing_information()
	{
		$sql = "SELECT SUM(JmlPenjualan) AS `TotalJual`, SUM(JmlDiscount) AS `TotalDiscount`, SUM(JmlTunai) AS `TotalCash`, SUM(JmlCreditCard) AS `TotalCreditCard`, SUM(cuP + cuW) AS `jmlCustomer`
				FROM `outlet_sales_orders` A INNER JOIN `master_outlets` B ON A.KdOutlet = B.other_code
				WHERE A.SdhBayar = 'T' AND A.tglClosing = '".$this->get_tanggal_closing()."' AND B.outlets_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result;
	}

	function get_user_closing()
	{
		$sql = "select full_name from user_apps where id = ".$this->session->userdata('author_id');
		$result = $this->db->query($sql)->row();
		return $result->full_name;
	}

	function get_tanggal_closing()
	{
		$sql = "select value from outlet_config where code = 'closing_date' and outlet_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result->value;
	}

	function get_name_outlet(){
		$sql = "select outlets_name as name from master_outlets where outlets_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result->name;
	}

	function get_code_outlet(){
		$sql = "select outlets_code as name from master_outlets where outlets_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result->name;
	}
	
	function create_log($obj){
		$obj = array('closing_date' => $this->get_tanggal_closing(),
		'created_at' => date("Y-m-d H:i:s"),
		'user_closing'=>$obj->author_id,
		'sum_sales'=> $obj->total_sales,
		'sum_discount'=>$obj->total_discount,
		'sum_credits'=>$obj->total_credit,
		'sum_customer'=>$obj->total_customer,
		'sum_cash' => $obj->total_cash);

		$this->db->insert('log_closing',$obj);
	}

	function profile_data(){
		$data['nama_outlet'] = $this->get_name_outlet();
		$data['kode_outlet'] = $this->get_code_outlet();
		$data['full_name'] = $this->get_user_closing();
		$data['tanggal_closing'] = $this->get_tanggal_closing();
		echo json_encode($data);
	}
	
	function header_data(){
		//data outlet 
		//data closing 
		//data tanggal buat 
		$data['tanggal_closing'] = $this->get_tanggal_closing();
		$data['nama_outlet'] = $this->get_name_outlet();
		$data['tanggal_buat'] = date("Y-m-d H:i:s");

		echo json_encode($data);	
	}
	
	function get_outlet_information()
	{
		$sql = "select * from master_outlets where outlets_id = ".$this->session->userdata('outlet_id');
		$result = $this->db->query($sql)->row();
		return $result->outlets_code.' - '.$result->outlets_name;
	}
	
	function get_waste_menus($outlet_id, $closing_date)
	{
		$sql = "SELECT B.menu_id, C.menu_code, C.menu_name, B.qty, B.comment
				FROM `outlet_menu_waste` A INNER JOIN `outlet_menu_waste_details` B ON A.id = B.waste_menu_id
					INNER JOIN `master_menus` C ON B.menu_id = C.menu_id
				WHERE A.outlet_id = ".$outlet_id." AND A.closing_date = '".$closing_date."'
				ORDER BY C.menu_name";
		$result = $this->db->query($sql)->result();
		return $result;
	}
	
	function get_waste_products($outlet_id, $closing_date)
	{
		$sql = "SELECT B.product_id, C.product_code, C.product_name, B.qty, B.unit_small, B.comment
				FROM `outlet_product_waste` A INNER JOIN `outlet_product_waste_details` B ON A.id = B.waste_id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE A.outlet_id = ".$outlet_id." AND A.closing_date = '".$closing_date."'
				ORDER BY C.product_name";
		$result = $this->db->query($sql)->result();
		return $result;
	}
	
	function print_waste()
	{
		$outlet_id = $this->session->userdata('outlet_id');
		$closing_date = $this->get_tanggal_closing();
		$closeDateTime =new DateTime($closing_date);
		
		$data['outlet'] = $this->get_outlet_information();
		$data['closing_date'] = $closeDateTime->format('d-m-Y');
		$data['created_at'] = date('d-m-Y H:i:s');
		$data['created_by'] = $this->get_user_closing();
		$data['waste_menus'] = $this->get_waste_menus($outlet_id, $closing_date);
		$data['waste_products'] = $this->get_waste_products($outlet_id, $closing_date);
		
		header('Content-Type: application/json');
		echo json_encode($data);
	}
} ?>