<?php 
class so_importExport extends CI_Controller{
	function productList(){
		$sql = "select kodeprod,namaprod,hg_std,hg_std2,hg_std3,hg_khs,unit_std2,unit_std3,flex,line
				from so_product";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function packageList(){
		$sql = "select kodeprod,al_kemas,kemasan,kd_kemas,satuan,old_kode
				from so_package";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function customerList(){
		$sql = "select kodelang,namalang,sub_rayon,status
				from so_customer";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function paymentList(){
		$sql = "select *
				from so_payment
				where tg_tagih >= date_add(last_day(date_sub(now(), interval 2 month)), interval 1 day)";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function paymentDetailList(){
		$sql = "select *
				from so_payment_detail
				where tg_tagih >= date_add(last_day(date_sub(now(), interval 2 month)), interval 1 day)";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function salesList(){
		$sql = "select *
				from so_sales";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function stockList(){
		$sql = "select *
				from so_stock";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function factoryList(){
		$sql = "select *
				from so_factory";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}

	function importMaster(){
		$data = json_decode($this->input->post('json'));
		$data2 = json_decode($this->input->post('json2'));

		$author_id = $this->session->userdata('author_id');

		//print json_encode(count($data));

		for ($i = 0; $i < count($data); $i++) {
			if ($data2->tablename == 'FP'){
				$productname = addslashes($data[$i]->namaprod);
				$pabname = addslashes($data[$i]->namapab);
				$supname = addslashes($data[$i]->namasup);

				//$replace = "insert into so_product (kodeprod,namaprod,hg_std,hg_std2,hg_std3,unit_std2,unit_std3,line) values ('".$data[$i]->kodeprod."','".$productname."',".$data[$i]->hg_std.",".$data[$i]->hg_std2.",".$data[$i]->hg_std3.",".$data[$i]->unit_std2.",".$data[$i]->unit_std3.",'".$data[$i]->line."') on duplicate key update namaprod = '".$productname."',hg_std = ".$data[$i]->hg_std.",hg_std2 = ".$data[$i]->hg_std2.",hg_std3 = ".$data[$i]->hg_std3.",unit_std2 = ".$data[$i]->unit_std2.",unit_std3 = ".$data[$i]->unit_std3;
				//$replace = "insert into so_product values ('".$data[$i]->A."','".$data[$i]->B."','".$data[$i]->C."','".$data[$i]->D."','".$data[$i]->E."','".$data[$i]->F."','".$data[$i]->G."','".$data[$i]->H."','".$productname."','".$data[$i]->J."',".$data[$i]->K.",".$data[$i]->L.",".$data[$i]->M.",".$data[$i]->N.",".$data[$i]->O.",".$data[$i]->P.",".$data[$i]->Q.",".$data[$i]->R.",".$data[$i]->S.",".$data[$i]->T.",".$data[$i]->U.",".$data[$i]->V.",".$data[$i]->W.",".$data[$i]->X.",".$data[$i]->Y.",".$data[$i]->Z.",".$data[$i]->AA.",".$data[$i]->AB.",".$data[$i]->AC.",".$data[$i]->AD.",".$data[$i]->AE.",'".$data[$i]->AF."',".$data[$i]->AG.",'".$data[$i]->AH."','".$data[$i]->AI."','".$data[$i]->AJ."','".$data[$i]->AK."','".$data[$i]->AL."','".$data[$i]->AM."','".$data[$i]->AN."','".$data[$i]->AO."')";

				$replace = "insert into so_product values ('".$data[$i]->k_edit."','".$data[$i]->tg_edit."','".$data[$i]->kodepab."','".$pabname."','".$supname."','".$data[$i]->kd_gprod."','".$data[$i]->nm_gprod."','".$data[$i]->kodeprod."','".$productname."','".$data[$i]->barcode."',".$data[$i]->hpp_awal.",".$data[$i]->hpp.",".$data[$i]->hpp_avr.",".$data[$i]->hpp_akhir.",".$data[$i]->hpp_std.",".$data[$i]->prsn_khs.",".$data[$i]->prsn_min.",".$data[$i]->prsn_std.",".$data[$i]->prsn_std2.",".$data[$i]->prsn_std3.",".$data[$i]->hg_khs.",".$data[$i]->hg_min.",".$data[$i]->hg_std.",".$data[$i]->unit_std1.",".$data[$i]->unit_std2.",".$data[$i]->unit_std3.",".$data[$i]->hg_std1.",".$data[$i]->hg_std2.",".$data[$i]->hg_std3.",".$data[$i]->harga.",".$data[$i]->unit_max.",'".$data[$i]->al_kemas."',".$data[$i]->satuan.",'".$data[$i]->kemasan."','".$data[$i]->tgl_ubah."','".$data[$i]->jam_ubah."','".$data[$i]->alias_prod."','".$data[$i]->alias_nama."','".$data[$i]->kd_kemas."','".$data[$i]->flex."','".$data[$i]->line."') on duplicate key update namaprod = '".$productname."',hg_khs = ".$data[$i]->hg_khs.",hg_std = ".$data[$i]->hg_std.",hg_std2 = ".$data[$i]->hg_std2.",hg_std3 = ".$data[$i]->hg_std3.",unit_std2 = ".$data[$i]->unit_std2.",unit_std3 = ".$data[$i]->unit_std3.",flex = '".$data[$i]->flex."',line = '".$data[$i]->line."'";
				
				$this->db->query($replace);
			}
			else if ($data2->tablename == 'FK'){
				$replace = "insert into so_package values ('".$data[$i]->A."','".$data[$i]->B."','".$data[$i]->C."','".$data[$i]->D."',".$data[$i]->E.",'".$data[$i]->F."') on duplicate key update kd_kemas = '".$data[$i]->B."',satuan = '".$data[$i]->E."',old_kode = '".$data[$i]->F."'";

				$this->db->query($replace);
			}
			else if ($data2->tablename == 'F_LANG'){
				$customername = addslashes($data[$i]->C);
				$customeraddress = addslashes($data[$i]->D);

				$replace = "insert into so_customer values ('".$data[$i]->A."','".$data[$i]->B."','".$customername."','".$customeraddress."','".$data[$i]->E."','".$data[$i]->F."','".$data[$i]->G."',".$data[$i]->H.",".$data[$i]->I.",'".$data[$i]->J."',".$data[$i]->K.",'".$data[$i]->L."','".$data[$i]->M."','".$data[$i]->N."','".$data[$i]->O."','".$data[$i]->P."','".$data[$i]->Q."','".$data[$i]->R."','".$data[$i]->S."',0,0) on duplicate key update status = '".$data[$i]->A."',sub_rayon = '".$data[$i]->R."'";

				$this->db->query($replace);
			}
			else if ($data2->tablename == 'F_PABR'){
				$replace = "insert into so_factory values ('".$data[$i]->A."',".$data[$i]->E.",".$data[$i]->F.",".$data[$i]->G.",".$data[$i]->H.",".$data[$i]->I.",".$data[$i]->J.",".$data[$i]->K.") on duplicate key update sts_d = ".$data[$i]->E.",gros_1 = ".$data[$i]->F.",disc_1 = ".$data[$i]->G.",gros_2 = ".$data[$i]->H.",disc_2 = ".$data[$i]->I.",gros_3 = ".$data[$i]->J.",disc_3 = ".$data[$i]->K;

				$this->db->query($replace);
			}
			else if ($data2->tablename == 'MP'){
				$replace = "insert into so_sales values ('".$data[$i]->N."','".$data[$i]->K."','".$data[$i]->U."',".$data[$i]->AA.",".$data[$i]->AB.",".$data[$i]->AC.",".$data[$i]->AD.") on duplicate key update kodelang = '".$data[$i]->K."',jt_tempo = '".$data[$i]->U."',nildok = ".$data[$i]->AA.",aknildok = ".$data[$i]->AB.",nldokacu = ".$data[$i]->AC.",nlgiro = ".$data[$i]->AD;

				$this->db->query($replace);

				$clr = "delete from so_sales
						where nildok-aknildok-nldokacu-nlgiro = 0";

				$this->db->query($clr);
			}
			else if ($data2->tablename == 'ST'){
				$replace = "insert into so_stock values ('".$data[$i]->C."','".$data[$i]->D."',".$data[$i]->F.",'".$data[$i]->G."',".$data[$i]->H.",".$data[$i]->I.",".$data[$i]->J.",".$data[$i]->K.",".$data[$i]->L.") on duplicate key update satuan = ".$data[$i]->F.",kemasan = '".$data[$i]->G."',awal = ".$data[$i]->H.",beli = ".$data[$i]->I.",msk_lain = ".$data[$i]->J.",jual = ".$data[$i]->K.",klr_lain = ".$data[$i]->L;

				$this->db->query($replace);
			}
			else if ($data2->tablename == 'TA'){
				$replace = "insert into so_payment values ('".$data[$i]->A."','".$data[$i]->B."','".$data[$i]->C."','".$data[$i]->D."',".$data[$i]->E.",".$data[$i]->F.",".$data[$i]->G.",'".$data[$i]->H."','".$data[$i]->I."','".$data[$i]->J."','".$data[$i]->K."',".$data[$i]->L.") on duplicate key update status = '".$data[$i]->A."',tg_tagih = '".$data[$i]->C."',tg_dt = '".$data[$i]->D."',tunai = ".$data[$i]->E.",krbayar = ".$data[$i]->F.",giro = ".$data[$i]->G.",kd_jaja = '".$data[$i]->H."',nm_jaja = '".$data[$i]->I."',rayon = '".$data[$i]->J."',nm_ryon = '".$data[$i]->K."',nildok = ".$data[$i]->L;

				$this->db->query($replace);
			}
			else{
				$customername = addslashes($data[$i]->J);

				$replace = "insert into so_payment_detail values ('".$data[$i]->A."','".$data[$i]->B."','".$data[$i]->C."','".$data[$i]->D."','".$data[$i]->E."','".$data[$i]->F."','".$data[$i]->G."','".$data[$i]->H."','".$data[$i]->I."','".$customername."',".$data[$i]->K.",".$data[$i]->L.",".$data[$i]->M.",'".$data[$i]->N."','".$data[$i]->O."','".$data[$i]->P."','".$data[$i]->Q."','".$data[$i]->R."','".$data[$i]->S."','') on duplicate key update rek = '".$data[$i]->A."',tg_tagih = '".$data[$i]->C."',tg_dt = '".$data[$i]->D."',no_so = '".$data[$i]->E."',tg_so = '".$data[$i]->F."',tg_fak = '".$data[$i]->H."',kodelang = '".$data[$i]->I."',namalang = '".$customername."',tunai = ".$data[$i]->K.",krbayar = ".$data[$i]->L.",giro = ".$data[$i]->M.",nogiro = '".$data[$i]->N."',namabank = '".$data[$i]->O."',jtgiro = '".$data[$i]->P."',stsgr = '".$data[$i]->Q."',tglubah = '".$data[$i]->R."',no_acu1 = '".$data[$i]->S."'";

				$this->db->query($replace);
			}
		}

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();
		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}	
	}

	function exportExcel(){
		$sql = "select *
				from so_order
				where status = 0";

		$model = $this->db->query($sql)->result();

		$sql2 = "select *
				from so_order_detail
				where status = 0";

		$model2 = $this->db->query($sql2)->result();
		
		$this->load->library('excel');
		$this->excel->setActiveSheetIndex(0);
		$this->excel->getActiveSheet()->setTitle('sheet1');
		
		//Report Title
		$row = 1;
		$header = $row;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, "STATUS");
		$this->excel->getActiveSheet()->setCellValue('B'.$row, "KD_JUAL");
		$this->excel->getActiveSheet()->setCellValue('C'.$row, "STS_DO");
		$this->excel->getActiveSheet()->setCellValue('D'.$row, "NO_SO");
		$this->excel->getActiveSheet()->setCellValue('E'.$row, "TG_SO");
		$this->excel->getActiveSheet()->setCellValue('F'.$row, "NO_DO");
		$this->excel->getActiveSheet()->setCellValue('G'.$row, "TG_DO");
		$this->excel->getActiveSheet()->setCellValue('H'.$row, "NO_ACU");
		$this->excel->getActiveSheet()->setCellValue('I'.$row, "TG_ACU");
		$this->excel->getActiveSheet()->setCellValue('J'.$row, "KODELANG");
		$this->excel->getActiveSheet()->setCellValue('K'.$row, "NAMALANG");
		$this->excel->getActiveSheet()->setCellValue('L'.$row, "NM_JAJA");
		$this->excel->getActiveSheet()->setCellValue('M'.$row, "NO_FAK");
		$this->excel->getActiveSheet()->setCellValue('N'.$row, "TG_FAK");
		$this->excel->getActiveSheet()->setCellValue('O'.$row, "TAX");
		$this->excel->getActiveSheet()->setCellValue('P'.$row, "KD_SERI");
		$this->excel->getActiveSheet()->setCellValue('Q'.$row, "NO_TAX");
		$this->excel->getActiveSheet()->setCellValue('R'.$row, "TG_TAX");
		$this->excel->getActiveSheet()->setCellValue('S'.$row, "LAMA_BYR");
		$this->excel->getActiveSheet()->setCellValue('T'.$row, "JT_TEMPO");
		$this->excel->getActiveSheet()->setCellValue('U'.$row, "TOT_1");
		$this->excel->getActiveSheet()->setCellValue('V'.$row, "DISC");
		$this->excel->getActiveSheet()->setCellValue('W'.$row, "T_HPP");
		$this->excel->getActiveSheet()->setCellValue('X'.$row, "PPN");
		$this->excel->getActiveSheet()->setCellValue('Y'.$row, "METERAI");
		$this->excel->getActiveSheet()->setCellValue('Z'.$row, "NILDOK");
		$this->excel->getActiveSheet()->setCellValue('AA'.$row, "AKNILDOK");
		$this->excel->getActiveSheet()->setCellValue('AB'.$row, "NLDOKACU");
		$this->excel->getActiveSheet()->setCellValue('AC'.$row, "NLGIRO");
		$this->excel->getActiveSheet()->setCellValue('AD'.$row, "TG_EDIT");
		$this->excel->getActiveSheet()->setCellValue('AE'.$row, "TG_BALIK");
		$this->excel->getActiveSheet()->setCellValue('AF'.$row, "TG_TAGIH");
		$this->excel->getActiveSheet()->setCellValue('AG'.$row, "PAS_ENTR");
		$this->excel->getActiveSheet()->setCellValue('AH'.$row, "PAS_HRG");
		$this->excel->getActiveSheet()->setCellValue('AI'.$row, "PAS_CETAK");
		$this->excel->getActiveSheet()->setCellValue('AJ'.$row, "PAS_EDIT");
		$this->excel->getActiveSheet()->setCellValue('AK'.$row, "PAS_BALIK");
		$this->excel->getActiveSheet()->setCellValue('AL'.$row, "KET");
		$this->excel->getActiveSheet()->setCellValue('AM'.$row, "NO_ACU1");
		$this->excel->getActiveSheet()->setCellValue('AN'.$row, "KD_LOKASI");

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$header.':AN'.$header);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FF99d9ea');

		foreach($model as $order){
			$row+=1;

			$this->excel->getActiveSheet()->setCellValue('A'.$row, $order->status);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $order->kd_jual);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $order->sts_do);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $order->no_so);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $order->tg_so);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $order->no_do);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, $order->tg_do);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, $order->no_acu);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, $order->tg_acu);
			$this->excel->getActiveSheet()->setCellValue('J'.$row, $order->kodelang);
			$this->excel->getActiveSheet()->setCellValue('K'.$row, $order->namalang);
			$this->excel->getActiveSheet()->setCellValue('L'.$row, $order->nm_jaja);
			$this->excel->getActiveSheet()->setCellValue('M'.$row, $order->no_fak);
			$this->excel->getActiveSheet()->setCellValue('N'.$row, $order->tg_fak);
			$this->excel->getActiveSheet()->setCellValue('O'.$row, $order->tax);
			$this->excel->getActiveSheet()->setCellValue('P'.$row, $order->kd_seri);
			$this->excel->getActiveSheet()->setCellValue('Q'.$row, $order->no_tax);
			$this->excel->getActiveSheet()->setCellValue('R'.$row, $order->tg_tax);
			$this->excel->getActiveSheet()->setCellValue('S'.$row, $order->lama_byr);
			$this->excel->getActiveSheet()->setCellValue('T'.$row, $order->jt_tempo);
			$this->excel->getActiveSheet()->setCellValue('U'.$row, $order->tot_1);
			$this->excel->getActiveSheet()->setCellValue('V'.$row, $order->disc);
			$this->excel->getActiveSheet()->setCellValue('W'.$row, $order->t_hpp);
			$this->excel->getActiveSheet()->setCellValue('X'.$row, $order->ppn);
			$this->excel->getActiveSheet()->setCellValue('Y'.$row, $order->meterai);
			$this->excel->getActiveSheet()->setCellValue('Z'.$row, $order->nildok);
			$this->excel->getActiveSheet()->setCellValue('AA'.$row, $order->aknildok);
			$this->excel->getActiveSheet()->setCellValue('AB'.$row, $order->nldokacu);
			$this->excel->getActiveSheet()->setCellValue('AC'.$row, $order->nlgiro);
			$this->excel->getActiveSheet()->setCellValue('AD'.$row, $order->tg_edit);
			$this->excel->getActiveSheet()->setCellValue('AE'.$row, $order->tg_balik);
			$this->excel->getActiveSheet()->setCellValue('AF'.$row, $order->tg_tagih);
			$this->excel->getActiveSheet()->setCellValue('AG'.$row, $order->pas_entr);
			$this->excel->getActiveSheet()->setCellValue('AH'.$row, $order->pas_hrg);
			$this->excel->getActiveSheet()->setCellValue('AI'.$row, $order->pas_cetak);
			$this->excel->getActiveSheet()->setCellValue('AJ'.$row, $order->pas_edit);
			$this->excel->getActiveSheet()->setCellValue('AK'.$row, $order->pas_balik);
			$this->excel->getActiveSheet()->setCellValue('AL'.$row, $order->ket);
			$this->excel->getActiveSheet()->setCellValue('AM'.$row, $order->no_acu1);
			$this->excel->getActiveSheet()->setCellValue('AN'.$row, $order->kd_lokasi);
		}

		$objRow = $this->excel->getActiveSheet()->getStyle('A1');

		$this->excel->createSheet(1);
		$this->excel->setActiveSheetIndex(1);
		$this->excel->getActiveSheet()->setTitle('sheet2');
	
		$row = 1;
		$header = $row;

		$this->excel->getActiveSheet()->setCellValue('A'.$row, "STATUS");
		$this->excel->getActiveSheet()->setCellValue('B'.$row, "KD_JUAL");
		$this->excel->getActiveSheet()->setCellValue('C'.$row, "STS_DO");
		$this->excel->getActiveSheet()->setCellValue('D'.$row, "STS_P");
		$this->excel->getActiveSheet()->setCellValue('E'.$row, "STS_BNUS");
		$this->excel->getActiveSheet()->setCellValue('F'.$row, "NO_SO");
		$this->excel->getActiveSheet()->setCellValue('G'.$row, "TG_SO");
		$this->excel->getActiveSheet()->setCellValue('H'.$row, "NO_DO");
		$this->excel->getActiveSheet()->setCellValue('I'.$row, "TG_DO");
		$this->excel->getActiveSheet()->setCellValue('J'.$row, "NO_FAK");
		$this->excel->getActiveSheet()->setCellValue('K'.$row, "TG_FAK");
		$this->excel->getActiveSheet()->setCellValue('L'.$row, "KODELANG");
		$this->excel->getActiveSheet()->setCellValue('M'.$row, "NAMALANG");
		$this->excel->getActiveSheet()->setCellValue('N'.$row, "KODEPROD");
		$this->excel->getActiveSheet()->setCellValue('O'.$row, "NAMAPROD");
		$this->excel->getActiveSheet()->setCellValue('P'.$row, "NM_LAIN");
		$this->excel->getActiveSheet()->setCellValue('Q'.$row, "KD_LOKASI");
		$this->excel->getActiveSheet()->setCellValue('R'.$row, "KEMASAN");
		$this->excel->getActiveSheet()->setCellValue('S'.$row, "SATUAN");
		$this->excel->getActiveSheet()->setCellValue('T'.$row, "KEMAS_BKU");
		$this->excel->getActiveSheet()->setCellValue('U'.$row, "SATUAN_BKU");
		$this->excel->getActiveSheet()->setCellValue('V'.$row, "BANYAK");
		$this->excel->getActiveSheet()->setCellValue('W'.$row, "BONUS_1");
		$this->excel->getActiveSheet()->setCellValue('X'.$row, "BONUS_2");
		$this->excel->getActiveSheet()->setCellValue('Y'.$row, "HARGA");
		$this->excel->getActiveSheet()->setCellValue('Z'.$row, "T_HARGA");
		$this->excel->getActiveSheet()->setCellValue('AA'.$row, "T_BNUS1");
		$this->excel->getActiveSheet()->setCellValue('AB'.$row, "T_BNUS2");
		$this->excel->getActiveSheet()->setCellValue('AC'.$row, "P_DISC1");
		$this->excel->getActiveSheet()->setCellValue('AD'.$row, "P_DISC2");
		$this->excel->getActiveSheet()->setCellValue('AE'.$row, "P_DISC3");
		$this->excel->getActiveSheet()->setCellValue('AF'.$row, "T_DISC1");
		$this->excel->getActiveSheet()->setCellValue('AG'.$row, "T_DISC2");
		$this->excel->getActiveSheet()->setCellValue('AH'.$row, "T_DISC3");
		$this->excel->getActiveSheet()->setCellValue('AI'.$row, "NETTO");
		$this->excel->getActiveSheet()->setCellValue('AJ'.$row, "HPP");
		$this->excel->getActiveSheet()->setCellValue('AK'.$row, "T_HPP");
		$this->excel->getActiveSheet()->setCellValue('AL'.$row, "NO_ACU1");
		$this->excel->getActiveSheet()->setCellValue('AM'.$row, "ORDER");

		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$header.':AM'.$header);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FF99d9ea');

		foreach($model2 as $orderdetail){
			$row+=1;

			$this->excel->getActiveSheet()->setCellValue('A'.$row, $orderdetail->status);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $orderdetail->kd_jual);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $orderdetail->sts_do);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $orderdetail->sts_p);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $orderdetail->sts_bnus);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $orderdetail->no_so);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, $orderdetail->tg_so);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, $orderdetail->no_do);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, $orderdetail->tg_do);
			$this->excel->getActiveSheet()->setCellValue('J'.$row, $orderdetail->no_fak);
			$this->excel->getActiveSheet()->setCellValue('K'.$row, $orderdetail->tg_fak);
			$this->excel->getActiveSheet()->setCellValue('L'.$row, $orderdetail->kodelang);
			$this->excel->getActiveSheet()->setCellValue('M'.$row, $orderdetail->namalang);
			$this->excel->getActiveSheet()->setCellValue('N'.$row, $orderdetail->kodeprod);
			$this->excel->getActiveSheet()->setCellValue('O'.$row, $orderdetail->namaprod);
			$this->excel->getActiveSheet()->setCellValue('P'.$row, $orderdetail->nm_lain);
			$this->excel->getActiveSheet()->setCellValue('Q'.$row, $orderdetail->kd_lokasi);
			$this->excel->getActiveSheet()->setCellValue('R'.$row, $orderdetail->kemasan);
			$this->excel->getActiveSheet()->setCellValue('S'.$row, $orderdetail->satuan);
			$this->excel->getActiveSheet()->setCellValue('T'.$row, $orderdetail->kemas_bku);
			$this->excel->getActiveSheet()->setCellValue('U'.$row, $orderdetail->satuan_bku);
			$this->excel->getActiveSheet()->setCellValue('V'.$row, $orderdetail->banyak);
			$this->excel->getActiveSheet()->setCellValue('W'.$row, $orderdetail->bonus_1);
			$this->excel->getActiveSheet()->setCellValue('X'.$row, $orderdetail->bonus_2);
			$this->excel->getActiveSheet()->setCellValue('Y'.$row, $orderdetail->harga);
			$this->excel->getActiveSheet()->setCellValue('Z'.$row, $orderdetail->t_harga);
			$this->excel->getActiveSheet()->setCellValue('AA'.$row, $orderdetail->t_bnus1);
			$this->excel->getActiveSheet()->setCellValue('AB'.$row, $orderdetail->t_bnus2);
			$this->excel->getActiveSheet()->setCellValue('AC'.$row, $orderdetail->p_disc1);
			$this->excel->getActiveSheet()->setCellValue('AD'.$row, $orderdetail->p_disc2);
			$this->excel->getActiveSheet()->setCellValue('AE'.$row, $orderdetail->p_disc3);
			$this->excel->getActiveSheet()->setCellValue('AF'.$row, $orderdetail->t_disc1);
			$this->excel->getActiveSheet()->setCellValue('AG'.$row, $orderdetail->t_disc2);
			$this->excel->getActiveSheet()->setCellValue('AH'.$row, $orderdetail->t_disc3);
			$this->excel->getActiveSheet()->setCellValue('AI'.$row, $orderdetail->netto);
			$this->excel->getActiveSheet()->setCellValue('AJ'.$row, $orderdetail->hpp);
			$this->excel->getActiveSheet()->setCellValue('AK'.$row, $orderdetail->t_hpp);
			$this->excel->getActiveSheet()->setCellValue('AL'.$row, $orderdetail->no_acu1);
			$this->excel->getActiveSheet()->setCellValue('AM'.$row, $orderdetail->order);
		}

		$objRow = $this->excel->getActiveSheet()->getStyle('A1');
		
		$filename = 'order_'.date('Ymd-Hi').'.xls';
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;
		
		if(file_exists($filepath))
			unlink($filepath);
		
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter,$this->excel);
		
		exit;
	}

	function exportDbf(){
		$sql = "select *
				from so_order
				where status = 0";

		$model = $this->db->query($sql)->result();

		$dbf = array(
			array("STATUS","C",1),
			array("KD_JUAL","C",1),
			array("STS_DO","C",1),
			array("NO_SO","C",8),
			array("TG_SO","D"),
			array("NO_DO","C",8),
			array("TG_DO","D"),
			array("NO_ACU","C",8),
			array("TG_ACU","D"),
			array("KODELANG","C",6),
			array("NAMALANG","C",30),
			array("NM_JAJA","C",25),
			array("NO_FAK","C",8),
			array("TG_FAK","D"),
			array("TAX","C",1),
			array("KD_SERI","C",5),
			array("NO_TAX","C",16),
			array("TG_TAX","D"),
			array("LAMA_BYR","N",11,0),
			array("JT_TEMPO","D"),
			array("TOT_1","N",17,4),
			array("DISC","N",17,4),
			array("T_HPP","N",17,4),
			array("PPN","N",17,4),
			array("METERAI","N",17,4),
			array("NILDOK","N",17,4),
			array("AKNILDOK","N",17,4),
			array("NLDOKACU","N",17,4),
			array("NLGIRO","N",17,4),
			array("TG_EDIT","D"),
			array("TG_BALIK","D"),
			array("TG_TAGIH","D"),
			array("PAS_ENTR","C",3),
			array("PAS_HRG","C",3),
			array("PAS_CETAK","C",3),
			array("PAS_EDIT","C",3),
			array("PAS_BALIK","C",3),
			array("KET","C",10),
			array("NO_ACU1","C",10),
			array("KD_LOKASI","C",2)
		);

		if(!file_exists('C:\xampp\htdocs\test\dbf\HDSO'.substr(date("Y"),2).date("m").'.DBF')) {
			dbase_create('C:\xampp\htdocs\test\dbf\HDSO'.substr(date("Y"),2).date("m").'.DBF', $dbf);
		}

		$db = dbase_open('C:\xampp\htdocs\test\dbf\HDSO'.substr(date("Y"),2).date("m").'.DBF', 2);

		if ($db) {
			foreach($model as $order){
				dbase_add_record($db, array($order->status,
					$order->kd_jual,
					$order->sts_do,
					$order->no_so,
					DateTime::createFromFormat('Y-m-d H:i:s', $order->tg_so)->format('Ymd'),
					$order->no_do,
					$order->tg_do,
					$order->no_acu,
					$order->tg_acu,
					$order->kodelang,
					$order->namalang,
					$order->nm_jaja,
					$order->no_fak,
					$order->tg_fak,
					$order->tax,
					$order->kd_seri,
					$order->no_tax,
					$order->tg_tax,
					$order->lama_byr,
					DateTime::createFromFormat('Y-m-d H:i:s', $order->jt_tempo)->format('Ymd'),
					$order->tot_1,
					$order->disc,
					$order->t_hpp,
					$order->ppn,
					$order->meterai,
					$order->nildok,
					$order->aknildok,
					$order->nldokacu,
					$order->nlgiro,
					$order->tg_edit,
					$order->tg_balik,
					$order->tg_tagih,
					$order->pas_entr,
					$order->pas_hrg,
					$order->pas_cetak,
					$order->pas_edit,
					$order->pas_balik,
					$order->ket,
					$order->no_acu1,
					$order->kd_lokasi
				));
			}
			dbase_close($db);
		}

		$sql = "select *
				from so_order_detail
				where status = 0";

		$model2 = $this->db->query($sql)->result();

		$dbf2 = array(
			array("STATUS","C",1),
			array("KD_JUAL","C",1),
			array("STS_DO","C",1),
			array("STS_P","C",1),
			array("STS_BNUS","C",1),
			array("NO_SO","C",8),
			array("TG_SO","D"),
			array("NO_DO","C",8),
			array("TG_DO","D"),
			array("NO_FAK","C",8),
			array("TG_FAK","D"),
			array("KODELANG","C",6),
			array("NAMALANG","C",30),
			array("KODEPROD","C",10),
			array("NAMAPROD","C",30),
			array("NM_LAIN","C",30),
			array("KD_LOKASI","C",2),
			array("KEMASAN","C",15),
			array("SATUAN","N",11,0),
			array("KEMAS_BKU","C",15),
			array("SATUAN_BKU","N",11,0),
			array("BANYAK","N",10,2),
			array("BONUS_1","N",17,4),
			array("BONUS_2","N",17,4),
			array("HARGA","N",17,4),
			array("T_HARGA","N",17,4),
			array("T_BNUS1","N",17,4),
			array("T_BNUS2","N",17,4),
			array("P_DISC1","N",17,4),
			array("P_DISC2","N",17,4),
			array("P_DISC3","N",17,4),
			array("T_DISC1","N",17,4),
			array("T_DISC2","N",17,4),
			array("T_DISC3","N",17,4),
			array("NETTO","N",17,4),
			array("HPP","N",17,4),
			array("T_HPP","N",17,4),
			array("NO_ACU1","C",10),
			array("ORDER","N",10,2)
		);

		if(!file_exists('C:\xampp\htdocs\test\dbf\ITSO'.substr(date("Y"),2).date("m").'.DBF')) {
			dbase_create('C:\xampp\htdocs\test\dbf\ITSO'.substr(date("Y"),2).date("m").'.DBF', $dbf2);
		}

		$db2 = dbase_open('C:\xampp\htdocs\test\dbf\ITSO'.substr(date("Y"),2).date("m").'.DBF', 2);

		if ($db2) {
			foreach($model2 as $order_detail){
				dbase_add_record($db2, array($order_detail->status,
					$order_detail->kd_jual,
					$order_detail->sts_do,
					$order_detail->sts_p,
					$order_detail->sts_bnus,
					$order_detail->no_so,
					DateTime::createFromFormat('Y-m-d H:i:s', $order_detail->tg_so)->format('Ymd'),
					$order_detail->no_do,
					$order_detail->tg_do,
					$order_detail->no_fak,
					$order_detail->tg_fak,
					$order_detail->kodelang,
					$order_detail->namalang,
					$order_detail->kodeprod,
					$order_detail->namaprod,
					$order_detail->nm_lain,
					$order_detail->kd_lokasi,
					$order_detail->kemasan,
					$order_detail->satuan,
					$order_detail->kemas_bku,
					$order_detail->satuan_bku,
					$order_detail->banyak,
					$order_detail->bonus_1,
					$order_detail->bonus_2,
					$order_detail->harga,
					$order_detail->t_harga,
					$order_detail->t_bnus1,
					$order_detail->t_bnus2,
					$order_detail->p_disc1,
					$order_detail->p_disc2,
					$order_detail->p_disc3,
					$order_detail->t_disc1,
					$order_detail->t_disc2,
					$order_detail->t_disc3,
					$order_detail->netto,
					$order_detail->hpp,
					$order_detail->t_hpp,
					$order_detail->no_acu1,
					$order_detail->order
				));
			}
			dbase_close($db2);
		}

		if(file_exists('D:\BACKUP\HDSO'.substr(date("Y"),2).date("m").'.NTX'))
			unlink('D:\BACKUP\HDSO'.substr(date("Y"),2).date("m").'.NTX');
		if(file_exists('D:\BACKUP\ITSO'.substr(date("Y"),2).date("m").'.NTX'))
			unlink('D:\BACKUP\ITSO'.substr(date("Y"),2).date("m").'.NTX');

		$this->db->trans_begin();

		$update = "update so_order
				   set status = 1
				   where status = 0";

		$this->db->query($update);

		$update2 = "update so_order_detail
				   set status = 1
				   where status = 0";

		$this->db->query($update2);

		if ($this->db->trans_status() === FALSE)
		{
		    $this->db->trans_rollback();
		    $result = array('status' => 'gagal');
		    print json_encode($result);
		}
		else
		{
		    $this->db->trans_commit();
		    $result = array('status' => 'sukses');
		    print json_encode($result);
		}	
	}
}
?>