<?php
class Service extends CI_Controller
{
	function closedate($oid)
	{
		echo $this->get_tanggal_closing($oid);
	}
	
	function check($oid, $cdate)
	{
		$myDateTime =new DateTime($this->get_tanggal_closing($oid));
		$newDateString = $myDateTime->format('d-m-Y');
		$get_info = $this->get_closing_information($oid, $cdate);
		$expense = $this->get_total_expense($oid, $cdate);

		echo ($get_info->TotalJual == '' ? '0' : $get_info->TotalJual).';'.
			 ($get_info->TotalVoucher == '' ? '0' : $get_info->TotalVoucher).';'.
			 ($get_info->TotalDiscount == '' ? '0' : $get_info->TotalDiscount).';'.
			 ($get_info->TotalCash == '' ? '0' : $get_info->TotalCash).';'.
			 ($get_info->TotalCreditCard == '' ? '0' : $get_info->TotalCreditCard).';'.
			 ($expense->total_expense == '' ? '0' : $expense->total_expense).';'.
			 ($get_info->jmlCustomer == '' ? '0' : $get_info->jmlCustomer);
	}
	
	function get_closing_information($oid, $cdate)
	{
		$sql = "SELECT SUM(JmlPenjualan) AS `TotalJual`, SUM(JmlVoucher) AS `TotalVoucher`, SUM(JmlDiscount) AS `TotalDiscount`, SUM(JmlTunai) AS `TotalCash`, SUM(JmlCreditCard) AS `TotalCreditCard`, SUM(JmCust) AS `jmlCustomer`
				FROM `outlet_sales_orders` A INNER JOIN `master_outlets` B ON A.KdOutlet = B.other_code
				WHERE A.SdhBayar = 'T' AND A.tglClosing = '".$cdate."' AND B.outlets_id = ".$oid;
		$result = $this->db->query($sql)->row();
		return $result;
	}
	
	function get_total_expense($oid, $cdate)
	{
		$sql = "SELECT SUM(qty * price) AS total_expense
				FROM `outlet_purchases` A INNER JOIN `outlet_purchase_details` B on A.id = B.purchase_id
				WHERE is_cons_bon = 0 AND closing_date = '".$cdate."' AND outlet_id = ".$oid;
		$result = $this->db->query($sql)->row();
		return $result;
	}
	
	function get_tanggal_closing($oid)
	{
		$sql = "select value from outlet_config where code = 'closing_date' and outlet_id = ".$oid;
		$result = $this->db->query($sql)->row();
		return $result->value;
	}
	
	function close($oid, $cdate)
	{
		$get_info = $this->get_closing_information($oid, $cdate);
		
		if($get_info->TotalJual > 0)
		{
			$sql = "UPDATE `outlet_config` SET `value` = DATE_ADD(CAST(value AS DATE), INTERVAL 1 DAY)
					WHERE code='closing_date' AND outlet_id = ".$oid;
			$this->db->trans_begin();

			$obj = array('outlet_id'=>$oid,
					'closing_date' => $cdate,
					'created_at' => date("Y-m-d H:i:s"),
					'user_closing'=>0,
					'sum_sales'=> $get_info->TotalJual,
					'sum_discount'=>$get_info->TotalDiscount,
					'sum_credits'=>$get_info->TotalCreditCard,
					'sum_customer'=>$get_info->jmlCustomer,
					'sum_cash' => $get_info->TotalCash);

			$this->db->insert('log_closing', $obj);
					
			$result = $this->db->query($sql);

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				echo "Failed";
			}
			else
			{
				$this->db->trans_commit();
				$sql = "SELECT `value` FROM `outlet_config` WHERE code='closing_date' AND outlet_id = ".$oid;
				$result = $this->db->query($sql)->row();
				echo 'Success;'.$result->value;
			}
		} else {
			echo "Failed";
		}
	}
	
	function wam($oid, $cdate)
	{
		$sql = "SELECT B.menu_id, C.menu_code, C.menu_name, B.qty, B.comment
				FROM `outlet_menu_waste` A INNER JOIN `outlet_menu_waste_details` B ON A.id = B.waste_menu_id
					INNER JOIN `master_menus` C ON B.menu_id = C.menu_id
				WHERE A.outlet_id = ".$oid." AND A.closing_date = '".$cdate."'
				ORDER BY C.menu_name";
		$result = $this->db->query($sql)->result_array();
		$this->load->view('service/wam', array('records' => $result));
	}
	
	function wap($oid, $cdate)
	{
		$sql = "SELECT B.product_id, C.product_code, C.product_name, B.qty, B.unit_small, B.comment
				FROM `outlet_product_waste` A INNER JOIN `outlet_product_waste_details` B ON A.id = B.waste_id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE A.outlet_id = ".$oid." AND A.closing_date = '".$cdate."'
				ORDER BY C.product_name";
		$result = $this->db->query($sql)->result_array();
		$this->load->view('service/wap', array('records' => $result));
	}
	
	function wapJson($oid, $cdate)
	{
		$sql = "SELECT B.product_id, C.product_code, C.product_name, B.qty, B.unit_small, B.comment
				FROM `outlet_product_waste` A INNER JOIN `outlet_product_waste_details` B ON A.id = B.waste_id
					INNER JOIN `master_products` C ON B.product_id = C.product_id
				WHERE A.outlet_id = ".$oid." AND A.closing_date = '".$cdate."'
				ORDER BY C.product_name";
		$result = $this->db->query($sql)->result_array();
		
		header('content-type: application/json; charset=utf-8');
		echo json_encode($result);
	}
}