<?php /**
* 
*/
class Waste extends CI_Controller
{
	function index()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
			echo json_encode($this->generateReport($data->Reports));
	}
	
	function generateReport($data)
	{
		if($data->group == 'products')
		{
			$fields = array(
				array('code'=>'product_id', 'title'=>'ID', 'width'=>5), 
				array('code'=>'product_code', 'title'=>'Kode', 'width'=>8),
				array('code'=>'product_name', 'title'=> 'Nama Product', 'width'=>40), 
				array('code'=>'unit', 'title'=> 'Satuan', 'width'=>20, 'width'=>8), 
				array('code'=>'total', 'title'=> 'Total'));
		} elseif($data->group == 'menus')
		{
			$fields = array(
				array('code'=>'menu_id', 'title'=>'ID', 'width'=>5),
				array('code'=>'menu_code', 'title'=>'Kode', 'width'=>8), 
				array('code'=>'menu_name', 'title'=> 'Nama Menu', 'width'=>40), 
				array('code'=>'total', 'title'=> 'Total', 'width'=>8));
		}
		
		$this->load->model('report_waste');
		if($data->viewtype == 'total')
			return $this->report_waste->viewTotal($data, $fields);
		else if($data->viewtype == 'monthly')
			return $this->report_waste->viewMonthly($data, $fields);
		else
			return $this->report_waste->viewDaily($data, $fields);
	}
	
	function export()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
		{
			if($data->Reports->group == 'products')
				$label = 'P';
			elseif($data->Reports->group == 'menus')
				$label = 'M';
			
			$result = $this->generateReport($data->Reports);
			$this->load->model('outlets');
			$outlet_name = (isset($data->Reports->outlet_id)) && ($data->Reports->outlet_id * 1) > 0 ? $this->outlets->getOutletName($data->Reports->outlet_id) : 'All Outlet';
			$header_view = array();
			$header_view[] = 'Outlet : '.$outlet_name;
			$header_view[] = 'Periode : '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end;
			$filename = $data->label.$label.($outlet_name == '' ? '' : ' '.$outlet_name).' '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end.' '.$data->Reports->viewtype.'.xls';
			$this->load->model('Export_Excel');
			$this->Export_Excel->runExport($data->title, $header_view, $result['fields'], $result['field_values'], $filename);
		}
	}
} ?>