<?php /**
* 
*/
class Sale_Menu extends CI_Controller
{
	function index()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
		{
			//$fields = array('menu_id', 'menu_code', 'menu_name', 'price');
			if($data->Reports->viewtype == 'total')
				$this->viewTotal($data->Reports);
			else if($data->Reports->viewtype == 'monthly')
				$this->viewMonthly($data->Reports);
			else
				$this->viewDaily($data->Reports);
		}
	}

	function runQuery($_sql, $data)
	{
		$sql = "SELECT A.menu_id, B.menu_code, B.menu_name, fc_format_rupiah(A.price) AS price, fc_format_number(SUM(A.qty)) AS `total` ".$_sql."
				FROM `outlet_sales_order_sold_menu` A INNER JOIN `master_menus` B ON A.menu_id = B.menu_id
				WHERE A.closing_date BETWEEN '".$data->periode_start."' AND '".$data->periode_end."' ".(isset($data->outlet_id) ? " AND A.outlet_id = ".$data->outlet_id : '')." 
				GROUP BY A.menu_id, B.menu_code, B.menu_name, A.price
				ORDER BY B.menu_name";
		return $this->db->query($sql)->result();
	}
	
	function viewTotal($data)
	{
		$result = $this->runQuery('', $data);
		echo json_encode(array('fields'=>array(), 'field_values'=>$result));
	}
	
	function viewMonthly($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = new DateTime($start->format('Y').'-'.$start->format('m').'-01');
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ym');
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m') = '".$_newDate->format('Ym')."' THEN A.qty ELSE 0 END)) AS `q".$_newDate->format('Ym')."`";
			$_newDate->add(new DateInterval("P1M"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
	
	function viewDaily($data)
	{
		$start = new DateTime($data->periode_start);
		$end = new DateTime($data->periode_end);

		$_newDate = clone $start;
		$fields = array();
		$sql = '';
		while($_newDate <= $end)
		{
			$fields[] = $_newDate->format('Ymd');
			$sql .= ", fc_format_number(SUM(CASE WHEN DATE_FORMAT(A.closing_date,'%Y%m%d') = '".$_newDate->format('Ymd')."' THEN A.qty ELSE 0 END)) AS `q".$_newDate->format('Ymd')."`";
			$_newDate->add(new DateInterval("P1D"));
		}
		
		$result = $this->runQuery($sql, $data);
		echo json_encode(array('fields'=>$fields, 'field_values'=>$result));
	}
} ?>