<?php /**
* 
*/
class Purchased extends CI_Controller
{
	function index()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
			echo json_encode($this->generateReport($data->Reports));
	}
	
	function generateReport($data)
	{
		$fields = array(
				array('code'=>'product_id', 'title'=>'ID', 'width'=>5), 
				array('code'=>'product_code', 'title'=>'Kode', 'width'=>8), 
				array('code'=>'product_name', 'title'=> 'Nama Product', 'width'=>40), 
				array('code'=>'unit', 'title'=> 'Satuan', 'width'=>20), 
				array('code'=>'total', 'title'=> 'Total', 'width'=>8));
		$this->load->model('report_purchased');
		if($data->viewtype == 'total')
			return $this->report_purchased->viewTotal($data, $fields);
		else if($data->viewtype == 'monthly')
			return $this->report_purchased->viewMonthly($data, $fields);
		else
			return $this->report_purchased->viewDaily($data, $fields);
	}
	
	function export()
	{
		$data = json_decode(file_get_contents('php://input'));
		if(isset($data->Reports))
		{
			$result = $this->generateReport($data->Reports);
			$this->load->model('outlets');
			$outlet_name = (isset($data->Reports->outlet_id)) && ($data->Reports->outlet_id * 1) > 0 ? $this->outlets->getOutletName($data->Reports->outlet_id) : 'All Outlet';
			$header_view = array();
			$header_view[] = 'Outlet : '.$outlet_name;
			$header_view[] = 'Periode : '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end;
			$filename = $data->label.($outlet_name == '' ? '' : ' '.$outlet_name).' '.$data->Reports->periode_start.' s.d '.$data->Reports->periode_end.' '.$data->Reports->viewtype.'.xls';
			$this->load->model('Export_Excel');
			$this->Export_Excel->runExport($data->title, $header_view, $result['fields'], $result['field_values'], $filename);
		}
	}
} ?>