<?php /**
* 
*/
class Products extends CI_Controller
{
	function index()
	{
		$result = $this->find_all();
		echo json_encode($result);
	}

	
	function create()
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Products))
			{
				$data = $data->Products;
				$result = $this->db->insert('master_products',$data);
				$result = $this->findby_pk($this->db->insert_id());
				$this->histories('create');

				echo '{"success":{"msg":"Data produk BERHASIL disimpan !"}, "produk":'.json_encode($result).'}';
			} else {
				echo json_encode(array('categories'=>$this->find_all_categories(), 'groups'=>$this->find_all_groups()));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function update($id)
	{
		try {
			$data = json_decode(file_get_contents('php://input'));
			if(isset($data->Products))
			{
				$data = $data->Products;
				$this->db->where('product_id', $id);
				$result = $this->db->update('master_products',$data);
				$result = $this->findby_pk($id);
				$this->histories('update');

				echo '{"success":{"msg":"Data produk BERHASIL disimpan !"}, "produk":'.json_encode($result).'}';
			} else {
				$result = $this->findby_pk($id);
				echo json_encode(array(
							'list'=>$result,
							'menus'=>$this->find_menus($id)));
			}
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menyimpan data produk !", "text":'. $e->getMessage() .'}}';
		}
	}

	function delete($id)
	{
		try {
			$this->db->where('product_id', $id);
			$this->db->delete('master_products');
			$this->histories('delete');
			$result = $this->find_all();
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL menghapus data produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function view($id)
	{
		try {
			$result = $this->findby_pk($id);
			echo json_encode($result);
		} catch(PDOException $e) {
			echo '{"error":{"msg":"GAGAL mengambil data produk !", "text":'. $e->getMessage() .'}}';
		}
	}
	
	function getActiveProduct()
	{
		$sql = "select * from master_products where is_active = 1 AND product_type = 'product'";
		$result = $this->db->query($sql)->result();
		echo json_encode($result);
	}
	
	function find_all()
	{
		//$sql = "select * from master_products where product_type = 'product' order by product_name";
		$sql = "select * from master_products where is_sent_to_outlet = 1 order by product_name";
		return $this->db->query($sql)->result();
	}

	function findby_pk($id)
	{
		$id_ = addslashes($id);
		$sql = "select * from master_products where is_sent_to_outlet = 1 and product_id= ".$id_;
		return $this->db->query($sql)->result();
	}
	
	function find_all_categories()
	{
		$sql = "select * from master_product_categories";
		return $this->db->query($sql)->result();
	}
	
	function find_all_groups()
	{
		$sql = "select * from master_product_groups";
		return $this->db->query($sql)->result();
	}

	function histories($treatment){
		$log_history = array('treatment' =>$treatment ,'date_time' =>date("Y-m-d H:i:s"),'author_id'=>$this->session->userdata('author_id'),
				'datatable'=>'Product');
				$this->db->insert('log_history',$log_history);
	}

	function find_menus($id)
	{
		$sql = "SELECT A.*, B.menu_code, B.menu_name, B.is_active 
				FROM `master_menu_compositions` A INNER JOIN `master_menus` B ON A.menu_id = B.menu_id 
				WHERE A.product_id = ".$id;
		return $this->db->query($sql)->result();
	}
	
	function export()
	{
		$sql = "SELECT *, IF(is_active = 1, 'Aktif', 'Tidak Aktif') AS status FROM `master_products` WHERE product_type = 'product' ORDER BY product_name";
		$model = $this->db->query($sql)->result();
		
		$this->load->library('excel');
		$this->excel->setActiveSheetIndex(0);
		$this->excel->getActiveSheet()->setTitle('sheet1');
		
		//Report Title
		$row = 1;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "DAFTAR PRODUK MUJIGAE");
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setSize(16);
		$this->excel->getActiveSheet()->getStyle('A'.$row)->getFont()->setBold(true);
		
		$row++;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "Aplikasi Inventory Web");
		
		$row+=2; $header_start = $row;
		$this->excel->getActiveSheet()->setCellValue('A'.$row, "ID");
		$this->excel->getActiveSheet()->setCellValue('B'.$row, "KODE");
		$this->excel->getActiveSheet()->setCellValue('C'.$row, "NAMA");
		$this->excel->getActiveSheet()->setCellValue('D'.$row, "HARGA");
		$this->excel->getActiveSheet()->setCellValue('E'.$row, "HARGA GANTI");
		$this->excel->getActiveSheet()->setCellValue('F'.$row, "STN.BESAR");
		$this->excel->getActiveSheet()->setCellValue('G'.$row, "KONVERSI");
		$this->excel->getActiveSheet()->setCellValue('H'.$row, "STN.KECIL");
		$this->excel->getActiveSheet()->setCellValue('I'.$row, "STATUS");
		
		$this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(40);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
		$this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
		$this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(12);
		$this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
		
		$objRow = $this->excel->getActiveSheet()->getStyle('A'.$row.':I'.$row);
		$objRow->getFont()->setBold(true);
		$objRow->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objRow->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
		$objRow->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFb6dde8');
		
		$body_start = 0;
		foreach($model as $product)
		{
			$row+=1;
			if ($body_start == 0) $body_start = $row;
			$this->excel->getActiveSheet()->setCellValue('A'.$row, $product->product_id);
			$this->excel->getActiveSheet()->setCellValue('B'.$row, $product->product_code);
			$this->excel->getActiveSheet()->setCellValue('C'.$row, $product->product_name);
			$this->excel->getActiveSheet()->setCellValue('D'.$row, $product->price);
			$this->excel->getActiveSheet()->setCellValue('E'.$row, $product->price_change);
			$this->excel->getActiveSheet()->setCellValue('F'.$row, $product->unit_large);
			$this->excel->getActiveSheet()->setCellValue('G'.$row, $product->conversion);
			$this->excel->getActiveSheet()->setCellValue('H'.$row, $product->unit_small);
			$this->excel->getActiveSheet()->setCellValue('I'.$row, $product->status);
		}
		
		$this->excel->getActiveSheet()
					->getStyle('D'.$body_start.':E'.$row)
					->getNumberFormat()
					->setFormatCode('"Rp "#,###');
		
		$this->excel->getActiveSheet()
					->getStyle('G'.$body_start.':G'.$row)
					->getNumberFormat()
					->setFormatCode('#,###');
		
		$styleArray = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$this->excel->getActiveSheet()->getStyle('A'.$header_start.':I'.$row)->applyFromArray($styleArray);
		
		unset($styleArray);
		
		$filename = 'Master Produk '.date('Ymd-Hi').'.xls';
		$filepath = realpath(FCPATH).'/exports/'.$filename;
		$fileurl = "exports/".$filename;
		
		if(file_exists($filepath))
			unlink($filepath);
		
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save($filepath);
		echo $fileurl;
		
		$this->excel->disconnectWorksheets();
		unset($objWriter, $this->excel);
		
		exit;
	}
} ?>