/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.action;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.action.GoToAction;
import java.io.IOException;

public class PDFAction {
    private String type;
    private PDFObject next;

    public PDFAction(String type) {
        this.type = type;
    }

    public static PDFAction getAction(PDFObject obj, PDFObject root) throws IOException {
        PDFObject typeObj = obj.getDictRef("S");
        if (typeObj == null) {
            throw new PDFParseException("No action type in object: " + obj);
        }
        GoToAction action = null;
        String type = typeObj.getStringValue();
        if (!type.equals("GoTo")) {
            throw new PDFParseException("Unknown Action type: " + type);
        }
        action = new GoToAction(obj, root);
        PDFObject nextObj = obj.getDictRef("Next");
        if (nextObj != null) {
            action.setNext(nextObj);
        }
        return action;
    }

    public String getType() {
        return this.type;
    }

    public PDFObject getNext() {
        return this.next;
    }

    public void setNext(PDFObject next) {
        this.next = next;
    }
}

